/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.record.io;

import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.OutputStreamWriter;
import org.apache.flink.api.java.record.io.TextInputFormat;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.core.fs.FileInputSplit;
import org.apache.flink.types.Record;
import org.apache.flink.types.StringValue;
import org.junit.Assert;
import org.junit.Test;

public class TextInputFormatTest {
    @Test
    public void testPositionBug() {
        String FIRST = "First line";
        String SECOND = "Second line";
        try {
            File tempFile = File.createTempFile("TextInputFormatTest", "tmp");
            tempFile.deleteOnExit();
            tempFile.setWritable(true);
            FileWriter writer = new FileWriter(tempFile);
            writer.append("First line").append('\n');
            writer.append("Second line").append('\n');
            writer.close();
            TextInputFormat inputFormat = new TextInputFormat();
            inputFormat.setFilePath(tempFile.toURI().toString());
            Configuration parameters = new Configuration();
            inputFormat.configure(parameters);
            FileInputSplit[] splits = inputFormat.createInputSplits(1);
            Assert.assertTrue((String)"expected at least one input split", (splits.length >= 1 ? 1 : 0) != 0);
            inputFormat.open(splits[0]);
            Record r = new Record();
            Assert.assertNotNull((String)"Expecting first record here", (Object)inputFormat.nextRecord((Object)r));
            Assert.assertEquals((Object)"First line", (Object)((StringValue)r.getField(0, StringValue.class)).getValue());
            Assert.assertNotNull((String)"Expecting second record here", (Object)inputFormat.nextRecord((Object)r));
            Assert.assertEquals((Object)"Second line", (Object)((StringValue)r.getField(0, StringValue.class)).getValue());
            Assert.assertNull((String)"The input file is over", (Object)inputFormat.nextRecord((Object)r));
        }
        catch (Throwable t) {
            System.err.println("test failed with exception: " + t.getMessage());
            t.printStackTrace(System.err);
            Assert.fail((String)"Test erroneous");
        }
    }

    @Test
    public void testRemovingTrailingCR() {
        this.testRemovingTrailingCR("\n", "\n");
        this.testRemovingTrailingCR("\r\n", "\n");
        this.testRemovingTrailingCR("|", "|");
        this.testRemovingTrailingCR("|", "\n");
    }

    private void testRemovingTrailingCR(String lineBreaker, String delimiter) {
        File tempFile = null;
        String FIRST = "First line";
        String SECOND = "Second line";
        String CONTENT = FIRST + lineBreaker + SECOND + lineBreaker;
        try {
            tempFile = File.createTempFile("TextInputFormatTest", "tmp");
            tempFile.deleteOnExit();
            tempFile.setWritable(true);
            OutputStreamWriter wrt = new OutputStreamWriter(new FileOutputStream(tempFile));
            wrt.write(CONTENT);
            wrt.close();
            TextInputFormat inputFormat = new TextInputFormat();
            inputFormat.setFilePath(tempFile.toURI().toString());
            Configuration parameters = new Configuration();
            inputFormat.configure(parameters);
            inputFormat.setDelimiter(delimiter);
            FileInputSplit[] splits = inputFormat.createInputSplits(1);
            inputFormat.open(splits[0]);
            Record r = new Record();
            if (delimiter.equals("\n") && (lineBreaker.equals("\n") || lineBreaker.equals("\r\n")) || lineBreaker.equals(delimiter)) {
                Assert.assertNotNull((String)"Expecting first record here", (Object)inputFormat.nextRecord((Object)r));
                Assert.assertEquals((Object)FIRST, (Object)((StringValue)r.getField(0, StringValue.class)).getValue());
                Assert.assertNotNull((String)"Expecting second record here", (Object)inputFormat.nextRecord((Object)r));
                Assert.assertEquals((Object)SECOND, (Object)((StringValue)r.getField(0, StringValue.class)).getValue());
                Assert.assertNull((String)"The input file is over", (Object)inputFormat.nextRecord((Object)r));
            } else {
                Assert.assertNotNull((String)"Expecting first record here", (Object)inputFormat.nextRecord((Object)r));
                Assert.assertEquals((Object)CONTENT, (Object)((StringValue)r.getField(0, StringValue.class)).getValue());
            }
        }
        catch (Throwable t) {
            System.err.println("test failed with exception: " + t.getMessage());
            t.printStackTrace(System.err);
            Assert.fail((String)"Test erroneous");
        }
    }
}

