/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.record.io;

import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import org.apache.flink.api.java.record.io.FixedLengthInputFormat;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.core.fs.FileInputSplit;
import org.apache.flink.core.fs.Path;
import org.apache.flink.types.IntValue;
import org.apache.flink.types.Record;
import org.apache.flink.types.Value;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class FixedLenghtInputFormatTest {
    protected Configuration config;
    protected File tempFile;
    private final FixedLengthInputFormat format = new MyFixedLengthInputFormat();

    @Before
    public void setup() {
        this.format.setFilePath("file:///some/file/that/will/not/be/read");
    }

    @After
    public void setdown() throws Exception {
        if (this.format != null) {
            this.format.close();
        }
        if (this.tempFile != null) {
            this.tempFile.delete();
        }
    }

    @Test
    public void testOpen() throws IOException {
        int[] fileContent = new int[]{1, 2, 3, 4, 5, 6, 7, 8};
        FileInputSplit split = this.createTempFile(fileContent);
        Configuration parameters = new Configuration();
        parameters.setInteger("pact.fix-input.record-length", 8);
        this.format.configure(parameters);
        this.format.open(split);
        Assert.assertEquals((long)0L, (long)this.format.getSplitStart());
        Assert.assertEquals((long)0L, (long)(this.format.getReadBufferSize() % 8));
        this.format.close();
        parameters.setInteger("pact.fix-input.record-length", 13);
        this.format.configure(parameters);
        this.format.close();
        this.format.open(split);
        Assert.assertEquals((long)0L, (long)(this.format.getReadBufferSize() % 13));
        this.format.close();
        parameters.setInteger("pact.fix-input.record-length", 27);
        this.format.configure(parameters);
        this.format.close();
        this.format.open(split);
        Assert.assertEquals((long)0L, (long)(this.format.getReadBufferSize() % 27));
        this.format.close();
    }

    @Test
    public void testRead() throws IOException {
        int[] fileContent = new int[]{1, 2, 3, 4, 5, 6, 7, 8};
        FileInputSplit split = this.createTempFile(fileContent);
        Configuration parameters = new Configuration();
        parameters.setInteger("pact.fix-input.record-length", 8);
        this.format.configure(parameters);
        this.format.open(split);
        Record record = new Record();
        Assert.assertNotNull((Object)this.format.nextRecord(record));
        Assert.assertEquals((long)1L, (long)((IntValue)record.getField(0, IntValue.class)).getValue());
        Assert.assertEquals((long)2L, (long)((IntValue)record.getField(1, IntValue.class)).getValue());
        Assert.assertNotNull((Object)this.format.nextRecord(record));
        Assert.assertEquals((long)3L, (long)((IntValue)record.getField(0, IntValue.class)).getValue());
        Assert.assertEquals((long)4L, (long)((IntValue)record.getField(1, IntValue.class)).getValue());
        Assert.assertNotNull((Object)this.format.nextRecord(record));
        Assert.assertEquals((long)5L, (long)((IntValue)record.getField(0, IntValue.class)).getValue());
        Assert.assertEquals((long)6L, (long)((IntValue)record.getField(1, IntValue.class)).getValue());
        Assert.assertNotNull((Object)this.format.nextRecord(record));
        Assert.assertEquals((long)7L, (long)((IntValue)record.getField(0, IntValue.class)).getValue());
        Assert.assertEquals((long)8L, (long)((IntValue)record.getField(1, IntValue.class)).getValue());
        Assert.assertNull((Object)this.format.nextRecord(record));
        Assert.assertTrue((boolean)this.format.reachedEnd());
    }

    @Test
    public void testReadFail() throws IOException {
        int[] fileContent = new int[]{1, 2, 3, 4, 5, 6, 7, 8, 9};
        FileInputSplit split = this.createTempFile(fileContent);
        Configuration parameters = new Configuration();
        parameters.setInteger("pact.fix-input.record-length", 8);
        this.format.configure(parameters);
        this.format.open(split);
        Record record = new Record();
        try {
            Assert.assertNotNull((Object)this.format.nextRecord(record));
            Assert.assertEquals((long)1L, (long)((IntValue)record.getField(0, IntValue.class)).getValue());
            Assert.assertEquals((long)2L, (long)((IntValue)record.getField(1, IntValue.class)).getValue());
            Assert.assertNotNull((Object)this.format.nextRecord(record));
            Assert.assertEquals((long)3L, (long)((IntValue)record.getField(0, IntValue.class)).getValue());
            Assert.assertEquals((long)4L, (long)((IntValue)record.getField(1, IntValue.class)).getValue());
            Assert.assertNotNull((Object)this.format.nextRecord(record));
            Assert.assertEquals((long)5L, (long)((IntValue)record.getField(0, IntValue.class)).getValue());
            Assert.assertEquals((long)6L, (long)((IntValue)record.getField(1, IntValue.class)).getValue());
            Assert.assertNotNull((Object)this.format.nextRecord(record));
            Assert.assertEquals((long)7L, (long)((IntValue)record.getField(0, IntValue.class)).getValue());
            Assert.assertEquals((long)8L, (long)((IntValue)record.getField(1, IntValue.class)).getValue());
            Assert.assertNull((Object)this.format.nextRecord(record));
        }
        catch (IOException ioe) {
            Assert.assertTrue((boolean)ioe.getMessage().equals("Unable to read full record"));
        }
    }

    private FileInputSplit createTempFile(int[] contents) throws IOException {
        this.tempFile = File.createTempFile("test_contents", "tmp");
        this.tempFile.deleteOnExit();
        DataOutputStream dos = new DataOutputStream(new FileOutputStream(this.tempFile));
        for (int i : contents) {
            dos.writeInt(i);
        }
        dos.close();
        return new FileInputSplit(0, new Path(this.tempFile.toURI().toString()), 0L, this.tempFile.length(), new String[]{"localhost"});
    }

    private final class MyFixedLengthInputFormat
    extends FixedLengthInputFormat {
        private static final long serialVersionUID = 1L;
        IntValue p1 = new IntValue();
        IntValue p2 = new IntValue();

        private MyFixedLengthInputFormat() {
        }

        public boolean readBytes(Record target, byte[] buffer, int startPos) {
            int v1 = 0;
            v1 = (v1 | buffer[startPos + 0]) << 8;
            v1 = (v1 | buffer[startPos + 1]) << 8;
            v1 = (v1 | buffer[startPos + 2]) << 8;
            this.p1.setValue(v1 |= buffer[startPos + 3]);
            int v2 = 0;
            v2 = (v2 | buffer[startPos + 4]) << 8;
            v2 = (v2 | buffer[startPos + 5]) << 8;
            v2 = (v2 | buffer[startPos + 6]) << 8;
            this.p2.setValue(v2 |= buffer[startPos + 7]);
            target.setField(0, (Value)this.p1);
            target.setField(1, (Value)this.p2);
            return true;
        }
    }
}

