/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.record.io;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import org.apache.flink.api.java.record.io.CsvOutputFormat;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.core.fs.FileSystem;
import org.apache.flink.core.fs.Path;
import org.apache.flink.types.IntValue;
import org.apache.flink.types.Record;
import org.apache.flink.types.StringValue;
import org.apache.flink.types.Value;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class CsvOutputFormatTest {
    protected Configuration config;
    protected File tempFile;
    private final CsvOutputFormat format = new CsvOutputFormat();

    @Before
    public void setup() throws IOException {
        this.tempFile = File.createTempFile("test_output", "tmp");
        this.format.setOutputFilePath(new Path(this.tempFile.toURI()));
        this.format.setWriteMode(FileSystem.WriteMode.OVERWRITE);
    }

    @After
    public void setdown() throws Exception {
        if (this.format != null) {
            this.format.close();
        }
        if (this.tempFile != null) {
            this.tempFile.delete();
        }
    }

    @Test
    public void testConfigure() {
        try {
            Configuration config = new Configuration();
            boolean validConfig = true;
            try {
                this.format.configure(config);
            }
            catch (IllegalArgumentException iae) {
                validConfig = false;
            }
            catch (IllegalStateException ise) {
                validConfig = false;
            }
            Assert.assertFalse((boolean)validConfig);
            config.setInteger("output.record.num-fields", 2);
            validConfig = true;
            try {
                this.format.configure(config);
            }
            catch (IllegalArgumentException iae) {
                validConfig = false;
            }
            catch (IllegalStateException ise) {
                validConfig = false;
            }
            Assert.assertFalse((boolean)validConfig);
            config.setClass("output.record.type_0", StringValue.class);
            config.setClass("output.record.type_1", IntValue.class);
            validConfig = true;
            try {
                this.format.configure(config);
            }
            catch (IllegalArgumentException iae) {
                validConfig = false;
            }
            Assert.assertTrue((boolean)validConfig);
            config.setInteger("output.record.num-fields", 3);
            validConfig = true;
            try {
                this.format.configure(config);
            }
            catch (IllegalArgumentException iae) {
                validConfig = false;
            }
            Assert.assertFalse((boolean)validConfig);
            config.setClass("output.record.type_2", StringValue.class);
            validConfig = true;
            try {
                this.format.configure(config);
            }
            catch (IllegalArgumentException iae) {
                validConfig = false;
            }
            Assert.assertTrue((boolean)validConfig);
            config.setString("output.record.field-delimiter", "|");
            validConfig = true;
            try {
                this.format.configure(config);
            }
            catch (IllegalArgumentException iae) {
                validConfig = false;
                System.out.println(iae.getMessage());
            }
            Assert.assertTrue((boolean)validConfig);
            config.setInteger("output.record.position_1", 0);
            validConfig = true;
            try {
                this.format.configure(config);
            }
            catch (IllegalArgumentException iae) {
                validConfig = false;
            }
            Assert.assertFalse((boolean)validConfig);
            config.setInteger("output.record.position_0", 3);
            config.setInteger("output.record.position_2", 9);
            validConfig = true;
            try {
                this.format.configure(config);
            }
            catch (IllegalArgumentException iae) {
                validConfig = false;
            }
            Assert.assertTrue((boolean)validConfig);
        }
        catch (Exception ex) {
            Assert.fail((String)("Test failed due to a " + ex.getClass().getSimpleName() + ": " + ex.getMessage()));
        }
    }

    @Test
    public void testWriteNoRecPosNoLenient() {
        try {
            Configuration config = new Configuration();
            config.setString("output.record.field-delimiter", "|");
            config.setInteger("output.record.num-fields", 2);
            config.setClass("output.record.type_0", StringValue.class);
            config.setClass("output.record.type_1", IntValue.class);
            this.format.configure(config);
            try {
                this.format.open(0, 1);
            }
            catch (IOException e) {
                Assert.fail((String)e.getMessage());
            }
            Record r = new Record(2);
            try {
                r.setField(0, (Value)new StringValue((CharSequence)"Hello World"));
                r.setField(1, (Value)new IntValue(42));
                this.format.writeRecord(r);
                r.setField(0, (Value)new StringValue((CharSequence)"AbCdE"));
                r.setField(1, (Value)new IntValue(13));
                this.format.writeRecord(r);
                this.format.close();
                BufferedReader dis = new BufferedReader(new FileReader(this.tempFile));
                Assert.assertTrue((boolean)(dis.readLine() + "\n").equals("Hello World|42\n"));
                Assert.assertTrue((boolean)(dis.readLine() + "\n").equals("AbCdE|13\n"));
                dis.close();
            }
            catch (IOException e) {
                Assert.fail((String)e.getMessage());
            }
        }
        catch (Exception ex) {
            Assert.fail((String)("Test failed due to a " + ex.getClass().getSimpleName() + ": " + ex.getMessage()));
        }
    }

    @Test
    public void testWriteNoRecPosNoLenientFail() {
        try {
            Configuration config = new Configuration();
            config.setString("output.record.field-delimiter", "|");
            config.setInteger("output.record.num-fields", 2);
            config.setClass("output.record.type_0", StringValue.class);
            config.setClass("output.record.type_1", IntValue.class);
            this.format.configure(config);
            try {
                this.format.open(0, 1);
            }
            catch (IOException e) {
                Assert.fail((String)e.getMessage());
            }
            Record r = new Record(2);
            boolean success = true;
            try {
                r.setField(0, (Value)new StringValue((CharSequence)"Hello World"));
                r.setField(1, (Value)new IntValue(42));
                this.format.writeRecord(r);
                r.setNull(0);
                r.setField(1, (Value)new IntValue(13));
                this.format.writeRecord(r);
                this.format.close();
            }
            catch (IOException e) {
                success = false;
            }
            catch (RuntimeException re) {
                success = false;
            }
            Assert.assertFalse((boolean)success);
        }
        catch (Exception ex) {
            Assert.fail((String)("Test failed due to a " + ex.getClass().getSimpleName() + ": " + ex.getMessage()));
        }
    }

    @Test
    public void testWriteNoRecPosLenient() {
        try {
            Configuration config = new Configuration();
            config.setString("output.record.field-delimiter", "|");
            config.setInteger("output.record.num-fields", 2);
            config.setClass("output.record.type_0", StringValue.class);
            config.setClass("output.record.type_1", IntValue.class);
            config.setBoolean("output.record.lenient", true);
            this.format.configure(config);
            try {
                this.format.open(0, 1);
            }
            catch (IOException e) {
                Assert.fail((String)e.getMessage());
            }
            Record r = new Record(2);
            try {
                r.setField(0, (Value)new StringValue((CharSequence)"Hello World"));
                r.setField(1, (Value)new IntValue(42));
                this.format.writeRecord(r);
                r.setNull(0);
                r.setField(1, (Value)new IntValue(13));
                this.format.writeRecord(r);
                this.format.close();
                BufferedReader dis = new BufferedReader(new FileReader(this.tempFile));
                Assert.assertTrue((boolean)(dis.readLine() + "\n").equals("Hello World|42\n"));
                Assert.assertTrue((boolean)(dis.readLine() + "\n").equals("|13\n"));
                dis.close();
            }
            catch (IOException e) {
                Assert.fail((String)e.getMessage());
            }
        }
        catch (Exception ex) {
            Assert.fail((String)("Test failed due to a " + ex.getClass().getSimpleName() + ": " + ex.getMessage()));
        }
    }

    @Test
    public void testWriteRecPosNoLenient() {
        try {
            Configuration config = new Configuration();
            config.setString("output.record.field-delimiter", "|");
            config.setInteger("output.record.num-fields", 2);
            config.setClass("output.record.type_0", StringValue.class);
            config.setInteger("output.record.position_0", 2);
            config.setClass("output.record.type_1", StringValue.class);
            config.setInteger("output.record.position_1", 0);
            this.format.configure(config);
            try {
                this.format.open(0, 1);
            }
            catch (IOException e) {
                Assert.fail((String)e.getMessage());
            }
            Record r = new Record(2);
            try {
                r.setField(0, (Value)new StringValue((CharSequence)"Hello World"));
                r.setField(1, (Value)new IntValue(42));
                r.setField(2, (Value)new StringValue((CharSequence)"Hello User"));
                this.format.writeRecord(r);
                r.setField(0, (Value)new StringValue((CharSequence)"AbCdE"));
                r.setField(1, (Value)new IntValue(13));
                r.setField(2, (Value)new StringValue((CharSequence)"ZyXvW"));
                this.format.writeRecord(r);
                this.format.close();
                BufferedReader dis = new BufferedReader(new FileReader(this.tempFile));
                Assert.assertTrue((boolean)(dis.readLine() + "\n").equals("Hello User|Hello World\n"));
                Assert.assertTrue((boolean)(dis.readLine() + "\n").equals("ZyXvW|AbCdE\n"));
                dis.close();
            }
            catch (IOException e) {
                Assert.fail((String)e.getMessage());
            }
        }
        catch (Exception ex) {
            Assert.fail((String)("Test failed due to a " + ex.getClass().getSimpleName() + ": " + ex.getMessage()));
        }
    }

    @Test
    public void testWriteRecPosNoLenientFail() {
        try {
            Configuration config = new Configuration();
            config.setString("output.record.field-delimiter", "|");
            config.setInteger("output.record.num-fields", 2);
            config.setClass("output.record.type_0", StringValue.class);
            config.setInteger("output.record.position_0", 2);
            config.setClass("output.record.type_1", StringValue.class);
            config.setInteger("output.record.position_1", 0);
            this.format.configure(config);
            try {
                this.format.open(0, 1);
            }
            catch (IOException e) {
                Assert.fail((String)e.getMessage());
            }
            Record r = new Record(2);
            boolean success = true;
            try {
                r.setField(0, (Value)new StringValue((CharSequence)"Hello World"));
                r.setField(1, (Value)new IntValue(42));
                r.setField(2, (Value)new StringValue((CharSequence)"Hello User"));
                this.format.writeRecord(r);
                r = new Record();
                r.setField(0, (Value)new StringValue((CharSequence)"AbCdE"));
                r.setField(1, (Value)new IntValue(13));
                this.format.writeRecord(r);
                this.format.close();
            }
            catch (IOException e) {
                success = false;
            }
            catch (RuntimeException re) {
                success = false;
            }
            Assert.assertFalse((boolean)success);
        }
        catch (Exception ex) {
            Assert.fail((String)("Test failed due to a " + ex.getClass().getSimpleName() + ": " + ex.getMessage()));
        }
    }

    @Test
    public void testWriteRecPosLenient() {
        try {
            Configuration config = new Configuration();
            config.setString("output.record.field-delimiter", "|");
            config.setInteger("output.record.num-fields", 2);
            config.setClass("output.record.type_0", StringValue.class);
            config.setInteger("output.record.position_0", 2);
            config.setClass("output.record.type_1", StringValue.class);
            config.setInteger("output.record.position_1", 0);
            config.setBoolean("output.record.lenient", true);
            this.format.configure(config);
            try {
                this.format.open(0, 1);
            }
            catch (IOException e) {
                Assert.fail((String)e.getMessage());
            }
            Record r = new Record(2);
            try {
                r.setField(0, (Value)new StringValue((CharSequence)"Hello World"));
                r.setField(1, (Value)new IntValue(42));
                r.setField(2, (Value)new StringValue((CharSequence)"Hello User"));
                this.format.writeRecord(r);
                r = new Record();
                r.setField(0, (Value)new StringValue((CharSequence)"AbCdE"));
                r.setField(1, (Value)new IntValue(13));
                this.format.writeRecord(r);
                this.format.close();
                BufferedReader dis = new BufferedReader(new FileReader(this.tempFile));
                Assert.assertTrue((boolean)(dis.readLine() + "\n").equals("Hello User|Hello World\n"));
                Assert.assertTrue((boolean)(dis.readLine() + "\n").equals("|AbCdE\n"));
                dis.close();
            }
            catch (IOException e) {
                Assert.fail((String)e.getMessage());
            }
        }
        catch (Exception ex) {
            Assert.fail((String)("Test failed due to a " + ex.getClass().getSimpleName() + ": " + ex.getMessage()));
        }
    }
}

