/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.record;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.lang3.SerializationUtils;
import org.apache.flink.api.common.functions.FlatCombineFunction;
import org.apache.flink.api.common.functions.GroupReduceFunction;
import org.apache.flink.api.common.functions.RichFunction;
import org.apache.flink.api.common.operators.SingleInputSemanticProperties;
import org.apache.flink.api.common.operators.util.FieldSet;
import org.apache.flink.api.common.operators.util.UserCodeWrapper;
import org.apache.flink.api.java.record.functions.FunctionAnnotation;
import org.apache.flink.api.java.record.functions.ReduceFunction;
import org.apache.flink.api.java.record.operators.ReduceOperator;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.types.IntValue;
import org.apache.flink.types.LongValue;
import org.apache.flink.types.Record;
import org.apache.flink.types.Value;
import org.apache.flink.util.Collector;
import org.junit.Assert;
import org.junit.Test;

public class ReduceWrappingFunctionTest {
    @Test
    public void testWrappedReduceObject() {
        try {
            AtomicInteger methodCounter = new AtomicInteger();
            ReduceOperator reduceOp = ReduceOperator.builder((ReduceFunction)new TestReduceFunction(methodCounter)).build();
            RichFunction reducer = (RichFunction)reduceOp.getUserCodeWrapper().getUserCodeObject();
            reducer.close();
            reducer.open(new Configuration());
            Assert.assertEquals((long)2L, (long)methodCounter.get());
            final ArrayList target = new ArrayList();
            Collector<Record> collector = new Collector<Record>(){

                public void collect(Record record) {
                    target.add(record);
                }

                public void close() {
                }
            };
            ArrayList<Record> source = new ArrayList<Record>();
            source.add(new Record((Value)new IntValue(42), (Value)new LongValue(11L)));
            source.add(new Record((Value)new IntValue(13), (Value)new LongValue(17L)));
            ((GroupReduceFunction)reducer).reduce(source, (Collector)collector);
            Assert.assertEquals((long)2L, (long)target.size());
            Assert.assertEquals((Object)new IntValue(42), (Object)((Record)target.get(0)).getField(0, IntValue.class));
            Assert.assertEquals((Object)new LongValue(11L), (Object)((Record)target.get(0)).getField(1, LongValue.class));
            Assert.assertEquals((Object)new IntValue(13), (Object)((Record)target.get(1)).getField(0, IntValue.class));
            Assert.assertEquals((Object)new LongValue(17L), (Object)((Record)target.get(1)).getField(1, LongValue.class));
            target.clear();
            ((FlatCombineFunction)reducer).combine(source, (Collector)collector);
            Assert.assertEquals((long)2L, (long)target.size());
            Assert.assertEquals((Object)new IntValue(42), (Object)((Record)target.get(0)).getField(0, IntValue.class));
            Assert.assertEquals((Object)new LongValue(11L), (Object)((Record)target.get(0)).getField(1, LongValue.class));
            Assert.assertEquals((Object)new IntValue(13), (Object)((Record)target.get(1)).getField(0, IntValue.class));
            Assert.assertEquals((Object)new LongValue(17L), (Object)((Record)target.get(1)).getField(1, LongValue.class));
            target.clear();
            SerializationUtils.clone((Serializable)((Serializable)reducer));
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testWrappedReduceClass() {
        try {
            ReduceOperator reduceOp = ReduceOperator.builder(TestReduceFunction.class).build();
            UserCodeWrapper udf = reduceOp.getUserCodeWrapper();
            UserCodeWrapper copy = (UserCodeWrapper)SerializationUtils.clone((Serializable)udf);
            GroupReduceFunction reducer = (GroupReduceFunction)copy.getUserCodeObject();
            final ArrayList target = new ArrayList();
            Collector<Record> collector = new Collector<Record>(){

                public void collect(Record record) {
                    target.add(record);
                }

                public void close() {
                }
            };
            ArrayList<Record> source = new ArrayList<Record>();
            source.add(new Record((Value)new IntValue(42), (Value)new LongValue(11L)));
            source.add(new Record((Value)new IntValue(13), (Value)new LongValue(17L)));
            reducer.reduce(source, (Collector)collector);
            Assert.assertEquals((long)2L, (long)target.size());
            Assert.assertEquals((Object)new IntValue(42), (Object)((Record)target.get(0)).getField(0, IntValue.class));
            Assert.assertEquals((Object)new LongValue(11L), (Object)((Record)target.get(0)).getField(1, LongValue.class));
            Assert.assertEquals((Object)new IntValue(13), (Object)((Record)target.get(1)).getField(0, IntValue.class));
            Assert.assertEquals((Object)new LongValue(17L), (Object)((Record)target.get(1)).getField(1, LongValue.class));
            target.clear();
            ((FlatCombineFunction)reducer).combine(source, (Collector)collector);
            Assert.assertEquals((long)2L, (long)target.size());
            Assert.assertEquals((Object)new IntValue(42), (Object)((Record)target.get(0)).getField(0, IntValue.class));
            Assert.assertEquals((Object)new LongValue(11L), (Object)((Record)target.get(0)).getField(1, LongValue.class));
            Assert.assertEquals((Object)new IntValue(13), (Object)((Record)target.get(1)).getField(0, IntValue.class));
            Assert.assertEquals((Object)new LongValue(17L), (Object)((Record)target.get(1)).getField(1, LongValue.class));
            target.clear();
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testExtractSemantics() {
        try {
            ReduceOperator reduceOp = ReduceOperator.builder((ReduceFunction)new TestReduceFunction()).build();
            SingleInputSemanticProperties props = reduceOp.getSemanticProperties();
            FieldSet fw2 = props.getForwardedField(2);
            FieldSet fw4 = props.getForwardedField(4);
            Assert.assertNotNull((Object)fw2);
            Assert.assertNotNull((Object)fw4);
            Assert.assertEquals((long)1L, (long)fw2.size());
            Assert.assertEquals((long)1L, (long)fw4.size());
            Assert.assertTrue((boolean)fw2.contains(Integer.valueOf(2)));
            Assert.assertTrue((boolean)fw4.contains(Integer.valueOf(4)));
            reduceOp = ReduceOperator.builder(TestReduceFunction.class).build();
            props = reduceOp.getSemanticProperties();
            fw2 = props.getForwardedField(2);
            fw4 = props.getForwardedField(4);
            Assert.assertNotNull((Object)fw2);
            Assert.assertNotNull((Object)fw4);
            Assert.assertEquals((long)1L, (long)fw2.size());
            Assert.assertEquals((long)1L, (long)fw4.size());
            Assert.assertTrue((boolean)fw2.contains(Integer.valueOf(2)));
            Assert.assertTrue((boolean)fw4.contains(Integer.valueOf(4)));
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testCombinable() {
        try {
            ReduceOperator reduceOp = ReduceOperator.builder((ReduceFunction)new TestReduceFunction()).build();
            Assert.assertTrue((boolean)reduceOp.isCombinable());
            reduceOp = ReduceOperator.builder(TestReduceFunction.class).build();
            Assert.assertTrue((boolean)reduceOp.isCombinable());
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @ReduceOperator.Combinable
    @FunctionAnnotation.ConstantFields(value={2, 4})
    public static class TestReduceFunction
    extends ReduceFunction {
        private final AtomicInteger methodCounter;

        private TestReduceFunction(AtomicInteger methodCounter) {
            this.methodCounter = methodCounter;
        }

        public TestReduceFunction() {
            this.methodCounter = new AtomicInteger();
        }

        public void reduce(Iterator<Record> records, Collector<Record> out) throws Exception {
            while (records.hasNext()) {
                out.collect((Object)records.next());
            }
        }

        public void close() throws Exception {
            this.methodCounter.incrementAndGet();
            super.close();
        }

        public void open(Configuration parameters) throws Exception {
            this.methodCounter.incrementAndGet();
            super.open(parameters);
        }
    }
}

