/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.record;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.lang3.SerializationUtils;
import org.apache.flink.api.common.functions.RichFunction;
import org.apache.flink.api.common.operators.DualInputSemanticProperties;
import org.apache.flink.api.common.operators.util.FieldSet;
import org.apache.flink.api.common.operators.util.UserCodeWrapper;
import org.apache.flink.api.java.record.functions.CoGroupFunction;
import org.apache.flink.api.java.record.functions.FunctionAnnotation;
import org.apache.flink.api.java.record.operators.CoGroupOperator;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.types.IntValue;
import org.apache.flink.types.LongValue;
import org.apache.flink.types.Record;
import org.apache.flink.types.Value;
import org.apache.flink.util.Collector;
import org.junit.Assert;
import org.junit.Test;

public class CoGroupWrappingFunctionTest {
    @Test
    public void testWrappedCoGroupObject() {
        try {
            AtomicInteger methodCounter = new AtomicInteger();
            CoGroupOperator coGroupOp = CoGroupOperator.builder((CoGroupFunction)new TestCoGroupFunction(methodCounter), LongValue.class, (int)1, (int)2).build();
            RichFunction cogrouper = (RichFunction)coGroupOp.getUserCodeWrapper().getUserCodeObject();
            cogrouper.close();
            cogrouper.open(new Configuration());
            Assert.assertEquals((long)2L, (long)methodCounter.get());
            final ArrayList target = new ArrayList();
            Collector<Record> collector = new Collector<Record>(){

                public void collect(Record record) {
                    target.add(record);
                }

                public void close() {
                }
            };
            ArrayList<Record> source1 = new ArrayList<Record>();
            source1.add(new Record((Value)new IntValue(42)));
            source1.add(new Record((Value)new IntValue(13)));
            ArrayList<Record> source2 = new ArrayList<Record>();
            source2.add(new Record((Value)new LongValue(11L)));
            source2.add(new Record((Value)new LongValue(17L)));
            ((org.apache.flink.api.common.functions.CoGroupFunction)cogrouper).coGroup(source1, source2, (Collector)collector);
            Assert.assertEquals((long)4L, (long)target.size());
            Assert.assertEquals((Object)new IntValue(42), (Object)((Record)target.get(0)).getField(0, IntValue.class));
            Assert.assertEquals((Object)new IntValue(13), (Object)((Record)target.get(1)).getField(0, IntValue.class));
            Assert.assertEquals((Object)new LongValue(11L), (Object)((Record)target.get(2)).getField(0, LongValue.class));
            Assert.assertEquals((Object)new LongValue(17L), (Object)((Record)target.get(3)).getField(0, LongValue.class));
            target.clear();
            SerializationUtils.clone((Serializable)((Serializable)cogrouper));
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testWrappedCoGroupClass() {
        try {
            CoGroupOperator coGroupOp = CoGroupOperator.builder(TestCoGroupFunction.class, LongValue.class, (int)1, (int)2).build();
            UserCodeWrapper udf = coGroupOp.getUserCodeWrapper();
            UserCodeWrapper copy = (UserCodeWrapper)SerializationUtils.clone((Serializable)udf);
            org.apache.flink.api.common.functions.CoGroupFunction cogrouper = (org.apache.flink.api.common.functions.CoGroupFunction)copy.getUserCodeObject();
            final ArrayList target = new ArrayList();
            Collector<Record> collector = new Collector<Record>(){

                public void collect(Record record) {
                    target.add(record);
                }

                public void close() {
                }
            };
            ArrayList<Record> source1 = new ArrayList<Record>();
            source1.add(new Record((Value)new IntValue(42)));
            source1.add(new Record((Value)new IntValue(13)));
            ArrayList<Record> source2 = new ArrayList<Record>();
            source2.add(new Record((Value)new LongValue(11L)));
            source2.add(new Record((Value)new LongValue(17L)));
            cogrouper.coGroup(source1, source2, (Collector)collector);
            Assert.assertEquals((long)4L, (long)target.size());
            Assert.assertEquals((Object)new IntValue(42), (Object)((Record)target.get(0)).getField(0, IntValue.class));
            Assert.assertEquals((Object)new IntValue(13), (Object)((Record)target.get(1)).getField(0, IntValue.class));
            Assert.assertEquals((Object)new LongValue(11L), (Object)((Record)target.get(2)).getField(0, LongValue.class));
            Assert.assertEquals((Object)new LongValue(17L), (Object)((Record)target.get(3)).getField(0, LongValue.class));
            target.clear();
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testExtractSemantics() {
        try {
            CoGroupOperator coGroupOp = CoGroupOperator.builder((CoGroupFunction)new TestCoGroupFunction(), LongValue.class, (int)1, (int)2).build();
            DualInputSemanticProperties props = coGroupOp.getSemanticProperties();
            FieldSet fw2 = props.getForwardedField1(2);
            FieldSet fw4 = props.getForwardedField2(4);
            Assert.assertNotNull((Object)fw2);
            Assert.assertNotNull((Object)fw4);
            Assert.assertEquals((long)1L, (long)fw2.size());
            Assert.assertEquals((long)1L, (long)fw4.size());
            Assert.assertTrue((boolean)fw2.contains(Integer.valueOf(2)));
            Assert.assertTrue((boolean)fw4.contains(Integer.valueOf(4)));
            coGroupOp = CoGroupOperator.builder(TestCoGroupFunction.class, LongValue.class, (int)1, (int)2).build();
            props = coGroupOp.getSemanticProperties();
            fw2 = props.getForwardedField1(2);
            fw4 = props.getForwardedField2(4);
            Assert.assertNotNull((Object)fw2);
            Assert.assertNotNull((Object)fw4);
            Assert.assertEquals((long)1L, (long)fw2.size());
            Assert.assertEquals((long)1L, (long)fw4.size());
            Assert.assertTrue((boolean)fw2.contains(Integer.valueOf(2)));
            Assert.assertTrue((boolean)fw4.contains(Integer.valueOf(4)));
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @FunctionAnnotation.ConstantFieldsFirst(value={2})
    @FunctionAnnotation.ConstantFieldsSecond(value={4})
    public static class TestCoGroupFunction
    extends CoGroupFunction {
        private final AtomicInteger methodCounter;

        private TestCoGroupFunction(AtomicInteger methodCounter) {
            this.methodCounter = methodCounter;
        }

        public TestCoGroupFunction() {
            this.methodCounter = new AtomicInteger();
        }

        public void coGroup(Iterator<Record> records1, Iterator<Record> records2, Collector<Record> out) throws Exception {
            while (records1.hasNext()) {
                out.collect((Object)records1.next());
            }
            while (records2.hasNext()) {
                out.collect((Object)records2.next());
            }
        }

        public void close() throws Exception {
            this.methodCounter.incrementAndGet();
            super.close();
        }

        public void open(Configuration parameters) throws Exception {
            this.methodCounter.incrementAndGet();
            super.open(parameters);
        }
    }
}

