/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.operators.translation;

import org.apache.flink.api.common.operators.GenericDataSinkBase;
import org.apache.flink.api.common.operators.GenericDataSourceBase;
import org.apache.flink.api.common.operators.base.GroupReduceOperatorBase;
import org.apache.flink.api.java.ExecutionEnvironment;
import org.apache.flink.api.java.LocalEnvironment;
import org.apache.flink.api.java.aggregation.Aggregations;
import org.apache.flink.api.java.operators.DataSource;
import org.apache.flink.api.java.operators.translation.JavaPlan;
import org.apache.flink.api.java.tuple.Tuple3;
import org.apache.flink.types.StringValue;
import org.junit.Assert;
import org.junit.Test;

public class AggregateTranslationTest {
    @Test
    public void translateAggregate() {
        try {
            int DOP = 8;
            LocalEnvironment env = ExecutionEnvironment.createLocalEnvironment((int)8);
            DataSource initialData = env.fromElements((Object[])new Tuple3[]{new Tuple3((Object)3.141592, (Object)new StringValue((CharSequence)"foobar"), (Object)77L)});
            initialData.groupBy(new int[]{0}).aggregate(Aggregations.MIN, 1).and(Aggregations.SUM, 2).print();
            JavaPlan p = env.createProgramPlan();
            GenericDataSinkBase sink = (GenericDataSinkBase)p.getDataSinks().iterator().next();
            GroupReduceOperatorBase reducer = (GroupReduceOperatorBase)sink.getInput();
            Assert.assertEquals((long)1L, (long)reducer.getKeyColumns(0).length);
            Assert.assertEquals((long)0L, (long)reducer.getKeyColumns(0)[0]);
            Assert.assertEquals((long)-1L, (long)reducer.getDegreeOfParallelism());
            Assert.assertTrue((boolean)reducer.isCombinable());
            Assert.assertTrue((boolean)(reducer.getInput() instanceof GenericDataSourceBase));
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            e.printStackTrace();
            Assert.fail((String)("Test caused an error: " + e.getMessage()));
        }
    }
}

