/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.operator;

import java.util.ArrayList;
import java.util.List;
import org.apache.flink.api.common.typeinfo.BasicTypeInfo;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.ExecutionEnvironment;
import org.apache.flink.api.java.operators.DataSource;
import org.apache.flink.api.java.tuple.Tuple5;
import org.apache.flink.api.java.typeutils.TupleTypeInfo;
import org.junit.Assert;
import org.junit.Test;

public class ProjectionOperatorTest {
    private final List<Tuple5<Integer, Long, String, Long, Integer>> emptyTupleData = new ArrayList<Tuple5<Integer, Long, String, Long, Integer>>();
    private final TupleTypeInfo<Tuple5<Integer, Long, String, Long, Integer>> tupleTypeInfo = new TupleTypeInfo(new TypeInformation[]{BasicTypeInfo.INT_TYPE_INFO, BasicTypeInfo.LONG_TYPE_INFO, BasicTypeInfo.STRING_TYPE_INFO, BasicTypeInfo.LONG_TYPE_INFO, BasicTypeInfo.INT_TYPE_INFO});
    private final List<Long> emptyLongData = new ArrayList<Long>();

    @Test
    public void testFieldsProjection() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource tupleDs = env.fromCollection(this.emptyTupleData, this.tupleTypeInfo);
        try {
            tupleDs.project(new int[]{0});
        }
        catch (Exception e) {
            Assert.fail();
        }
        try {
            tupleDs.project(new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25});
            Assert.fail();
        }
        catch (IllegalArgumentException iae) {
        }
        catch (Exception e) {
            Assert.fail();
        }
        try {
            tupleDs.project(new int[]{0, 5, 2});
            Assert.fail();
        }
        catch (IndexOutOfBoundsException ioobe) {
        }
        catch (Exception e) {
            Assert.fail();
        }
        DataSource longDs = env.fromCollection(this.emptyLongData, (TypeInformation)BasicTypeInfo.LONG_TYPE_INFO);
        try {
            longDs.project(new int[]{0});
            Assert.fail();
        }
        catch (UnsupportedOperationException uoe) {
        }
        catch (Exception e) {
            Assert.fail();
        }
    }

    @Test
    public void testProjectionTypes() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource tupleDs = env.fromCollection(this.emptyTupleData, this.tupleTypeInfo);
        try {
            tupleDs.project(new int[]{0});
        }
        catch (Exception e) {
            Assert.fail();
        }
        try {
            tupleDs.project(new int[]{2, 1, 4});
        }
        catch (Exception e) {
            Assert.fail();
        }
    }

    @Test
    public void testProjectionWithoutTypes() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource tupleDs = env.fromCollection(this.emptyTupleData, this.tupleTypeInfo);
        try {
            tupleDs.project(new int[]{2, 0, 4});
        }
        catch (Exception e) {
            Assert.fail();
        }
        try {
            tupleDs.project(new int[]{2, -1, 4});
            Assert.fail();
        }
        catch (IndexOutOfBoundsException iob) {
        }
        catch (Exception e) {
            Assert.fail();
        }
        try {
            tupleDs.project(new int[]{2, 1, 4, 5, 8, 9});
            Assert.fail();
        }
        catch (IndexOutOfBoundsException iob) {
        }
        catch (Exception e) {
            Assert.fail();
        }
    }
}

