/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.operator;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.flink.api.common.InvalidProgramException;
import org.apache.flink.api.common.typeinfo.BasicTypeInfo;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.ExecutionEnvironment;
import org.apache.flink.api.java.operators.DataSource;
import org.apache.flink.api.java.operators.UnsortedGrouping;
import org.apache.flink.api.java.tuple.Tuple5;
import org.apache.flink.api.java.typeutils.TupleTypeInfo;
import org.junit.Assert;
import org.junit.Test;

public class MaxByOperatorTest {
    private final List<Tuple5<Integer, Long, String, Long, Integer>> emptyTupleData = new ArrayList<Tuple5<Integer, Long, String, Long, Integer>>();
    private final TupleTypeInfo<Tuple5<Integer, Long, String, Long, Integer>> tupleTypeInfo = new TupleTypeInfo(new TypeInformation[]{BasicTypeInfo.INT_TYPE_INFO, BasicTypeInfo.LONG_TYPE_INFO, BasicTypeInfo.STRING_TYPE_INFO, BasicTypeInfo.LONG_TYPE_INFO, BasicTypeInfo.INT_TYPE_INFO});
    private final List<CustomType> customTypeData = new ArrayList<CustomType>();

    @Test
    public void testMaxByKeyFieldsDataset() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource tupleDs = env.fromCollection(this.emptyTupleData, this.tupleTypeInfo);
        try {
            tupleDs.maxBy(new int[]{4, 0, 1, 2, 3});
        }
        catch (Exception e) {
            Assert.fail();
        }
    }

    @Test(expected=InvalidProgramException.class)
    public void testCustomKeyFieldsDataset() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        this.customTypeData.add(new CustomType());
        DataSource customDs = env.fromCollection(this.customTypeData);
        customDs.maxBy(new int[]{0});
    }

    @Test(expected=IndexOutOfBoundsException.class)
    public void testOutOfTupleBoundsDataset1() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource tupleDs = env.fromCollection(this.emptyTupleData, this.tupleTypeInfo);
        tupleDs.maxBy(new int[]{5});
    }

    @Test(expected=IndexOutOfBoundsException.class)
    public void testOutOfTupleBoundsDataset2() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource tupleDs = env.fromCollection(this.emptyTupleData, this.tupleTypeInfo);
        tupleDs.maxBy(new int[]{-1});
    }

    @Test(expected=IndexOutOfBoundsException.class)
    public void testOutOfTupleBoundsDataset3() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource tupleDs = env.fromCollection(this.emptyTupleData, this.tupleTypeInfo);
        tupleDs.maxBy(new int[]{1, 2, 3, 4, -1});
    }

    @Test
    public void testMaxByKeyFieldsGrouping() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        UnsortedGrouping groupDs = env.fromCollection(this.emptyTupleData, this.tupleTypeInfo).groupBy(new int[]{0});
        try {
            groupDs.maxBy(new int[]{4, 0, 1, 2, 3});
        }
        catch (Exception e) {
            Assert.fail();
        }
    }

    @Test(expected=InvalidProgramException.class)
    public void testCustomKeyFieldsGrouping() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        this.customTypeData.add(new CustomType());
        UnsortedGrouping groupDs = env.fromCollection(this.customTypeData).groupBy(new int[]{0});
        groupDs.maxBy(new int[]{0});
    }

    @Test(expected=IndexOutOfBoundsException.class)
    public void testOutOfTupleBoundsGrouping1() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        UnsortedGrouping groupDs = env.fromCollection(this.emptyTupleData, this.tupleTypeInfo).groupBy(new int[]{0});
        groupDs.maxBy(new int[]{5});
    }

    @Test(expected=IndexOutOfBoundsException.class)
    public void testOutOfTupleBoundsGrouping2() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        UnsortedGrouping groupDs = env.fromCollection(this.emptyTupleData, this.tupleTypeInfo).groupBy(new int[]{0});
        groupDs.maxBy(new int[]{-1});
    }

    @Test(expected=IndexOutOfBoundsException.class)
    public void testOutOfTupleBoundsGrouping3() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        UnsortedGrouping groupDs = env.fromCollection(this.emptyTupleData, this.tupleTypeInfo).groupBy(new int[]{0});
        groupDs.maxBy(new int[]{1, 2, 3, 4, -1});
    }

    public static class CustomType
    implements Serializable {
        private static final long serialVersionUID = 1L;
        public int myInt;
        public long myLong;
        public String myString;

        public CustomType() {
        }

        public CustomType(int i, long l, String s) {
            this.myInt = i;
            this.myLong = l;
            this.myString = s;
        }

        public String toString() {
            return this.myInt + "," + this.myLong + "," + this.myString;
        }
    }
}

