/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.operator;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.flink.api.common.InvalidProgramException;
import org.apache.flink.api.common.operators.Order;
import org.apache.flink.api.common.typeinfo.BasicTypeInfo;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.ExecutionEnvironment;
import org.apache.flink.api.java.functions.KeySelector;
import org.apache.flink.api.java.operators.DataSource;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.api.java.tuple.Tuple5;
import org.apache.flink.api.java.typeutils.TupleTypeInfo;
import org.junit.Assert;
import org.junit.Test;

public class GroupingTest {
    private final List<Tuple5<Integer, Long, String, Long, Integer>> emptyTupleData = new ArrayList<Tuple5<Integer, Long, String, Long, Integer>>();
    private final TupleTypeInfo<Tuple5<Integer, Long, String, Long, Integer>> tupleTypeInfo = new TupleTypeInfo(new TypeInformation[]{BasicTypeInfo.INT_TYPE_INFO, BasicTypeInfo.LONG_TYPE_INFO, BasicTypeInfo.STRING_TYPE_INFO, BasicTypeInfo.LONG_TYPE_INFO, BasicTypeInfo.INT_TYPE_INFO});
    private final List<Long> emptyLongData = new ArrayList<Long>();
    private final List<CustomType> customTypeData = new ArrayList<CustomType>();

    @Test
    public void testGroupByKeyFields1() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource tupleDs = env.fromCollection(this.emptyTupleData, this.tupleTypeInfo);
        try {
            tupleDs.groupBy(new int[]{0});
        }
        catch (Exception e) {
            Assert.fail();
        }
    }

    @Test(expected=InvalidProgramException.class)
    public void testGroupByKeyFields2() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource longDs = env.fromCollection(this.emptyLongData, (TypeInformation)BasicTypeInfo.LONG_TYPE_INFO);
        longDs.groupBy(new int[]{0});
    }

    @Test(expected=InvalidProgramException.class)
    public void testGroupByKeyFields3() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        this.customTypeData.add(new CustomType());
        DataSource customDs = env.fromCollection(this.customTypeData);
        customDs.groupBy(new int[]{0});
    }

    @Test(expected=IllegalArgumentException.class)
    public void testGroupByKeyFields4() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource tupleDs = env.fromCollection(this.emptyTupleData, this.tupleTypeInfo);
        tupleDs.groupBy(new int[]{5});
    }

    @Test(expected=IllegalArgumentException.class)
    public void testGroupByKeyFields5() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource tupleDs = env.fromCollection(this.emptyTupleData, this.tupleTypeInfo);
        tupleDs.groupBy(new int[]{-1});
    }

    @Test
    public void testGroupByKeyExpressions1() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        this.customTypeData.add(new CustomType());
        DataSource ds = env.fromCollection(this.customTypeData);
        try {
            ds.groupBy(new String[]{"myInt"});
        }
        catch (Exception e) {
            Assert.fail();
        }
    }

    @Test(expected=IllegalArgumentException.class)
    public void testGroupByKeyExpressions2() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource longDs = env.fromCollection(this.emptyLongData, (TypeInformation)BasicTypeInfo.LONG_TYPE_INFO);
        longDs.groupBy(new String[]{"myInt"});
    }

    @Test(expected=InvalidProgramException.class)
    public void testGroupByKeyExpressions3() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        this.customTypeData.add(new CustomType());
        DataSource customDs = env.fromCollection(this.customTypeData);
        customDs.groupBy(new int[]{0});
    }

    @Test(expected=IllegalArgumentException.class)
    public void testGroupByKeyExpressions4() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource ds = env.fromCollection(this.customTypeData);
        ds.groupBy(new String[]{"myNonExistent"});
    }

    @Test
    public void testGroupByKeyExpressions1Nested() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        this.customTypeData.add(new CustomType());
        DataSource ds = env.fromCollection(this.customTypeData);
        try {
            ds.groupBy(new String[]{"nested.myInt"});
        }
        catch (Exception e) {
            Assert.fail();
        }
    }

    @Test(expected=IllegalArgumentException.class)
    public void testGroupByKeyExpressions2Nested() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource ds = env.fromCollection(this.customTypeData);
        ds.groupBy(new String[]{"nested.myNonExistent"});
    }

    @Test
    public void testGroupByKeySelector1() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        this.customTypeData.add(new CustomType());
        try {
            DataSource customDs = env.fromCollection(this.customTypeData);
            customDs.groupBy((KeySelector)new KeySelector<CustomType, Long>(){

                public Long getKey(CustomType value) {
                    return value.myLong;
                }
            });
        }
        catch (Exception e) {
            Assert.fail();
        }
    }

    @Test
    public void testGroupByKeySelector2() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        this.customTypeData.add(new CustomType());
        try {
            DataSource customDs = env.fromCollection(this.customTypeData);
            customDs.groupBy((KeySelector)new KeySelector<CustomType, Tuple2<Integer, Long>>(){

                public Tuple2<Integer, Long> getKey(CustomType value) {
                    return new Tuple2((Object)value.myInt, (Object)value.myLong);
                }
            });
        }
        catch (Exception e) {
            Assert.fail();
        }
    }

    @Test(expected=IllegalArgumentException.class)
    public void testGroupByKeySelector3() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        this.customTypeData.add(new CustomType());
        DataSource customDs = env.fromCollection(this.customTypeData);
        customDs.groupBy((KeySelector)new KeySelector<CustomType, CustomType>(){

            public CustomType getKey(CustomType value) {
                return value;
            }
        });
    }

    @Test(expected=IllegalArgumentException.class)
    public void testGroupByKeySelector4() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        this.customTypeData.add(new CustomType());
        DataSource customDs = env.fromCollection(this.customTypeData);
        customDs.groupBy((KeySelector)new KeySelector<CustomType, Tuple2<Integer, CustomType>>(){

            public Tuple2<Integer, CustomType> getKey(CustomType value) {
                return new Tuple2((Object)value.myInt, (Object)value);
            }
        });
    }

    @Test
    public void testGroupSortKeyFields1() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource tupleDs = env.fromCollection(this.emptyTupleData, this.tupleTypeInfo);
        try {
            tupleDs.groupBy(new int[]{0}).sortGroup(0, Order.ASCENDING);
        }
        catch (Exception e) {
            Assert.fail();
        }
    }

    @Test(expected=IllegalArgumentException.class)
    public void testGroupSortKeyFields2() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource tupleDs = env.fromCollection(this.emptyTupleData, this.tupleTypeInfo);
        tupleDs.groupBy(new int[]{0}).sortGroup(5, Order.ASCENDING);
    }

    @Test(expected=InvalidProgramException.class)
    public void testGroupSortKeyFields3() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource longDs = env.fromCollection(this.emptyLongData, (TypeInformation)BasicTypeInfo.LONG_TYPE_INFO);
        longDs.groupBy((KeySelector)new KeySelector<Long, Long>(){
            private static final long serialVersionUID = 1L;

            public Long getKey(Long value) {
                return value;
            }
        }).sortGroup(0, Order.ASCENDING);
    }

    @Test
    public void testChainedGroupSortKeyFields() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource tupleDs = env.fromCollection(this.emptyTupleData, this.tupleTypeInfo);
        try {
            tupleDs.groupBy(new int[]{0}).sortGroup(0, Order.ASCENDING).sortGroup(2, Order.DESCENDING);
        }
        catch (Exception e) {
            Assert.fail();
        }
    }

    public static class CustomType
    implements Serializable {
        private static final long serialVersionUID = 1L;
        public int myInt;
        public long myLong;
        public String myString;
        public Nest nested;

        public CustomType() {
        }

        public CustomType(int i, long l, String s) {
            this.myInt = i;
            this.myLong = l;
            this.myString = s;
        }

        public String toString() {
            return this.myInt + "," + this.myLong + "," + this.myString;
        }

        public static class Nest {
            public int myInt;
        }
    }
}

