/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.operator;

import java.util.ArrayList;
import java.util.List;
import org.apache.flink.api.common.InvalidProgramException;
import org.apache.flink.api.common.typeinfo.BasicTypeInfo;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.DataSet;
import org.apache.flink.api.java.ExecutionEnvironment;
import org.apache.flink.api.java.functions.KeySelector;
import org.apache.flink.api.java.operator.JoinOperatorTest;
import org.apache.flink.api.java.operators.DataSource;
import org.apache.flink.api.java.tuple.Tuple5;
import org.apache.flink.api.java.typeutils.TupleTypeInfo;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class CoGroupOperatorTest {
    private static final List<Tuple5<Integer, Long, String, Long, Integer>> emptyTupleData = new ArrayList<Tuple5<Integer, Long, String, Long, Integer>>();
    private final TupleTypeInfo<Tuple5<Integer, Long, String, Long, Integer>> tupleTypeInfo = new TupleTypeInfo(new TypeInformation[]{BasicTypeInfo.INT_TYPE_INFO, BasicTypeInfo.LONG_TYPE_INFO, BasicTypeInfo.STRING_TYPE_INFO, BasicTypeInfo.LONG_TYPE_INFO, BasicTypeInfo.INT_TYPE_INFO});
    private static List<JoinOperatorTest.CustomType> customTypeData = new ArrayList<JoinOperatorTest.CustomType>();

    @BeforeClass
    public static void insertCustomData() {
        customTypeData.add(new JoinOperatorTest.CustomType());
    }

    @Test
    public void testCoGroupKeyFields1() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource ds1 = env.fromCollection(emptyTupleData, this.tupleTypeInfo);
        DataSource ds2 = env.fromCollection(emptyTupleData, this.tupleTypeInfo);
        try {
            ds1.coGroup((DataSet)ds2).where(new int[]{0}).equalTo(new int[]{0});
        }
        catch (Exception e) {
            Assert.fail();
        }
    }

    @Test(expected=InvalidProgramException.class)
    public void testCoGroupKeyFields2() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource ds1 = env.fromCollection(emptyTupleData, this.tupleTypeInfo);
        DataSource ds2 = env.fromCollection(emptyTupleData, this.tupleTypeInfo);
        ds1.coGroup((DataSet)ds2).where(new int[]{0}).equalTo(new int[]{2});
    }

    @Test(expected=InvalidProgramException.class)
    public void testCoGroupKeyFields3() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource ds1 = env.fromCollection(emptyTupleData, this.tupleTypeInfo);
        DataSource ds2 = env.fromCollection(emptyTupleData, this.tupleTypeInfo);
        ds1.coGroup((DataSet)ds2).where(new int[]{0, 1}).equalTo(new int[]{2});
    }

    @Test(expected=IllegalArgumentException.class)
    public void testCoGroupKeyFields4() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource ds1 = env.fromCollection(emptyTupleData, this.tupleTypeInfo);
        DataSource ds2 = env.fromCollection(emptyTupleData, this.tupleTypeInfo);
        ds1.coGroup((DataSet)ds2).where(new int[]{5}).equalTo(new int[]{0});
    }

    @Test(expected=IllegalArgumentException.class)
    public void testCoGroupKeyFields5() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource ds1 = env.fromCollection(emptyTupleData, this.tupleTypeInfo);
        DataSource ds2 = env.fromCollection(emptyTupleData, this.tupleTypeInfo);
        ds1.coGroup((DataSet)ds2).where(new int[]{-1}).equalTo(new int[]{-1});
    }

    @Test(expected=IllegalArgumentException.class)
    public void testCoGroupKeyFields6() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource ds1 = env.fromCollection(emptyTupleData, this.tupleTypeInfo);
        DataSource ds2 = env.fromCollection(customTypeData);
        ds1.coGroup((DataSet)ds2).where(new int[]{5}).equalTo(new int[]{0});
    }

    @Test
    public void testCoGroupKeyExpressions1() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource ds1 = env.fromCollection(customTypeData);
        DataSource ds2 = env.fromCollection(customTypeData);
        try {
            ds1.coGroup((DataSet)ds2).where(new String[]{"myInt"}).equalTo(new String[]{"myInt"});
        }
        catch (Exception e) {
            Assert.fail();
        }
    }

    @Test(expected=InvalidProgramException.class)
    public void testCoGroupKeyExpressions2() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource ds1 = env.fromCollection(customTypeData);
        DataSource ds2 = env.fromCollection(customTypeData);
        ds1.coGroup((DataSet)ds2).where(new String[]{"myInt"}).equalTo(new String[]{"myString"});
    }

    @Test(expected=InvalidProgramException.class)
    public void testCoGroupKeyExpressions3() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource ds1 = env.fromCollection(customTypeData);
        DataSource ds2 = env.fromCollection(customTypeData);
        ds1.coGroup((DataSet)ds2).where(new String[]{"myInt", "myString"}).equalTo(new String[]{"myString"});
    }

    @Test(expected=IllegalArgumentException.class)
    public void testCoGroupKeyExpressions4() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource ds1 = env.fromCollection(customTypeData);
        DataSource ds2 = env.fromCollection(customTypeData);
        ds1.coGroup((DataSet)ds2).where(new String[]{"myNonExistent"}).equalTo(new String[]{"myInt"});
    }

    @Test
    public void testCoGroupKeyExpressions1Nested() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource ds1 = env.fromCollection(customTypeData);
        DataSource ds2 = env.fromCollection(customTypeData);
        try {
            ds1.coGroup((DataSet)ds2).where(new String[]{"nested.myInt"}).equalTo(new String[]{"nested.myInt"});
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail();
        }
    }

    @Test(expected=InvalidProgramException.class)
    public void testCoGroupKeyExpressions2Nested() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource ds1 = env.fromCollection(customTypeData);
        DataSource ds2 = env.fromCollection(customTypeData);
        ds1.coGroup((DataSet)ds2).where(new String[]{"nested.myInt"}).equalTo(new String[]{"nested.myString"});
    }

    @Test(expected=InvalidProgramException.class)
    public void testCoGroupKeyExpressions3Nested() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource ds1 = env.fromCollection(customTypeData);
        DataSource ds2 = env.fromCollection(customTypeData);
        ds1.coGroup((DataSet)ds2).where(new String[]{"nested.myInt", "nested.myString"}).equalTo(new String[]{"nested.myString"});
    }

    @Test(expected=IllegalArgumentException.class)
    public void testCoGroupKeyExpressions4Nested() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource ds1 = env.fromCollection(customTypeData);
        DataSource ds2 = env.fromCollection(customTypeData);
        ds1.coGroup((DataSet)ds2).where(new String[]{"nested.myNonExistent"}).equalTo(new String[]{"nested.myInt"});
    }

    @Test
    public void testCoGroupKeySelectors1() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource ds1 = env.fromCollection(customTypeData);
        DataSource ds2 = env.fromCollection(customTypeData);
        try {
            ds1.coGroup((DataSet)ds2).where((KeySelector)new KeySelector<JoinOperatorTest.CustomType, Long>(){

                public Long getKey(JoinOperatorTest.CustomType value) {
                    return value.myLong;
                }
            }).equalTo((KeySelector)new KeySelector<JoinOperatorTest.CustomType, Long>(){

                public Long getKey(JoinOperatorTest.CustomType value) {
                    return value.myLong;
                }
            });
        }
        catch (Exception e) {
            Assert.fail();
        }
    }

    @Test
    public void testCoGroupKeyMixing1() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource ds1 = env.fromCollection(customTypeData);
        DataSource ds2 = env.fromCollection(emptyTupleData, this.tupleTypeInfo);
        try {
            ds1.coGroup((DataSet)ds2).where((KeySelector)new KeySelector<JoinOperatorTest.CustomType, Long>(){

                public Long getKey(JoinOperatorTest.CustomType value) {
                    return value.myLong;
                }
            }).equalTo(new int[]{3});
        }
        catch (Exception e) {
            Assert.fail();
        }
    }

    @Test
    public void testCoGroupKeyMixing2() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource ds1 = env.fromCollection(emptyTupleData, this.tupleTypeInfo);
        DataSource ds2 = env.fromCollection(customTypeData);
        try {
            ds1.coGroup((DataSet)ds2).where(new int[]{3}).equalTo((KeySelector)new KeySelector<JoinOperatorTest.CustomType, Long>(){

                public Long getKey(JoinOperatorTest.CustomType value) {
                    return value.myLong;
                }
            });
        }
        catch (Exception e) {
            Assert.fail();
        }
    }

    @Test(expected=InvalidProgramException.class)
    public void testCoGroupKeyMixing3() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource ds1 = env.fromCollection(emptyTupleData, this.tupleTypeInfo);
        DataSource ds2 = env.fromCollection(customTypeData);
        ds1.coGroup((DataSet)ds2).where(new int[]{2}).equalTo((KeySelector)new KeySelector<JoinOperatorTest.CustomType, Long>(){

            public Long getKey(JoinOperatorTest.CustomType value) {
                return value.myLong;
            }
        });
    }

    @Test(expected=InvalidProgramException.class)
    public void testCoGroupKeyMixing4() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource ds1 = env.fromCollection(emptyTupleData, this.tupleTypeInfo);
        DataSource ds2 = env.fromCollection(customTypeData);
        ds1.coGroup((DataSet)ds2).where(new int[]{1, 3}).equalTo((KeySelector)new KeySelector<JoinOperatorTest.CustomType, Long>(){

            public Long getKey(JoinOperatorTest.CustomType value) {
                return value.myLong;
            }
        });
    }
}

