/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.operator;

import java.util.ArrayList;
import java.util.List;
import org.apache.flink.api.common.InvalidProgramException;
import org.apache.flink.api.common.typeinfo.BasicTypeInfo;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.ExecutionEnvironment;
import org.apache.flink.api.java.aggregation.Aggregations;
import org.apache.flink.api.java.aggregation.UnsupportedAggregationTypeException;
import org.apache.flink.api.java.operators.DataSource;
import org.apache.flink.api.java.tuple.Tuple5;
import org.apache.flink.api.java.typeutils.TupleTypeInfo;
import org.junit.Assert;
import org.junit.Test;

public class AggregateOperatorTest {
    private final List<Tuple5<Integer, Long, String, Long, Integer>> emptyTupleData = new ArrayList<Tuple5<Integer, Long, String, Long, Integer>>();
    private final TupleTypeInfo<Tuple5<Integer, Long, String, Long, Integer>> tupleTypeInfo = new TupleTypeInfo(new TypeInformation[]{BasicTypeInfo.INT_TYPE_INFO, BasicTypeInfo.LONG_TYPE_INFO, BasicTypeInfo.STRING_TYPE_INFO, BasicTypeInfo.LONG_TYPE_INFO, BasicTypeInfo.INT_TYPE_INFO});
    private final List<Long> emptyLongData = new ArrayList<Long>();

    @Test
    public void testFieldsAggregate() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource tupleDs = env.fromCollection(this.emptyTupleData, this.tupleTypeInfo);
        try {
            tupleDs.aggregate(Aggregations.SUM, 1);
        }
        catch (Exception e) {
            Assert.fail();
        }
        try {
            tupleDs.aggregate(Aggregations.SUM, 10);
            Assert.fail();
        }
        catch (IllegalArgumentException iae) {
        }
        catch (Exception e) {
            Assert.fail();
        }
        DataSource longDs = env.fromCollection(this.emptyLongData, (TypeInformation)BasicTypeInfo.LONG_TYPE_INFO);
        try {
            longDs.aggregate(Aggregations.MIN, 1);
            Assert.fail();
        }
        catch (InvalidProgramException uoe) {
        }
        catch (Exception e) {
            Assert.fail();
        }
    }

    @Test
    public void testAggregationTypes() {
        try {
            ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
            DataSource tupleDs = env.fromCollection(this.emptyTupleData, this.tupleTypeInfo);
            tupleDs.aggregate(Aggregations.SUM, 0).and(Aggregations.MIN, 4);
            tupleDs.aggregate(Aggregations.MIN, 2).aggregate(Aggregations.SUM, 1);
            try {
                tupleDs.aggregate(Aggregations.SUM, 2);
                Assert.fail();
            }
            catch (UnsupportedAggregationTypeException unsupportedAggregationTypeException) {}
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }
}

