/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.io;

import com.google.common.base.Charsets;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import org.apache.flink.api.java.io.CsvInputFormat;
import org.apache.flink.api.java.tuple.Tuple;
import org.apache.flink.api.java.tuple.Tuple1;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.api.java.tuple.Tuple3;
import org.apache.flink.api.java.tuple.Tuple5;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.core.fs.FileInputSplit;
import org.apache.flink.core.fs.Path;
import org.apache.flink.types.parser.FieldParser;
import org.apache.flink.types.parser.StringParser;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;

public class CsvInputFormatTest {
    private static final Path PATH = new Path("an/ignored/file/");
    private static final String FIRST_PART = "That is the first part";
    private static final String SECOND_PART = "That is the second part";

    @Test
    public void ignoreInvalidLines() {
        try {
            String fileContent = "#description of the data\nheader1|header2|header3|\nthis is|1|2.0|\n//a comment\na test|3|4.0|\n#next|5|6.0|\n";
            FileInputSplit split = this.createTempFile("#description of the data\nheader1|header2|header3|\nthis is|1|2.0|\n//a comment\na test|3|4.0|\n#next|5|6.0|\n");
            CsvInputFormat format = new CsvInputFormat(PATH, "\n", '|', new Class[]{String.class, Integer.class, Double.class});
            format.setLenient(true);
            Configuration parameters = new Configuration();
            format.configure(parameters);
            format.open(split);
            Tuple3 result = new Tuple3();
            result = (Tuple3)format.nextRecord((Tuple)result);
            Assert.assertNotNull((Object)result);
            Assert.assertEquals((Object)"this is", (Object)result.f0);
            Assert.assertEquals((Object)new Integer(1), (Object)result.f1);
            Assert.assertEquals((Object)new Double(2.0), (Object)result.f2);
            result = (Tuple3)format.nextRecord((Tuple)result);
            Assert.assertNotNull((Object)result);
            Assert.assertEquals((Object)"a test", (Object)result.f0);
            Assert.assertEquals((Object)new Integer(3), (Object)result.f1);
            Assert.assertEquals((Object)new Double(4.0), (Object)result.f2);
            result = (Tuple3)format.nextRecord((Tuple)result);
            Assert.assertNotNull((Object)result);
            Assert.assertEquals((Object)"#next", (Object)result.f0);
            Assert.assertEquals((Object)new Integer(5), (Object)result.f1);
            Assert.assertEquals((Object)new Double(6.0), (Object)result.f2);
            result = (Tuple3)format.nextRecord((Tuple)result);
            Assert.assertNull((Object)result);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            Assert.fail((String)("Test failed due to a " + ex.getClass().getName() + ": " + ex.getMessage()));
        }
    }

    @Test
    public void ignoreSingleCharPrefixComments() {
        try {
            String fileContent = "#description of the data\n#successive commented line\nthis is|1|2.0|\na test|3|4.0|\n#next|5|6.0|\n";
            FileInputSplit split = this.createTempFile("#description of the data\n#successive commented line\nthis is|1|2.0|\na test|3|4.0|\n#next|5|6.0|\n");
            CsvInputFormat format = new CsvInputFormat(PATH, "\n", '|', new Class[]{String.class, Integer.class, Double.class});
            format.setCommentPrefix("#");
            Configuration parameters = new Configuration();
            format.configure(parameters);
            format.open(split);
            Tuple3 result = new Tuple3();
            result = (Tuple3)format.nextRecord((Tuple)result);
            Assert.assertNotNull((Object)result);
            Assert.assertEquals((Object)"this is", (Object)result.f0);
            Assert.assertEquals((Object)new Integer(1), (Object)result.f1);
            Assert.assertEquals((Object)new Double(2.0), (Object)result.f2);
            result = (Tuple3)format.nextRecord((Tuple)result);
            Assert.assertNotNull((Object)result);
            Assert.assertEquals((Object)"a test", (Object)result.f0);
            Assert.assertEquals((Object)new Integer(3), (Object)result.f1);
            Assert.assertEquals((Object)new Double(4.0), (Object)result.f2);
            result = (Tuple3)format.nextRecord((Tuple)result);
            Assert.assertNull((Object)result);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            Assert.fail((String)("Test failed due to a " + ex.getClass().getName() + ": " + ex.getMessage()));
        }
    }

    @Test
    public void ignoreMultiCharPrefixComments() {
        try {
            String fileContent = "//description of the data\n//successive commented line\nthis is|1|2.0|\na test|3|4.0|\n//next|5|6.0|\n";
            FileInputSplit split = this.createTempFile("//description of the data\n//successive commented line\nthis is|1|2.0|\na test|3|4.0|\n//next|5|6.0|\n");
            CsvInputFormat format = new CsvInputFormat(PATH, "\n", '|', new Class[]{String.class, Integer.class, Double.class});
            format.setCommentPrefix("//");
            Configuration parameters = new Configuration();
            format.configure(parameters);
            format.open(split);
            Tuple3 result = new Tuple3();
            result = (Tuple3)format.nextRecord((Tuple)result);
            Assert.assertNotNull((Object)result);
            Assert.assertEquals((Object)"this is", (Object)result.f0);
            Assert.assertEquals((Object)new Integer(1), (Object)result.f1);
            Assert.assertEquals((Object)new Double(2.0), (Object)result.f2);
            result = (Tuple3)format.nextRecord((Tuple)result);
            Assert.assertNotNull((Object)result);
            Assert.assertEquals((Object)"a test", (Object)result.f0);
            Assert.assertEquals((Object)new Integer(3), (Object)result.f1);
            Assert.assertEquals((Object)new Double(4.0), (Object)result.f2);
            result = (Tuple3)format.nextRecord((Tuple)result);
            Assert.assertNull((Object)result);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            Assert.fail((String)("Test failed due to a " + ex.getClass().getName() + ": " + ex.getMessage()));
        }
    }

    @Test
    public void readStringFields() {
        try {
            String fileContent = "abc|def|ghijk\nabc||hhg\n|||";
            FileInputSplit split = this.createTempFile("abc|def|ghijk\nabc||hhg\n|||");
            CsvInputFormat format = new CsvInputFormat(PATH, "\n", '|', new Class[]{String.class, String.class, String.class});
            Configuration parameters = new Configuration();
            format.configure(parameters);
            format.open(split);
            Tuple3 result = new Tuple3();
            result = (Tuple3)format.nextRecord((Tuple)result);
            Assert.assertNotNull((Object)result);
            Assert.assertEquals((Object)"abc", (Object)result.f0);
            Assert.assertEquals((Object)"def", (Object)result.f1);
            Assert.assertEquals((Object)"ghijk", (Object)result.f2);
            result = (Tuple3)format.nextRecord((Tuple)result);
            Assert.assertNotNull((Object)result);
            Assert.assertEquals((Object)"abc", (Object)result.f0);
            Assert.assertEquals((Object)"", (Object)result.f1);
            Assert.assertEquals((Object)"hhg", (Object)result.f2);
            result = (Tuple3)format.nextRecord((Tuple)result);
            Assert.assertNotNull((Object)result);
            Assert.assertEquals((Object)"", (Object)result.f0);
            Assert.assertEquals((Object)"", (Object)result.f1);
            Assert.assertEquals((Object)"", (Object)result.f2);
            result = (Tuple3)format.nextRecord((Tuple)result);
            Assert.assertNull((Object)result);
            Assert.assertTrue((boolean)format.reachedEnd());
        }
        catch (Exception ex) {
            ex.printStackTrace();
            Assert.fail((String)("Test failed due to a " + ex.getClass().getName() + ": " + ex.getMessage()));
        }
    }

    @Test
    public void readStringFieldsWithTrailingDelimiters() {
        try {
            String fileContent = "abc|def|ghijk\nabc||hhg\n|||\n";
            FileInputSplit split = this.createTempFile("abc|def|ghijk\nabc||hhg\n|||\n");
            CsvInputFormat format = new CsvInputFormat(PATH);
            format.setFieldDelimiter('|');
            format.setFieldTypes(new Class[]{String.class, String.class, String.class});
            format.configure(new Configuration());
            format.open(split);
            Tuple3 result = new Tuple3();
            result = (Tuple3)format.nextRecord((Tuple)result);
            Assert.assertNotNull((Object)result);
            Assert.assertEquals((Object)"abc", (Object)result.f0);
            Assert.assertEquals((Object)"def", (Object)result.f1);
            Assert.assertEquals((Object)"ghijk", (Object)result.f2);
            result = (Tuple3)format.nextRecord((Tuple)result);
            Assert.assertNotNull((Object)result);
            Assert.assertEquals((Object)"abc", (Object)result.f0);
            Assert.assertEquals((Object)"", (Object)result.f1);
            Assert.assertEquals((Object)"hhg", (Object)result.f2);
            result = (Tuple3)format.nextRecord((Tuple)result);
            Assert.assertNotNull((Object)result);
            Assert.assertEquals((Object)"", (Object)result.f0);
            Assert.assertEquals((Object)"", (Object)result.f1);
            Assert.assertEquals((Object)"", (Object)result.f2);
            result = (Tuple3)format.nextRecord((Tuple)result);
            Assert.assertNull((Object)result);
            Assert.assertTrue((boolean)format.reachedEnd());
        }
        catch (Exception ex) {
            Assert.fail((String)("Test failed due to a " + ex.getClass().getName() + ": " + ex.getMessage()));
        }
    }

    @Test
    public void testIntegerFieldsl() throws IOException {
        try {
            String fileContent = "111|222|333|444|555\n666|777|888|999|000|\n";
            FileInputSplit split = this.createTempFile("111|222|333|444|555\n666|777|888|999|000|\n");
            CsvInputFormat format = new CsvInputFormat(PATH);
            format.setFieldDelimiter('|');
            format.setFieldTypes(new Class[]{Integer.class, Integer.class, Integer.class, Integer.class, Integer.class});
            format.configure(new Configuration());
            format.open(split);
            Tuple5 result = new Tuple5();
            result = (Tuple5)format.nextRecord((Tuple)result);
            Assert.assertNotNull((Object)result);
            Assert.assertEquals((Object)111, (Object)result.f0);
            Assert.assertEquals((Object)222, (Object)result.f1);
            Assert.assertEquals((Object)333, (Object)result.f2);
            Assert.assertEquals((Object)444, (Object)result.f3);
            Assert.assertEquals((Object)555, (Object)result.f4);
            result = (Tuple5)format.nextRecord((Tuple)result);
            Assert.assertNotNull((Object)result);
            Assert.assertEquals((Object)666, (Object)result.f0);
            Assert.assertEquals((Object)777, (Object)result.f1);
            Assert.assertEquals((Object)888, (Object)result.f2);
            Assert.assertEquals((Object)999, (Object)result.f3);
            Assert.assertEquals((Object)0, (Object)result.f4);
            result = (Tuple5)format.nextRecord((Tuple)result);
            Assert.assertNull((Object)result);
            Assert.assertTrue((boolean)format.reachedEnd());
        }
        catch (Exception ex) {
            Assert.fail((String)("Test failed due to a " + ex.getClass().getName() + ": " + ex.getMessage()));
        }
    }

    @Test
    public void testReadFirstN() throws IOException {
        try {
            String fileContent = "111|222|333|444|555|\n666|777|888|999|000|\n";
            FileInputSplit split = this.createTempFile("111|222|333|444|555|\n666|777|888|999|000|\n");
            CsvInputFormat format = new CsvInputFormat(PATH);
            format.setFieldDelimiter('|');
            format.setFieldTypes(new Class[]{Integer.class, Integer.class});
            format.configure(new Configuration());
            format.open(split);
            Tuple2 result = new Tuple2();
            result = (Tuple2)format.nextRecord((Tuple)result);
            Assert.assertNotNull((Object)result);
            Assert.assertEquals((Object)111, (Object)result.f0);
            Assert.assertEquals((Object)222, (Object)result.f1);
            result = (Tuple2)format.nextRecord((Tuple)result);
            Assert.assertNotNull((Object)result);
            Assert.assertEquals((Object)666, (Object)result.f0);
            Assert.assertEquals((Object)777, (Object)result.f1);
            result = (Tuple2)format.nextRecord((Tuple)result);
            Assert.assertNull((Object)result);
            Assert.assertTrue((boolean)format.reachedEnd());
        }
        catch (Exception ex) {
            Assert.fail((String)("Test failed due to a " + ex.getClass().getName() + ": " + ex.getMessage()));
        }
    }

    @Test
    public void testReadSparseWithNullFieldsForTypes() throws IOException {
        try {
            String fileContent = "111|222|333|444|555|666|777|888|999|000|\n000|999|888|777|666|555|444|333|222|111|";
            FileInputSplit split = this.createTempFile("111|222|333|444|555|666|777|888|999|000|\n000|999|888|777|666|555|444|333|222|111|");
            CsvInputFormat format = new CsvInputFormat(PATH);
            format.setFieldDelimiter('|');
            format.setFieldTypes(new Class[]{Integer.class, null, null, Integer.class, null, null, null, Integer.class});
            format.configure(new Configuration());
            format.open(split);
            Tuple3 result = new Tuple3();
            result = (Tuple3)format.nextRecord((Tuple)result);
            Assert.assertNotNull((Object)result);
            Assert.assertEquals((Object)111, (Object)result.f0);
            Assert.assertEquals((Object)444, (Object)result.f1);
            Assert.assertEquals((Object)888, (Object)result.f2);
            result = (Tuple3)format.nextRecord((Tuple)result);
            Assert.assertNotNull((Object)result);
            Assert.assertEquals((Object)0, (Object)result.f0);
            Assert.assertEquals((Object)777, (Object)result.f1);
            Assert.assertEquals((Object)333, (Object)result.f2);
            result = (Tuple3)format.nextRecord((Tuple)result);
            Assert.assertNull((Object)result);
            Assert.assertTrue((boolean)format.reachedEnd());
        }
        catch (Exception ex) {
            Assert.fail((String)("Test failed due to a " + ex.getClass().getName() + ": " + ex.getMessage()));
        }
    }

    @Test
    public void testReadSparseWithPositionSetter() throws IOException {
        try {
            String fileContent = "111|222|333|444|555|666|777|888|999|000|\n000|999|888|777|666|555|444|333|222|111|";
            FileInputSplit split = this.createTempFile("111|222|333|444|555|666|777|888|999|000|\n000|999|888|777|666|555|444|333|222|111|");
            CsvInputFormat format = new CsvInputFormat(PATH);
            format.setFieldDelimiter('|');
            format.setFields(new int[]{0, 3, 7}, new Class[]{Integer.class, Integer.class, Integer.class});
            format.configure(new Configuration());
            format.open(split);
            Tuple3 result = new Tuple3();
            result = (Tuple3)format.nextRecord((Tuple)result);
            Assert.assertNotNull((Object)result);
            Assert.assertEquals((Object)111, (Object)result.f0);
            Assert.assertEquals((Object)444, (Object)result.f1);
            Assert.assertEquals((Object)888, (Object)result.f2);
            result = (Tuple3)format.nextRecord((Tuple)result);
            Assert.assertNotNull((Object)result);
            Assert.assertEquals((Object)0, (Object)result.f0);
            Assert.assertEquals((Object)777, (Object)result.f1);
            Assert.assertEquals((Object)333, (Object)result.f2);
            result = (Tuple3)format.nextRecord((Tuple)result);
            Assert.assertNull((Object)result);
            Assert.assertTrue((boolean)format.reachedEnd());
        }
        catch (Exception ex) {
            Assert.fail((String)("Test failed due to a " + ex.getClass().getName() + ": " + ex.getMessage()));
        }
    }

    @Test
    public void testReadSparseWithMask() throws IOException {
        try {
            String fileContent = "111|222|333|444|555|666|777|888|999|000|\n000|999|888|777|666|555|444|333|222|111|";
            FileInputSplit split = this.createTempFile("111|222|333|444|555|666|777|888|999|000|\n000|999|888|777|666|555|444|333|222|111|");
            CsvInputFormat format = new CsvInputFormat(PATH);
            format.setFieldDelimiter('|');
            format.setFields(new boolean[]{true, false, false, true, false, false, false, true}, new Class[]{Integer.class, Integer.class, Integer.class});
            format.configure(new Configuration());
            format.open(split);
            Tuple3 result = new Tuple3();
            result = (Tuple3)format.nextRecord((Tuple)result);
            Assert.assertNotNull((Object)result);
            Assert.assertEquals((Object)111, (Object)result.f0);
            Assert.assertEquals((Object)444, (Object)result.f1);
            Assert.assertEquals((Object)888, (Object)result.f2);
            result = (Tuple3)format.nextRecord((Tuple)result);
            Assert.assertNotNull((Object)result);
            Assert.assertEquals((Object)0, (Object)result.f0);
            Assert.assertEquals((Object)777, (Object)result.f1);
            Assert.assertEquals((Object)333, (Object)result.f2);
            result = (Tuple3)format.nextRecord((Tuple)result);
            Assert.assertNull((Object)result);
            Assert.assertTrue((boolean)format.reachedEnd());
        }
        catch (Exception ex) {
            Assert.fail((String)("Test failed due to a " + ex.getClass().getName() + ": " + ex.getMessage()));
        }
    }

    @Test
    public void testReadSparseWithShuffledPositions() throws IOException {
        try {
            CsvInputFormat format = new CsvInputFormat(PATH);
            format.setFieldDelimiter('|');
            try {
                format.setFields(new int[]{8, 1, 3}, new Class[]{Integer.class, Integer.class, Integer.class});
                Assert.fail((String)"Input sequence should have been rejected.");
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }
        catch (Exception ex) {
            Assert.fail((String)("Test failed due to a " + ex.getClass().getName() + ": " + ex.getMessage()));
        }
    }

    @Test
    public void testParseStringErrors() throws Exception {
        Object[][] failures;
        StringParser stringParser = new StringParser();
        for (Object[] failure : failures = new Object[][]{{"\"string\" trailing", FieldParser.ParseErrorState.UNQUOTED_CHARS_AFTER_QUOTED_STRING}, {"\"unterminated ", FieldParser.ParseErrorState.UNTERMINATED_QUOTED_STRING}}) {
            String input = (String)failure[0];
            int result = stringParser.parseField(input.getBytes(), 0, input.length(), '|', null);
            Assert.assertThat((Object)result, (Matcher)CoreMatchers.is((Object)-1));
            Assert.assertThat((Object)stringParser.getErrorState(), (Matcher)CoreMatchers.is((Object)failure[1]));
        }
    }

    @Test
    public void testParserCorrectness() throws Exception {
        String fileContent = "Year,Make,Model,Description,Price\n1997,Ford,E350,\"ac, abs, moon\",3000.00\n1999,Chevy,\"Venture \"\"Extended Edition\"\"\",\"\",4900.00\n1996,Jeep,Grand Cherokee,\"MUST SELL! air, moon roof, loaded\",4799.00\n1999,Chevy,\"Venture \"\"Extended Edition, Very Large\"\"\",,5000.00\n,,\"Venture \"\"Extended Edition\"\"\",\"\",4900.00";
        FileInputSplit split = this.createTempFile("Year,Make,Model,Description,Price\n1997,Ford,E350,\"ac, abs, moon\",3000.00\n1999,Chevy,\"Venture \"\"Extended Edition\"\"\",\"\",4900.00\n1996,Jeep,Grand Cherokee,\"MUST SELL! air, moon roof, loaded\",4799.00\n1999,Chevy,\"Venture \"\"Extended Edition, Very Large\"\"\",,5000.00\n,,\"Venture \"\"Extended Edition\"\"\",\"\",4900.00");
        CsvInputFormat format = new CsvInputFormat(PATH);
        format.setSkipFirstLineAsHeader(true);
        format.setFieldDelimiter(',');
        format.setFields(new boolean[]{true, true, true, true, true}, new Class[]{Integer.class, String.class, String.class, String.class, Double.class});
        format.configure(new Configuration());
        format.open(split);
        Tuple5 result = new Tuple5();
        Tuple5[] expectedLines = new Tuple5[]{new Tuple5((Object)1997, (Object)"Ford", (Object)"E350", (Object)"ac, abs, moon", (Object)3000.0), new Tuple5((Object)1999, (Object)"Chevy", (Object)"Venture \"Extended Edition\"", (Object)"", (Object)4900.0), new Tuple5((Object)1996, (Object)"Jeep", (Object)"Grand Cherokee", (Object)"MUST SELL! air, moon roof, loaded", (Object)4799.0), new Tuple5((Object)1999, (Object)"Chevy", (Object)"Venture \"Extended Edition, Very Large\"", (Object)"", (Object)5000.0), new Tuple5((Object)0, (Object)"", (Object)"Venture \"Extended Edition\"", (Object)"", (Object)4900.0)};
        try {
            for (Tuple5 expected : expectedLines) {
                result = (Tuple5)format.nextRecord((Tuple)result);
                Assert.assertEquals((Object)expected, (Object)result);
            }
            Assert.assertNull((Object)format.nextRecord((Tuple)result));
            Assert.assertTrue((boolean)format.reachedEnd());
        }
        catch (Exception ex) {
            Assert.fail((String)("Test failed due to a " + ex.getClass().getName() + ": " + ex.getMessage()));
        }
    }

    private FileInputSplit createTempFile(String content) throws IOException {
        File tempFile = File.createTempFile("test_contents", "tmp");
        tempFile.deleteOnExit();
        OutputStreamWriter wrt = new OutputStreamWriter((OutputStream)new FileOutputStream(tempFile), Charsets.UTF_8);
        wrt.write(content);
        wrt.close();
        return new FileInputSplit(0, new Path(tempFile.toURI().toString()), 0L, tempFile.length(), new String[]{"localhost"});
    }

    @Test
    public void testWindowsLineEndRemoval() {
        this.testRemovingTrailingCR("\n", "\n");
        this.testRemovingTrailingCR("\r\n", "\r\n");
        this.testRemovingTrailingCR("\r\n", "\n");
    }

    private void testRemovingTrailingCR(String lineBreakerInFile, String lineBreakerSetup) {
        File tempFile = null;
        String fileContent = FIRST_PART + lineBreakerInFile + SECOND_PART + lineBreakerInFile;
        try {
            tempFile = File.createTempFile("CsvInputFormatTest", "tmp");
            tempFile.deleteOnExit();
            tempFile.setWritable(true);
            OutputStreamWriter wrt = new OutputStreamWriter(new FileOutputStream(tempFile));
            wrt.write(fileContent);
            wrt.close();
            CsvInputFormat inputFormat = new CsvInputFormat(new Path(tempFile.toURI().toString()), new Class[]{String.class});
            Configuration parameters = new Configuration();
            inputFormat.configure(parameters);
            inputFormat.setDelimiter(lineBreakerSetup);
            FileInputSplit[] splits = inputFormat.createInputSplits(1);
            inputFormat.open(splits[0]);
            Tuple1 result = (Tuple1)inputFormat.nextRecord((Tuple)new Tuple1());
            Assert.assertNotNull((String)"Expecting to not return null", (Object)result);
            Assert.assertEquals((Object)FIRST_PART, (Object)result.f0);
            result = (Tuple1)inputFormat.nextRecord((Tuple)result);
            Assert.assertNotNull((String)"Expecting to not return null", (Object)result);
            Assert.assertEquals((Object)SECOND_PART, (Object)result.f0);
        }
        catch (Throwable t) {
            System.err.println("test failed with exception: " + t.getMessage());
            t.printStackTrace(System.err);
            Assert.fail((String)"Test erroneous");
        }
    }
}

