/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.io;

import java.util.Arrays;
import org.apache.flink.api.common.typeinfo.BasicTypeInfo;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.ExecutionEnvironment;
import org.apache.flink.api.java.io.CsvInputFormat;
import org.apache.flink.api.java.io.CsvReader;
import org.apache.flink.api.java.operators.DataSource;
import org.apache.flink.api.java.tuple.Tuple4;
import org.apache.flink.api.java.tuple.Tuple5;
import org.apache.flink.api.java.typeutils.TupleTypeInfo;
import org.apache.flink.api.java.typeutils.ValueTypeInfo;
import org.apache.flink.types.LongValue;
import org.apache.flink.types.StringValue;
import org.junit.Assert;
import org.junit.Test;

public class CSVReaderTest {
    @Test
    public void testIgnoreHeaderConfigure() {
        CsvReader reader = CSVReaderTest.getCsvReader();
        reader.ignoreFirstLine();
        Assert.assertTrue((boolean)reader.skipFirstLineAsHeader);
    }

    @Test
    public void testIgnoreInvalidLinesConfigure() {
        CsvReader reader = CSVReaderTest.getCsvReader();
        Assert.assertFalse((boolean)reader.ignoreInvalidLines);
        reader.ignoreInvalidLines();
        Assert.assertTrue((boolean)reader.ignoreInvalidLines);
    }

    @Test
    public void testIgnoreComments() {
        CsvReader reader = CSVReaderTest.getCsvReader();
        Assert.assertNull((Object)reader.commentPrefix);
        reader.ignoreComments("#");
        Assert.assertEquals((Object)"#", (Object)reader.commentPrefix);
    }

    @Test
    public void testIncludeFieldsDense() {
        CsvReader reader = CSVReaderTest.getCsvReader();
        reader.includeFields(new boolean[]{true, true, true});
        Assert.assertTrue((boolean)Arrays.equals(new boolean[]{true, true, true}, reader.includedMask));
        reader = CSVReaderTest.getCsvReader();
        reader.includeFields("ttt");
        Assert.assertTrue((boolean)Arrays.equals(new boolean[]{true, true, true}, reader.includedMask));
        reader = CSVReaderTest.getCsvReader();
        reader.includeFields("TTT");
        Assert.assertTrue((boolean)Arrays.equals(new boolean[]{true, true, true}, reader.includedMask));
        reader = CSVReaderTest.getCsvReader();
        reader.includeFields("111");
        Assert.assertTrue((boolean)Arrays.equals(new boolean[]{true, true, true}, reader.includedMask));
        reader = CSVReaderTest.getCsvReader();
        reader.includeFields(7L);
        Assert.assertTrue((boolean)Arrays.equals(new boolean[]{true, true, true}, reader.includedMask));
    }

    @Test
    public void testIncludeFieldsSparse() {
        CsvReader reader = CSVReaderTest.getCsvReader();
        reader.includeFields(new boolean[]{false, true, true, false, false, true, false, false});
        Assert.assertTrue((boolean)Arrays.equals(new boolean[]{false, true, true, false, false, true}, reader.includedMask));
        reader = CSVReaderTest.getCsvReader();
        reader.includeFields("fttfftff");
        Assert.assertTrue((boolean)Arrays.equals(new boolean[]{false, true, true, false, false, true}, reader.includedMask));
        reader = CSVReaderTest.getCsvReader();
        reader.includeFields("FTTFFTFF");
        Assert.assertTrue((boolean)Arrays.equals(new boolean[]{false, true, true, false, false, true}, reader.includedMask));
        reader = CSVReaderTest.getCsvReader();
        reader.includeFields("01100100");
        Assert.assertTrue((boolean)Arrays.equals(new boolean[]{false, true, true, false, false, true}, reader.includedMask));
        reader = CSVReaderTest.getCsvReader();
        reader.includeFields("0t1f0TFF");
        Assert.assertTrue((boolean)Arrays.equals(new boolean[]{false, true, true, false, false, true}, reader.includedMask));
        reader = CSVReaderTest.getCsvReader();
        reader.includeFields(38L);
        Assert.assertTrue((boolean)Arrays.equals(new boolean[]{false, true, true, false, false, true}, reader.includedMask));
    }

    @Test
    public void testIllegalCharInStringMask() {
        CsvReader reader = CSVReaderTest.getCsvReader();
        try {
            reader.includeFields("1t0Tfht");
            Assert.fail((String)"Reader accepted an invalid mask string");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testIncludeFieldsErrorWhenExcludingAll() {
        CsvReader reader = CSVReaderTest.getCsvReader();
        try {
            reader.includeFields(new boolean[]{false, false, false, false, false, false});
            Assert.fail((String)"The reader accepted a fields configuration that excludes all fields.");
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        try {
            reader.includeFields(0L);
            Assert.fail((String)"The reader accepted a fields configuration that excludes all fields.");
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        try {
            reader.includeFields("ffffffffffffff");
            Assert.fail((String)"The reader accepted a fields configuration that excludes all fields.");
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        try {
            reader.includeFields("00000000000000000");
            Assert.fail((String)"The reader accepted a fields configuration that excludes all fields.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testReturnType() throws Exception {
        CsvReader reader = CSVReaderTest.getCsvReader();
        DataSource items = reader.tupleType(Item.class);
        Assert.assertTrue((items.getType().getTypeClass() == Item.class ? 1 : 0) != 0);
    }

    @Test
    public void testFieldTypes() throws Exception {
        CsvReader reader = CSVReaderTest.getCsvReader();
        DataSource items = reader.tupleType(Item.class);
        TypeInformation info = items.getType();
        if (!info.isTupleType()) {
            Assert.fail();
        } else {
            TupleTypeInfo tinfo = (TupleTypeInfo)info;
            Assert.assertEquals((Object)BasicTypeInfo.INT_TYPE_INFO, (Object)tinfo.getTypeAt(0));
            Assert.assertEquals((Object)BasicTypeInfo.STRING_TYPE_INFO, (Object)tinfo.getTypeAt(1));
            Assert.assertEquals((Object)BasicTypeInfo.DOUBLE_TYPE_INFO, (Object)tinfo.getTypeAt(2));
            Assert.assertEquals((Object)BasicTypeInfo.STRING_TYPE_INFO, (Object)tinfo.getTypeAt(3));
        }
        CsvInputFormat inputFormat = (CsvInputFormat)items.getInputFormat();
        Assert.assertArrayEquals((Object[])new Class[]{Integer.class, String.class, Double.class, String.class}, (Object[])inputFormat.getFieldTypes());
    }

    @Test
    public void testSubClass() throws Exception {
        CsvReader reader = CSVReaderTest.getCsvReader();
        DataSource sitems = reader.tupleType(SubItem.class);
        TypeInformation info = sitems.getType();
        Assert.assertEquals((Object)true, (Object)info.isTupleType());
        Assert.assertEquals(SubItem.class, (Object)info.getTypeClass());
        TupleTypeInfo tinfo = (TupleTypeInfo)info;
        Assert.assertEquals((Object)BasicTypeInfo.INT_TYPE_INFO, (Object)tinfo.getTypeAt(0));
        Assert.assertEquals((Object)BasicTypeInfo.STRING_TYPE_INFO, (Object)tinfo.getTypeAt(1));
        Assert.assertEquals((Object)BasicTypeInfo.DOUBLE_TYPE_INFO, (Object)tinfo.getTypeAt(2));
        Assert.assertEquals((Object)BasicTypeInfo.STRING_TYPE_INFO, (Object)tinfo.getTypeAt(3));
        CsvInputFormat inputFormat = (CsvInputFormat)sitems.getInputFormat();
        Assert.assertArrayEquals((Object[])new Class[]{Integer.class, String.class, Double.class, String.class}, (Object[])inputFormat.getFieldTypes());
    }

    @Test
    public void testSubClassWithPartialsInHierarchie() throws Exception {
        CsvReader reader = CSVReaderTest.getCsvReader();
        DataSource sitems = reader.tupleType(FinalItem.class);
        TypeInformation info = sitems.getType();
        Assert.assertEquals((Object)true, (Object)info.isTupleType());
        Assert.assertEquals(FinalItem.class, (Object)info.getTypeClass());
        TupleTypeInfo tinfo = (TupleTypeInfo)info;
        Assert.assertEquals((Object)BasicTypeInfo.INT_TYPE_INFO, (Object)tinfo.getTypeAt(0));
        Assert.assertEquals((Object)BasicTypeInfo.STRING_TYPE_INFO, (Object)tinfo.getTypeAt(1));
        Assert.assertEquals((Object)BasicTypeInfo.DOUBLE_TYPE_INFO, (Object)tinfo.getTypeAt(2));
        Assert.assertEquals(ValueTypeInfo.class, tinfo.getTypeAt(3).getClass());
        Assert.assertEquals(ValueTypeInfo.class, tinfo.getTypeAt(4).getClass());
        Assert.assertEquals(StringValue.class, (Object)((ValueTypeInfo)tinfo.getTypeAt(3)).getTypeClass());
        Assert.assertEquals(LongValue.class, (Object)((ValueTypeInfo)tinfo.getTypeAt(4)).getTypeClass());
        CsvInputFormat inputFormat = (CsvInputFormat)sitems.getInputFormat();
        Assert.assertArrayEquals((Object[])new Class[]{Integer.class, String.class, Double.class, StringValue.class, LongValue.class}, (Object[])inputFormat.getFieldTypes());
    }

    @Test
    public void testUnsupportedPartialitem() throws Exception {
        CsvReader reader = CSVReaderTest.getCsvReader();
        try {
            reader.tupleType(PartialItem.class);
            Assert.fail((String)"tupleType() accepted an underspecified generic class.");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static CsvReader getCsvReader() {
        return new CsvReader("/some/none/existing/path", (ExecutionEnvironment)ExecutionEnvironment.createLocalEnvironment((int)1));
    }

    public static class FinalItem
    extends PartialItem<String, StringValue, LongValue> {
        private static final long serialVersionUID = 1L;
    }

    public static class PartialItem<A, B, C>
    extends Tuple5<Integer, A, Double, B, C> {
        private static final long serialVersionUID = 1L;
    }

    public static class SubItem
    extends Item {
        private static final long serialVersionUID = 1L;
    }

    public static class Item
    extends Tuple4<Integer, String, Double, String> {
        private static final long serialVersionUID = -7444437337392053502L;
    }
}

