/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.functions;

import org.apache.flink.api.common.functions.RichJoinFunction;
import org.apache.flink.api.common.functions.RichMapFunction;
import org.apache.flink.api.common.operators.DualInputSemanticProperties;
import org.apache.flink.api.common.operators.GenericDataSinkBase;
import org.apache.flink.api.common.operators.SingleInputSemanticProperties;
import org.apache.flink.api.common.operators.base.JoinOperatorBase;
import org.apache.flink.api.common.operators.base.MapOperatorBase;
import org.apache.flink.api.common.operators.util.FieldSet;
import org.apache.flink.api.java.DataSet;
import org.apache.flink.api.java.ExecutionEnvironment;
import org.apache.flink.api.java.functions.FunctionAnnotation;
import org.apache.flink.api.java.operators.DataSource;
import org.apache.flink.api.java.operators.translation.JavaPlan;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.api.java.tuple.Tuple3;
import org.junit.Assert;
import org.junit.Test;

public class SemanticPropertiesTranslationTest {
    @Test
    public void translateUnaryFunctionAnnotationTuplesWildCard() {
        try {
            ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
            DataSource input = env.fromElements((Object[])new Tuple3[]{new Tuple3((Object)3L, (Object)"test", (Object)42)});
            input.map(new WildcardConstantMapper()).print();
            JavaPlan plan = env.createProgramPlan();
            GenericDataSinkBase sink = (GenericDataSinkBase)plan.getDataSinks().iterator().next();
            MapOperatorBase mapper = (MapOperatorBase)sink.getInput();
            SingleInputSemanticProperties semantics = mapper.getSemanticProperties();
            FieldSet fw1 = semantics.getForwardedField(0);
            FieldSet fw2 = semantics.getForwardedField(1);
            FieldSet fw3 = semantics.getForwardedField(2);
            Assert.assertNotNull((Object)fw1);
            Assert.assertNotNull((Object)fw2);
            Assert.assertNotNull((Object)fw3);
            Assert.assertTrue((boolean)fw1.contains(Integer.valueOf(0)));
            Assert.assertTrue((boolean)fw2.contains(Integer.valueOf(1)));
            Assert.assertTrue((boolean)fw3.contains(Integer.valueOf(2)));
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            e.printStackTrace();
            Assert.fail((String)("Exception in test: " + e.getMessage()));
        }
    }

    @Test
    public void translateUnaryFunctionAnnotationTuples() {
        try {
            ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
            DataSource input = env.fromElements((Object[])new Tuple3[]{new Tuple3((Object)3L, (Object)"test", (Object)42)});
            input.map(new IndividualConstantMapper()).print();
            JavaPlan plan = env.createProgramPlan();
            GenericDataSinkBase sink = (GenericDataSinkBase)plan.getDataSinks().iterator().next();
            MapOperatorBase mapper = (MapOperatorBase)sink.getInput();
            SingleInputSemanticProperties semantics = mapper.getSemanticProperties();
            FieldSet fw1 = semantics.getForwardedField(0);
            FieldSet fw2 = semantics.getForwardedField(1);
            FieldSet fw3 = semantics.getForwardedField(2);
            Assert.assertNotNull((Object)fw1);
            Assert.assertNotNull((Object)fw2);
            Assert.assertNotNull((Object)fw3);
            Assert.assertTrue((boolean)fw1.contains(Integer.valueOf(0)));
            Assert.assertTrue((boolean)fw2.contains(Integer.valueOf(1)));
            Assert.assertTrue((boolean)fw3.contains(Integer.valueOf(2)));
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            e.printStackTrace();
            Assert.fail((String)("Exception in test: " + e.getMessage()));
        }
    }

    @Test
    public void translateBinaryFunctionAnnotationTuples() {
        try {
            ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
            DataSource input1 = env.fromElements((Object[])new Tuple2[]{new Tuple2((Object)3L, (Object)"test")});
            DataSource input2 = env.fromElements((Object[])new Tuple2[]{new Tuple2((Object)3L, (Object)3.1415)});
            input1.join((DataSet)input2).where(new int[]{0}).equalTo(new int[]{0}).with(new ForwardingTupleJoin()).print();
            JavaPlan plan = env.createProgramPlan();
            GenericDataSinkBase sink = (GenericDataSinkBase)plan.getDataSinks().iterator().next();
            JoinOperatorBase join = (JoinOperatorBase)sink.getInput();
            DualInputSemanticProperties semantics = join.getSemanticProperties();
            FieldSet fw11 = semantics.getForwardedField1(0);
            FieldSet fw12 = semantics.getForwardedField1(1);
            FieldSet fw21 = semantics.getForwardedField2(0);
            FieldSet fw22 = semantics.getForwardedField2(1);
            Assert.assertNull((Object)fw11);
            Assert.assertNull((Object)fw21);
            Assert.assertNotNull((Object)fw12);
            Assert.assertNotNull((Object)fw22);
            Assert.assertTrue((boolean)fw12.contains(Integer.valueOf(0)));
            Assert.assertTrue((boolean)fw22.contains(Integer.valueOf(1)));
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            e.printStackTrace();
            Assert.fail((String)("Exception in test: " + e.getMessage()));
        }
    }

    @FunctionAnnotation.ConstantFieldsFirst(value={"0 -> 0"})
    @FunctionAnnotation.ConstantFieldsSecond(value={"0 -> 1"})
    public static class ForwardingBasicJoin<A, B>
    extends RichJoinFunction<A, B, Tuple2<A, B>> {
        public Tuple2<A, B> join(A first, B second) {
            return new Tuple2(first, second);
        }
    }

    @FunctionAnnotation.ConstantFieldsFirst(value={"1 -> 0"})
    @FunctionAnnotation.ConstantFieldsSecond(value={"1 -> 1"})
    public static class ForwardingTupleJoin<A, B, C, D>
    extends RichJoinFunction<Tuple2<A, B>, Tuple2<C, D>, Tuple2<B, D>> {
        public Tuple2<B, D> join(Tuple2<A, B> first, Tuple2<C, D> second) {
            return new Tuple2(first.f1, second.f1);
        }
    }

    @FunctionAnnotation.ConstantFields(value={"0"})
    public static class ZeroConstantMapper<T>
    extends RichMapFunction<T, T> {
        public T map(T value) {
            return value;
        }
    }

    @FunctionAnnotation.ConstantFields(value={"0->0;1->1;2->2"})
    public static class IndividualConstantMapper<X, Y, Z>
    extends RichMapFunction<Tuple3<X, Y, Z>, Tuple3<X, Y, Z>> {
        public Tuple3<X, Y, Z> map(Tuple3<X, Y, Z> value) {
            return value;
        }
    }

    @FunctionAnnotation.ConstantFields(value={"*"})
    public static class WildcardConstantMapper<T>
    extends RichMapFunction<T, T> {
        public T map(T value) {
            return value;
        }
    }
}

