/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.functions;

import java.util.ArrayList;
import java.util.List;
import org.apache.flink.api.common.operators.DualInputSemanticProperties;
import org.apache.flink.api.common.operators.GenericDataSinkBase;
import org.apache.flink.api.common.operators.SingleInputSemanticProperties;
import org.apache.flink.api.common.operators.base.CrossOperatorBase;
import org.apache.flink.api.common.operators.base.JoinOperatorBase;
import org.apache.flink.api.common.typeinfo.BasicTypeInfo;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.DataSet;
import org.apache.flink.api.java.ExecutionEnvironment;
import org.apache.flink.api.java.operators.CrossOperator;
import org.apache.flink.api.java.operators.DataSource;
import org.apache.flink.api.java.operators.translation.JavaPlan;
import org.apache.flink.api.java.operators.translation.PlanProjectOperator;
import org.apache.flink.api.java.tuple.Tuple5;
import org.apache.flink.api.java.typeutils.TupleTypeInfo;
import org.junit.Assert;
import org.junit.Test;

public class SemanticPropertiesProjectionTest {
    final List<Tuple5<Integer, Long, String, Long, Integer>> emptyTupleData = new ArrayList<Tuple5<Integer, Long, String, Long, Integer>>();
    final TupleTypeInfo<Tuple5<Integer, Long, String, Long, Integer>> tupleTypeInfo = new TupleTypeInfo(new TypeInformation[]{BasicTypeInfo.INT_TYPE_INFO, BasicTypeInfo.LONG_TYPE_INFO, BasicTypeInfo.STRING_TYPE_INFO, BasicTypeInfo.LONG_TYPE_INFO, BasicTypeInfo.INT_TYPE_INFO});

    @Test
    public void ProjectOperatorTest() {
        try {
            ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
            DataSource tupleDs = env.fromCollection(this.emptyTupleData, this.tupleTypeInfo);
            tupleDs.project(new int[]{1, 3, 2}).print();
            JavaPlan plan = env.createProgramPlan();
            GenericDataSinkBase sink = (GenericDataSinkBase)plan.getDataSinks().iterator().next();
            PlanProjectOperator projectOperator = (PlanProjectOperator)sink.getInput();
            SingleInputSemanticProperties props = projectOperator.getSemanticProperties();
            Assert.assertTrue((props.getForwardedField(1).size() == 1 ? 1 : 0) != 0);
            Assert.assertTrue((props.getForwardedField(3).size() == 1 ? 1 : 0) != 0);
            Assert.assertTrue((props.getForwardedField(2).size() == 1 ? 1 : 0) != 0);
            Assert.assertTrue((boolean)props.getForwardedField(1).contains(Integer.valueOf(0)));
            Assert.assertTrue((boolean)props.getForwardedField(3).contains(Integer.valueOf(1)));
            Assert.assertTrue((boolean)props.getForwardedField(2).contains(Integer.valueOf(2)));
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            e.printStackTrace();
            Assert.fail((String)("Exception in test: " + e.getMessage()));
        }
    }

    @Test
    public void ProjectOperatorWithoutTypesClassTest() {
        try {
            ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
            DataSource tupleDs = env.fromCollection(this.emptyTupleData, this.tupleTypeInfo);
            tupleDs.project(new int[]{1, 3}).project(new int[]{2}).project(new int[]{0}).print();
            JavaPlan plan = env.createProgramPlan();
            GenericDataSinkBase sink = (GenericDataSinkBase)plan.getDataSinks().iterator().next();
            PlanProjectOperator projectOperator = (PlanProjectOperator)sink.getInput();
            SingleInputSemanticProperties props = projectOperator.getSemanticProperties();
            Assert.assertTrue((props.getForwardedField(1).size() == 1 ? 1 : 0) != 0);
            Assert.assertTrue((props.getForwardedField(3).size() == 1 ? 1 : 0) != 0);
            Assert.assertTrue((props.getForwardedField(2).size() == 1 ? 1 : 0) != 0);
            Assert.assertTrue((props.getForwardedField(0).size() == 1 ? 1 : 0) != 0);
            Assert.assertTrue((boolean)props.getForwardedField(1).contains(Integer.valueOf(0)));
            Assert.assertTrue((boolean)props.getForwardedField(3).contains(Integer.valueOf(1)));
            Assert.assertTrue((boolean)props.getForwardedField(2).contains(Integer.valueOf(2)));
            Assert.assertTrue((boolean)props.getForwardedField(0).contains(Integer.valueOf(3)));
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            e.printStackTrace();
            Assert.fail((String)("Exception in test: " + e.getMessage()));
        }
    }

    @Test
    public void JoinProjectionTest() {
        try {
            ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
            DataSource tupleDs = env.fromCollection(this.emptyTupleData, this.tupleTypeInfo);
            tupleDs.join((DataSet)tupleDs).where(new int[]{0}).equalTo(new int[]{0}).projectFirst(new int[]{2, 3}).projectSecond(new int[]{1, 4}).print();
            JavaPlan plan = env.createProgramPlan();
            GenericDataSinkBase sink = (GenericDataSinkBase)plan.getDataSinks().iterator().next();
            JoinOperatorBase projectJoinOperator = (JoinOperatorBase)sink.getInput();
            DualInputSemanticProperties props = projectJoinOperator.getSemanticProperties();
            Assert.assertTrue((props.getForwardedField1(2).size() == 1 ? 1 : 0) != 0);
            Assert.assertTrue((props.getForwardedField1(3).size() == 1 ? 1 : 0) != 0);
            Assert.assertTrue((props.getForwardedField2(1).size() == 1 ? 1 : 0) != 0);
            Assert.assertTrue((props.getForwardedField2(4).size() == 1 ? 1 : 0) != 0);
            Assert.assertTrue((boolean)props.getForwardedField1(2).contains(Integer.valueOf(0)));
            Assert.assertTrue((boolean)props.getForwardedField1(3).contains(Integer.valueOf(1)));
            Assert.assertTrue((boolean)props.getForwardedField2(1).contains(Integer.valueOf(2)));
            Assert.assertTrue((boolean)props.getForwardedField2(4).contains(Integer.valueOf(3)));
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            e.printStackTrace();
            Assert.fail((String)("Exception in test: " + e.getMessage()));
        }
    }

    @Test
    public void JoinProjectionWithoutTypesClassTest() {
        try {
            ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
            DataSource tupleDs = env.fromCollection(this.emptyTupleData, this.tupleTypeInfo);
            tupleDs.join((DataSet)tupleDs).where(new int[]{0}).equalTo(new int[]{0}).projectFirst(new int[]{2}).projectFirst(new int[]{3}).projectSecond(new int[]{1, 4}).print();
            JavaPlan plan = env.createProgramPlan();
            GenericDataSinkBase sink = (GenericDataSinkBase)plan.getDataSinks().iterator().next();
            JoinOperatorBase projectJoinOperator = (JoinOperatorBase)sink.getInput();
            DualInputSemanticProperties props = projectJoinOperator.getSemanticProperties();
            Assert.assertTrue((props.getForwardedField1(2).size() == 1 ? 1 : 0) != 0);
            Assert.assertTrue((props.getForwardedField1(3).size() == 1 ? 1 : 0) != 0);
            Assert.assertTrue((props.getForwardedField2(1).size() == 1 ? 1 : 0) != 0);
            Assert.assertTrue((props.getForwardedField2(4).size() == 1 ? 1 : 0) != 0);
            Assert.assertTrue((boolean)props.getForwardedField1(2).contains(Integer.valueOf(0)));
            Assert.assertTrue((boolean)props.getForwardedField1(3).contains(Integer.valueOf(1)));
            Assert.assertTrue((boolean)props.getForwardedField2(1).contains(Integer.valueOf(2)));
            Assert.assertTrue((boolean)props.getForwardedField2(4).contains(Integer.valueOf(3)));
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            e.printStackTrace();
            Assert.fail((String)("Exception in test: " + e.getMessage()));
        }
    }

    @Test
    public void CrossProjectionTest() {
        try {
            ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
            DataSource tupleDs = env.fromCollection(this.emptyTupleData, this.tupleTypeInfo);
            CrossOperator.ProjectCross result = tupleDs.cross((DataSet)tupleDs).projectFirst(new int[]{2, 3}).projectSecond(new int[]{1, 4});
            result.print();
            JavaPlan plan = env.createProgramPlan();
            GenericDataSinkBase sink = (GenericDataSinkBase)plan.getDataSinks().iterator().next();
            CrossOperatorBase projectCrossOperator = (CrossOperatorBase)sink.getInput();
            DualInputSemanticProperties props = projectCrossOperator.getSemanticProperties();
            Assert.assertTrue((props.getForwardedField1(2).size() == 1 ? 1 : 0) != 0);
            Assert.assertTrue((props.getForwardedField1(3).size() == 1 ? 1 : 0) != 0);
            Assert.assertTrue((props.getForwardedField2(1).size() == 1 ? 1 : 0) != 0);
            Assert.assertTrue((props.getForwardedField2(4).size() == 1 ? 1 : 0) != 0);
            Assert.assertTrue((boolean)props.getForwardedField1(2).contains(Integer.valueOf(0)));
            Assert.assertTrue((boolean)props.getForwardedField1(3).contains(Integer.valueOf(1)));
            Assert.assertTrue((boolean)props.getForwardedField2(1).contains(Integer.valueOf(2)));
            Assert.assertTrue((boolean)props.getForwardedField2(4).contains(Integer.valueOf(3)));
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            e.printStackTrace();
            Assert.fail((String)("Exception in test: " + e.getMessage()));
        }
    }

    @Test
    public void CrossProjectionWithoutTypesClassTest() {
        try {
            ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
            DataSource tupleDs = env.fromCollection(this.emptyTupleData, this.tupleTypeInfo);
            CrossOperator.ProjectCross result = tupleDs.cross((DataSet)tupleDs).projectFirst(new int[]{2, 3}).projectSecond(new int[]{1, 4});
            result.print();
            JavaPlan plan = env.createProgramPlan();
            GenericDataSinkBase sink = (GenericDataSinkBase)plan.getDataSinks().iterator().next();
            CrossOperatorBase projectCrossOperator = (CrossOperatorBase)sink.getInput();
            DualInputSemanticProperties props = projectCrossOperator.getSemanticProperties();
            Assert.assertTrue((props.getForwardedField1(2).size() == 1 ? 1 : 0) != 0);
            Assert.assertTrue((props.getForwardedField1(3).size() == 1 ? 1 : 0) != 0);
            Assert.assertTrue((props.getForwardedField2(1).size() == 1 ? 1 : 0) != 0);
            Assert.assertTrue((props.getForwardedField2(4).size() == 1 ? 1 : 0) != 0);
            Assert.assertTrue((boolean)props.getForwardedField1(2).contains(Integer.valueOf(0)));
            Assert.assertTrue((boolean)props.getForwardedField1(3).contains(Integer.valueOf(1)));
            Assert.assertTrue((boolean)props.getForwardedField2(1).contains(Integer.valueOf(2)));
            Assert.assertTrue((boolean)props.getForwardedField2(4).contains(Integer.valueOf(3)));
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            e.printStackTrace();
            Assert.fail((String)("Exception in test: " + e.getMessage()));
        }
    }
}

