/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.functions;

import org.apache.flink.api.common.InvalidProgramException;
import org.apache.flink.api.common.operators.DualInputSemanticProperties;
import org.apache.flink.api.common.operators.SingleInputSemanticProperties;
import org.apache.flink.api.common.operators.util.FieldSet;
import org.apache.flink.api.common.typeinfo.BasicTypeInfo;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.functions.SemanticPropUtil;
import org.apache.flink.api.java.typeutils.TupleTypeInfo;
import org.junit.Assert;
import org.junit.Test;

public class SemanticPropUtilTest {
    @Test
    public void testConstantWithArrowIndividualStrings() {
        String[] constantFields = new String[]{"0->0,1", "1->2"};
        TupleTypeInfo type = new TupleTypeInfo(new TypeInformation[]{BasicTypeInfo.INT_TYPE_INFO, BasicTypeInfo.INT_TYPE_INFO, BasicTypeInfo.INT_TYPE_INFO});
        SingleInputSemanticProperties sp = SemanticPropUtil.getSemanticPropsSingleFromString((String[])constantFields, null, null, (TypeInformation)type, (TypeInformation)type);
        FieldSet fs = sp.getForwardedField(0);
        Assert.assertTrue((fs.size() == 2 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)fs.contains(Integer.valueOf(0)));
        Assert.assertTrue((boolean)fs.contains(Integer.valueOf(1)));
        fs = sp.getForwardedField(1);
        Assert.assertTrue((fs.size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)fs.contains(Integer.valueOf(2)));
        constantFields = new String[]{"0 -> 0 ,   1 ", " 1     -> 2  "};
        type = new TupleTypeInfo(new TypeInformation[]{BasicTypeInfo.INT_TYPE_INFO, BasicTypeInfo.INT_TYPE_INFO, BasicTypeInfo.INT_TYPE_INFO});
        sp = SemanticPropUtil.getSemanticPropsSingleFromString((String[])constantFields, null, null, (TypeInformation)type, (TypeInformation)type);
        fs = sp.getForwardedField(0);
        Assert.assertTrue((fs.size() == 2 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)fs.contains(Integer.valueOf(0)));
        Assert.assertTrue((boolean)fs.contains(Integer.valueOf(1)));
        fs = sp.getForwardedField(1);
        Assert.assertTrue((fs.size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)fs.contains(Integer.valueOf(2)));
    }

    @Test
    public void testConstantWithArrowIndividualStringsSpaces() {
        String[] constantFields = new String[]{"  1-> 1 , 2", "2 ->3"};
        TupleTypeInfo type = new TupleTypeInfo(new TypeInformation[]{BasicTypeInfo.INT_TYPE_INFO, BasicTypeInfo.INT_TYPE_INFO, BasicTypeInfo.INT_TYPE_INFO, BasicTypeInfo.INT_TYPE_INFO});
        SingleInputSemanticProperties sp = SemanticPropUtil.getSemanticPropsSingleFromString((String[])constantFields, null, null, (TypeInformation)type, (TypeInformation)type);
        FieldSet fs = sp.getForwardedField(1);
        Assert.assertTrue((fs.size() == 2 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)fs.contains(Integer.valueOf(1)));
        Assert.assertTrue((boolean)fs.contains(Integer.valueOf(2)));
        fs = sp.getForwardedField(2);
        Assert.assertTrue((fs.size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)fs.contains(Integer.valueOf(3)));
    }

    @Test
    public void testConstantWithArrowOneString() {
        String[] constantFields = new String[]{"0->0,1;1->2"};
        TupleTypeInfo type = new TupleTypeInfo(new TypeInformation[]{BasicTypeInfo.INT_TYPE_INFO, BasicTypeInfo.INT_TYPE_INFO, BasicTypeInfo.INT_TYPE_INFO});
        SingleInputSemanticProperties sp = SemanticPropUtil.getSemanticPropsSingleFromString((String[])constantFields, null, null, (TypeInformation)type, (TypeInformation)type);
        FieldSet fs = sp.getForwardedField(0);
        Assert.assertTrue((fs.size() == 2 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)fs.contains(Integer.valueOf(0)));
        Assert.assertTrue((boolean)fs.contains(Integer.valueOf(1)));
        fs = sp.getForwardedField(1);
        Assert.assertTrue((fs.size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)fs.contains(Integer.valueOf(2)));
        constantFields = new String[]{"  0 ->  0  ,  1  ;   1  -> 2 "};
        type = new TupleTypeInfo(new TypeInformation[]{BasicTypeInfo.INT_TYPE_INFO, BasicTypeInfo.INT_TYPE_INFO, BasicTypeInfo.INT_TYPE_INFO});
        sp = SemanticPropUtil.getSemanticPropsSingleFromString((String[])constantFields, null, null, (TypeInformation)type, (TypeInformation)type);
        fs = sp.getForwardedField(0);
        Assert.assertTrue((fs.size() == 2 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)fs.contains(Integer.valueOf(0)));
        Assert.assertTrue((boolean)fs.contains(Integer.valueOf(1)));
        fs = sp.getForwardedField(1);
        Assert.assertTrue((fs.size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)fs.contains(Integer.valueOf(2)));
    }

    @Test
    public void testConstantNoArrrowIndividualStrings() {
        String[] constantFields = new String[]{"2", "3", "0"};
        TupleTypeInfo type = new TupleTypeInfo(new TypeInformation[]{BasicTypeInfo.INT_TYPE_INFO, BasicTypeInfo.INT_TYPE_INFO, BasicTypeInfo.INT_TYPE_INFO, BasicTypeInfo.INT_TYPE_INFO, BasicTypeInfo.INT_TYPE_INFO});
        SingleInputSemanticProperties sp = SemanticPropUtil.getSemanticPropsSingleFromString((String[])constantFields, null, null, (TypeInformation)type, (TypeInformation)type);
        FieldSet fs = sp.getForwardedField(0);
        Assert.assertTrue((fs.size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)fs.contains(Integer.valueOf(0)));
        fs = sp.getForwardedField(2);
        Assert.assertTrue((fs.size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)fs.contains(Integer.valueOf(2)));
        fs = sp.getForwardedField(3);
        Assert.assertTrue((fs.size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)fs.contains(Integer.valueOf(3)));
        Assert.assertNull((Object)sp.getForwardedField(1));
        Assert.assertNull((Object)sp.getForwardedField(4));
        constantFields = new String[]{" 2   ", "3  ", "  0"};
        type = new TupleTypeInfo(new TypeInformation[]{BasicTypeInfo.INT_TYPE_INFO, BasicTypeInfo.INT_TYPE_INFO, BasicTypeInfo.INT_TYPE_INFO, BasicTypeInfo.INT_TYPE_INFO, BasicTypeInfo.INT_TYPE_INFO});
        sp = SemanticPropUtil.getSemanticPropsSingleFromString((String[])constantFields, null, null, (TypeInformation)type, (TypeInformation)type);
        fs = sp.getForwardedField(0);
        Assert.assertTrue((fs.size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)fs.contains(Integer.valueOf(0)));
        fs = sp.getForwardedField(2);
        Assert.assertTrue((fs.size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)fs.contains(Integer.valueOf(2)));
        fs = sp.getForwardedField(3);
        Assert.assertTrue((fs.size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)fs.contains(Integer.valueOf(3)));
        Assert.assertNull((Object)sp.getForwardedField(1));
        Assert.assertNull((Object)sp.getForwardedField(4));
    }

    @Test
    public void testConstantNoArrrowOneString() {
        String[] constantFields = new String[]{"2;3;0"};
        TupleTypeInfo type = new TupleTypeInfo(new TypeInformation[]{BasicTypeInfo.INT_TYPE_INFO, BasicTypeInfo.INT_TYPE_INFO, BasicTypeInfo.INT_TYPE_INFO, BasicTypeInfo.INT_TYPE_INFO, BasicTypeInfo.INT_TYPE_INFO});
        SingleInputSemanticProperties sp = SemanticPropUtil.getSemanticPropsSingleFromString((String[])constantFields, null, null, (TypeInformation)type, (TypeInformation)type);
        FieldSet fs = sp.getForwardedField(0);
        Assert.assertTrue((fs.size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)fs.contains(Integer.valueOf(0)));
        fs = sp.getForwardedField(2);
        Assert.assertTrue((fs.size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)fs.contains(Integer.valueOf(2)));
        fs = sp.getForwardedField(3);
        Assert.assertTrue((fs.size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)fs.contains(Integer.valueOf(3)));
        Assert.assertNull((Object)sp.getForwardedField(1));
        Assert.assertNull((Object)sp.getForwardedField(4));
        constantFields = new String[]{"  2  ;   3  ;  0   "};
        type = new TupleTypeInfo(new TypeInformation[]{BasicTypeInfo.INT_TYPE_INFO, BasicTypeInfo.INT_TYPE_INFO, BasicTypeInfo.INT_TYPE_INFO, BasicTypeInfo.INT_TYPE_INFO, BasicTypeInfo.INT_TYPE_INFO});
        sp = SemanticPropUtil.getSemanticPropsSingleFromString((String[])constantFields, null, null, (TypeInformation)type, (TypeInformation)type);
        fs = sp.getForwardedField(0);
        Assert.assertTrue((fs.size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)fs.contains(Integer.valueOf(0)));
        fs = sp.getForwardedField(2);
        Assert.assertTrue((fs.size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)fs.contains(Integer.valueOf(2)));
        fs = sp.getForwardedField(3);
        Assert.assertTrue((fs.size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)fs.contains(Integer.valueOf(3)));
        Assert.assertNull((Object)sp.getForwardedField(1));
        Assert.assertNull((Object)sp.getForwardedField(4));
    }

    @Test
    public void testConstantMixedOneString() {
        String[] constantFields = new String[]{"2,3;0->1,4;4->0"};
        TupleTypeInfo type = new TupleTypeInfo(new TypeInformation[]{BasicTypeInfo.INT_TYPE_INFO, BasicTypeInfo.INT_TYPE_INFO, BasicTypeInfo.INT_TYPE_INFO, BasicTypeInfo.INT_TYPE_INFO, BasicTypeInfo.INT_TYPE_INFO});
        SingleInputSemanticProperties sp = SemanticPropUtil.getSemanticPropsSingleFromString((String[])constantFields, null, null, (TypeInformation)type, (TypeInformation)type);
        FieldSet fs = sp.getForwardedField(0);
        Assert.assertTrue((fs.size() == 2 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)fs.contains(Integer.valueOf(1)));
        Assert.assertTrue((boolean)fs.contains(Integer.valueOf(4)));
        fs = sp.getForwardedField(2);
        Assert.assertTrue((fs.size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)fs.contains(Integer.valueOf(2)));
        fs = sp.getForwardedField(3);
        Assert.assertTrue((fs.size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)fs.contains(Integer.valueOf(3)));
        fs = sp.getForwardedField(4);
        Assert.assertTrue((fs.size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)fs.contains(Integer.valueOf(0)));
        constantFields = new String[]{" 2  ,  3   ;  0 -> 1  , 4 ; 4 ->  0"};
        type = new TupleTypeInfo(new TypeInformation[]{BasicTypeInfo.INT_TYPE_INFO, BasicTypeInfo.INT_TYPE_INFO, BasicTypeInfo.INT_TYPE_INFO, BasicTypeInfo.INT_TYPE_INFO, BasicTypeInfo.INT_TYPE_INFO});
        sp = SemanticPropUtil.getSemanticPropsSingleFromString((String[])constantFields, null, null, (TypeInformation)type, (TypeInformation)type);
        fs = sp.getForwardedField(0);
        Assert.assertTrue((fs.size() == 2 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)fs.contains(Integer.valueOf(1)));
        Assert.assertTrue((boolean)fs.contains(Integer.valueOf(4)));
        fs = sp.getForwardedField(2);
        Assert.assertTrue((fs.size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)fs.contains(Integer.valueOf(2)));
        fs = sp.getForwardedField(3);
        Assert.assertTrue((fs.size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)fs.contains(Integer.valueOf(3)));
        fs = sp.getForwardedField(4);
        Assert.assertTrue((fs.size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)fs.contains(Integer.valueOf(0)));
    }

    @Test
    public void testConstantWildCard() {
        String[] constantFields = new String[]{"*"};
        TupleTypeInfo type = new TupleTypeInfo(new TypeInformation[]{BasicTypeInfo.INT_TYPE_INFO, BasicTypeInfo.INT_TYPE_INFO, BasicTypeInfo.INT_TYPE_INFO});
        SingleInputSemanticProperties sp = SemanticPropUtil.getSemanticPropsSingleFromString((String[])constantFields, null, null, (TypeInformation)type, (TypeInformation)type);
        FieldSet fs = sp.getForwardedField(1);
        Assert.assertTrue((fs.size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)fs.contains(Integer.valueOf(1)));
        fs = sp.getForwardedField(2);
        Assert.assertTrue((fs.size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)fs.contains(Integer.valueOf(2)));
        fs = sp.getForwardedField(0);
        Assert.assertTrue((fs.size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)fs.contains(Integer.valueOf(0)));
    }

    @Test
    public void testConstantWildCard2() {
        String[] constantFields = new String[]{"1->*"};
        TupleTypeInfo type = new TupleTypeInfo(new TypeInformation[]{BasicTypeInfo.INT_TYPE_INFO, BasicTypeInfo.INT_TYPE_INFO, BasicTypeInfo.INT_TYPE_INFO});
        SingleInputSemanticProperties sp = SemanticPropUtil.getSemanticPropsSingleFromString((String[])constantFields, null, null, (TypeInformation)type, (TypeInformation)type);
        FieldSet fs = sp.getForwardedField(1);
        Assert.assertTrue((fs.size() == 3 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)fs.contains(Integer.valueOf(0)));
        Assert.assertTrue((boolean)fs.contains(Integer.valueOf(1)));
        Assert.assertTrue((boolean)fs.contains(Integer.valueOf(2)));
        Assert.assertTrue((sp.getForwardedField(0) == null ? 1 : 0) != 0);
        Assert.assertTrue((sp.getForwardedField(2) == null ? 1 : 0) != 0);
    }

    @Test
    public void testConstantInvalidString() {
        String[] constantFields = new String[]{"notValid"};
        TupleTypeInfo type = new TupleTypeInfo(new TypeInformation[]{BasicTypeInfo.INT_TYPE_INFO, BasicTypeInfo.INT_TYPE_INFO, BasicTypeInfo.INT_TYPE_INFO});
        try {
            SemanticPropUtil.getSemanticPropsSingleFromString((String[])constantFields, null, null, (TypeInformation)type, (TypeInformation)type);
            Assert.fail((String)"accepted invalid input");
        }
        catch (InvalidProgramException e) {
        }
        catch (Exception e) {
            Assert.fail((String)"Wrong type of exception thrown");
        }
    }

    @Test
    public void testConstantExceptOneString() {
        String[] constantFieldsExcept = new String[]{"1"};
        TupleTypeInfo type = new TupleTypeInfo(new TypeInformation[]{BasicTypeInfo.INT_TYPE_INFO, BasicTypeInfo.INT_TYPE_INFO, BasicTypeInfo.INT_TYPE_INFO});
        SingleInputSemanticProperties sp = SemanticPropUtil.getSemanticPropsSingleFromString(null, (String[])constantFieldsExcept, null, (TypeInformation)type, (TypeInformation)type);
        FieldSet fs = sp.getForwardedField(0);
        Assert.assertTrue((fs.size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)fs.contains(Integer.valueOf(0)));
        Assert.assertNull((Object)sp.getForwardedField(1));
        fs = sp.getForwardedField(2);
        Assert.assertTrue((fs.size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)fs.contains(Integer.valueOf(2)));
        constantFieldsExcept = new String[]{" 1  "};
        type = new TupleTypeInfo(new TypeInformation[]{BasicTypeInfo.INT_TYPE_INFO, BasicTypeInfo.INT_TYPE_INFO, BasicTypeInfo.INT_TYPE_INFO});
        sp = SemanticPropUtil.getSemanticPropsSingleFromString(null, (String[])constantFieldsExcept, null, (TypeInformation)type, (TypeInformation)type);
        fs = sp.getForwardedField(0);
        Assert.assertTrue((fs.size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)fs.contains(Integer.valueOf(0)));
        Assert.assertNull((Object)sp.getForwardedField(1));
        fs = sp.getForwardedField(2);
        Assert.assertTrue((fs.size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)fs.contains(Integer.valueOf(2)));
    }

    @Test
    public void testConstantExceptSingleString() {
        String[] constantFieldsExcept = new String[]{"1,2"};
        TupleTypeInfo type = new TupleTypeInfo(new TypeInformation[]{BasicTypeInfo.INT_TYPE_INFO, BasicTypeInfo.INT_TYPE_INFO, BasicTypeInfo.INT_TYPE_INFO});
        SingleInputSemanticProperties sp = SemanticPropUtil.getSemanticPropsSingleFromString(null, (String[])constantFieldsExcept, null, (TypeInformation)type, (TypeInformation)type);
        FieldSet fs = sp.getForwardedField(0);
        Assert.assertTrue((fs.size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)fs.contains(Integer.valueOf(0)));
        Assert.assertNull((Object)sp.getForwardedField(1));
        Assert.assertNull((Object)sp.getForwardedField(2));
        constantFieldsExcept = new String[]{" 1  , 2"};
        type = new TupleTypeInfo(new TypeInformation[]{BasicTypeInfo.INT_TYPE_INFO, BasicTypeInfo.INT_TYPE_INFO, BasicTypeInfo.INT_TYPE_INFO});
        sp = SemanticPropUtil.getSemanticPropsSingleFromString(null, (String[])constantFieldsExcept, null, (TypeInformation)type, (TypeInformation)type);
        fs = sp.getForwardedField(0);
        Assert.assertTrue((fs.size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)fs.contains(Integer.valueOf(0)));
        Assert.assertNull((Object)sp.getForwardedField(1));
        Assert.assertNull((Object)sp.getForwardedField(2));
    }

    @Test
    public void testConstantExceptString() {
        String[] constantFieldsExcept = new String[]{"notValid"};
        TupleTypeInfo type = new TupleTypeInfo(new TypeInformation[]{BasicTypeInfo.INT_TYPE_INFO, BasicTypeInfo.INT_TYPE_INFO, BasicTypeInfo.INT_TYPE_INFO});
        try {
            SemanticPropUtil.getSemanticPropsSingleFromString(null, (String[])constantFieldsExcept, null, (TypeInformation)type, (TypeInformation)type);
            Assert.fail();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void testReadFieldsIndividualStrings() {
        String[] readFields = new String[]{"1", "2"};
        TupleTypeInfo type = new TupleTypeInfo(new TypeInformation[]{BasicTypeInfo.INT_TYPE_INFO, BasicTypeInfo.INT_TYPE_INFO, BasicTypeInfo.INT_TYPE_INFO});
        SingleInputSemanticProperties sp = SemanticPropUtil.getSemanticPropsSingleFromString(null, null, (String[])readFields, (TypeInformation)type, (TypeInformation)type);
        FieldSet fs = sp.getReadFields();
        Assert.assertTrue((fs.size() == 2 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)fs.contains(Integer.valueOf(2)));
        Assert.assertTrue((boolean)fs.contains(Integer.valueOf(1)));
        readFields = new String[]{"   1    ", " 2   "};
        type = new TupleTypeInfo(new TypeInformation[]{BasicTypeInfo.INT_TYPE_INFO, BasicTypeInfo.INT_TYPE_INFO, BasicTypeInfo.INT_TYPE_INFO});
        sp = SemanticPropUtil.getSemanticPropsSingleFromString(null, null, (String[])readFields, (TypeInformation)type, (TypeInformation)type);
        fs = sp.getReadFields();
        Assert.assertTrue((fs.size() == 2 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)fs.contains(Integer.valueOf(2)));
        Assert.assertTrue((boolean)fs.contains(Integer.valueOf(1)));
    }

    @Test
    public void testReadFieldsOneString() {
        String[] readFields = new String[]{"1,2"};
        TupleTypeInfo type = new TupleTypeInfo(new TypeInformation[]{BasicTypeInfo.INT_TYPE_INFO, BasicTypeInfo.INT_TYPE_INFO, BasicTypeInfo.INT_TYPE_INFO});
        SingleInputSemanticProperties sp = SemanticPropUtil.getSemanticPropsSingleFromString(null, null, (String[])readFields, (TypeInformation)type, (TypeInformation)type);
        FieldSet fs = sp.getReadFields();
        Assert.assertTrue((fs.size() == 2 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)fs.contains(Integer.valueOf(2)));
        Assert.assertTrue((boolean)fs.contains(Integer.valueOf(1)));
        readFields = new String[]{"  1  , 2   "};
        type = new TupleTypeInfo(new TypeInformation[]{BasicTypeInfo.INT_TYPE_INFO, BasicTypeInfo.INT_TYPE_INFO, BasicTypeInfo.INT_TYPE_INFO});
        sp = SemanticPropUtil.getSemanticPropsSingleFromString(null, null, (String[])readFields, (TypeInformation)type, (TypeInformation)type);
        fs = sp.getReadFields();
        Assert.assertTrue((fs.size() == 2 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)fs.contains(Integer.valueOf(2)));
        Assert.assertTrue((boolean)fs.contains(Integer.valueOf(1)));
    }

    @Test
    public void testReadFieldsInvalidString() {
        String[] readFields = new String[]{"notValid"};
        TupleTypeInfo type = new TupleTypeInfo(new TypeInformation[]{BasicTypeInfo.INT_TYPE_INFO, BasicTypeInfo.INT_TYPE_INFO, BasicTypeInfo.INT_TYPE_INFO});
        try {
            SemanticPropUtil.getSemanticPropsSingleFromString(null, null, (String[])readFields, (TypeInformation)type, (TypeInformation)type);
            Assert.fail((String)"accepted invalid input");
        }
        catch (InvalidProgramException e) {
        }
        catch (Exception e) {
            Assert.fail((String)"Wrong type of exception thrown");
        }
    }

    @Test
    public void testSimpleCaseDual() {
        String[] constantFieldsFirst = new String[]{"1->1,2", "2->3"};
        String[] constantFieldsSecond = new String[]{"1->1,2", "2->3"};
        TupleTypeInfo type = new TupleTypeInfo(new TypeInformation[]{BasicTypeInfo.INT_TYPE_INFO, BasicTypeInfo.INT_TYPE_INFO, BasicTypeInfo.INT_TYPE_INFO, BasicTypeInfo.INT_TYPE_INFO});
        DualInputSemanticProperties dsp = new DualInputSemanticProperties();
        SemanticPropUtil.getSemanticPropsDualFromString((DualInputSemanticProperties)dsp, (String[])constantFieldsFirst, (String[])constantFieldsSecond, null, null, null, null, (TypeInformation)type, (TypeInformation)type, (TypeInformation)type);
        FieldSet fs = dsp.getForwardedField1(1);
        Assert.assertTrue((fs.size() == 2 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)fs.contains(Integer.valueOf(1)));
        Assert.assertTrue((boolean)fs.contains(Integer.valueOf(2)));
        fs = dsp.getForwardedField1(2);
        Assert.assertTrue((fs.size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)fs.contains(Integer.valueOf(3)));
    }

    @Test
    public void testFieldsExceptDual() {
        String[] constantFieldsFirstExcept = new String[]{"1,2"};
        String[] constantFieldsSecond = new String[]{"0->1"};
        DualInputSemanticProperties dsp = new DualInputSemanticProperties();
        TupleTypeInfo type = new TupleTypeInfo(new TypeInformation[]{BasicTypeInfo.INT_TYPE_INFO, BasicTypeInfo.INT_TYPE_INFO, BasicTypeInfo.INT_TYPE_INFO});
        SemanticPropUtil.getSemanticPropsDualFromString((DualInputSemanticProperties)dsp, null, (String[])constantFieldsSecond, (String[])constantFieldsFirstExcept, null, null, null, (TypeInformation)type, (TypeInformation)type, (TypeInformation)type);
        FieldSet fs = dsp.getForwardedField1(0);
        Assert.assertTrue((fs.size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)fs.contains(Integer.valueOf(0)));
        fs = dsp.getForwardedField1(1);
        Assert.assertTrue((fs == null ? 1 : 0) != 0);
        fs = dsp.getForwardedField1(2);
        Assert.assertTrue((fs == null ? 1 : 0) != 0);
        fs = dsp.getForwardedField2(0);
        Assert.assertTrue((fs.size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)fs.contains(Integer.valueOf(1)));
    }
}

