/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.common.operators.base;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import org.apache.flink.api.common.functions.FlatJoinFunction;
import org.apache.flink.api.common.functions.RuntimeContext;
import org.apache.flink.api.common.functions.util.RuntimeUDFContext;
import org.apache.flink.api.common.operators.BinaryOperatorInformation;
import org.apache.flink.api.common.operators.base.JoinOperatorBase;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.api.java.tuple.Tuple3;
import org.apache.flink.api.java.typeutils.TupleTypeInfo;
import org.apache.flink.util.Collector;
import org.junit.Assert;
import org.junit.Test;

public class JoinOperatorBaseTest
implements Serializable {
    @Test
    public void testTupleBaseJoiner() {
        FlatJoinFunction<Tuple3<String, Double, Integer>, Tuple2<Integer, String>, Tuple2<Double, String>> joiner = new FlatJoinFunction<Tuple3<String, Double, Integer>, Tuple2<Integer, String>, Tuple2<Double, String>>(){

            public void join(Tuple3<String, Double, Integer> first, Tuple2<Integer, String> second, Collector<Tuple2<Double, String>> out) {
                Tuple3<String, Double, Integer> fst = first;
                Tuple2<Integer, String> snd = second;
                Assert.assertEquals((Object)fst.f0, (Object)snd.f1);
                Assert.assertEquals((Object)fst.f2, (Object)snd.f0);
                out.collect((Object)new Tuple2(fst.f1, (Object)((Integer)snd.f0).toString()));
            }
        };
        TupleTypeInfo leftTypeInfo = TupleTypeInfo.getBasicTupleTypeInfo((Class[])new Class[]{String.class, Double.class, Integer.class});
        TupleTypeInfo rightTypeInfo = TupleTypeInfo.getBasicTupleTypeInfo((Class[])new Class[]{Integer.class, String.class});
        TupleTypeInfo outTypeInfo = TupleTypeInfo.getBasicTupleTypeInfo((Class[])new Class[]{Double.class, String.class});
        int[] leftKeys = new int[]{0, 2};
        int[] rightKeys = new int[]{1, 0};
        String taskName = "Collection based tuple joiner";
        BinaryOperatorInformation binaryOpInfo = new BinaryOperatorInformation((TypeInformation)leftTypeInfo, (TypeInformation)rightTypeInfo, (TypeInformation)outTypeInfo);
        JoinOperatorBase base = new JoinOperatorBase((FlatJoinFunction)joiner, binaryOpInfo, leftKeys, rightKeys, "Collection based tuple joiner");
        ArrayList<Tuple3> inputData1 = new ArrayList<Tuple3>(Arrays.asList(new Tuple3((Object)"foo", (Object)42.0, (Object)1), new Tuple3((Object)"bar", (Object)1.0, (Object)2), new Tuple3((Object)"bar", (Object)2.0, (Object)3), new Tuple3((Object)"foobar", (Object)3.0, (Object)4), new Tuple3((Object)"bar", (Object)3.0, (Object)3)));
        ArrayList<Tuple2> inputData2 = new ArrayList<Tuple2>(Arrays.asList(new Tuple2((Object)3, (Object)"bar"), new Tuple2((Object)4, (Object)"foobar"), new Tuple2((Object)2, (Object)"foo")));
        HashSet<Tuple2> expected = new HashSet<Tuple2>(Arrays.asList(new Tuple2((Object)2.0, (Object)"3"), new Tuple2((Object)3.0, (Object)"3"), new Tuple2((Object)3.0, (Object)"4")));
        try {
            List resultSafe = base.executeOnCollections(inputData1, inputData2, (RuntimeContext)new RuntimeUDFContext("op", 1, 0, null), true);
            List resultRegular = base.executeOnCollections(inputData1, inputData2, (RuntimeContext)new RuntimeUDFContext("op", 1, 0, null), false);
            Assert.assertEquals(expected, new HashSet(resultSafe));
            Assert.assertEquals(expected, new HashSet(resultRegular));
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }
}

