/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.common.operators;

import java.util.ArrayList;
import org.apache.flink.api.common.functions.CrossFunction;
import org.apache.flink.api.common.functions.MapFunction;
import org.apache.flink.api.common.functions.RichCrossFunction;
import org.apache.flink.api.common.functions.RichMapFunction;
import org.apache.flink.api.common.io.OutputFormat;
import org.apache.flink.api.java.CollectionEnvironment;
import org.apache.flink.api.java.DataSet;
import org.apache.flink.api.java.io.LocalCollectionOutputFormat;
import org.apache.flink.api.java.operators.CrossOperator;
import org.apache.flink.api.java.operators.DataSource;
import org.apache.flink.api.java.operators.MapOperator;
import org.apache.flink.configuration.Configuration;
import org.junit.Assert;
import org.junit.Test;

public class CollectionExecutionWithBroadcastVariableTest {
    private static final String BC_VAR_NAME = "BC";
    private final String[] TEST_DATA = new String[]{"A", "B", "C", "D"};
    private final String SUFFIX = "-suffixed";

    @Test
    public void testUnaryOp() {
        try {
            CollectionEnvironment env = new CollectionEnvironment();
            DataSource bcData = env.fromElements((Object[])new String[]{"-suffixed"});
            ArrayList result = new ArrayList();
            ((MapOperator)env.fromElements((Object[])this.TEST_DATA).map((MapFunction)new SuffixAppender()).withBroadcastSet((DataSet)bcData, BC_VAR_NAME)).output((OutputFormat)new LocalCollectionOutputFormat(result));
            env.execute();
            Assert.assertEquals((long)this.TEST_DATA.length, (long)result.size());
            for (String s : result) {
                Assert.assertTrue((s.indexOf("-suffixed") > 0 ? 1 : 0) != 0);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testBinaryOp() {
        try {
            CollectionEnvironment env = new CollectionEnvironment();
            DataSource bcData = env.fromElements((Object[])new String[]{"-suffixed"});
            DataSource inData = env.fromElements((Object[])this.TEST_DATA);
            ArrayList result = new ArrayList();
            ((CrossOperator)inData.cross((DataSet)inData).with((CrossFunction)new SuffixCross()).withBroadcastSet((DataSet)bcData, BC_VAR_NAME)).output((OutputFormat)new LocalCollectionOutputFormat(result));
            env.execute();
            Assert.assertEquals((long)(this.TEST_DATA.length * this.TEST_DATA.length), (long)result.size());
            for (String s : result) {
                Assert.assertTrue((s.indexOf("-suffixed") == 2 ? 1 : 0) != 0);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    public static final class SuffixCross
    extends RichCrossFunction<String, String, String> {
        private String suffix;

        public void open(Configuration parameters) {
            this.suffix = (String)this.getRuntimeContext().getBroadcastVariable(CollectionExecutionWithBroadcastVariableTest.BC_VAR_NAME).get(0);
        }

        public String cross(String s1, String s2) {
            return s1 + s2 + this.suffix;
        }
    }

    public static final class SuffixAppender
    extends RichMapFunction<String, String> {
        private String suffix;

        public void open(Configuration parameters) {
            this.suffix = (String)this.getRuntimeContext().getBroadcastVariable(CollectionExecutionWithBroadcastVariableTest.BC_VAR_NAME).get(0);
        }

        public String map(String value) {
            return value + this.suffix;
        }
    }
}

