/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.common.operators;

import java.io.Serializable;
import java.util.ArrayList;
import org.apache.flink.api.common.functions.FilterFunction;
import org.apache.flink.api.common.functions.FlatMapFunction;
import org.apache.flink.api.common.functions.JoinFunction;
import org.apache.flink.api.common.functions.MapFunction;
import org.apache.flink.api.common.functions.RichMapFunction;
import org.apache.flink.api.common.io.OutputFormat;
import org.apache.flink.api.java.CollectionEnvironment;
import org.apache.flink.api.java.DataSet;
import org.apache.flink.api.java.io.LocalCollectionOutputFormat;
import org.apache.flink.api.java.operators.DataSource;
import org.apache.flink.api.java.operators.DeltaIteration;
import org.apache.flink.api.java.operators.FilterOperator;
import org.apache.flink.api.java.operators.FlatMapOperator;
import org.apache.flink.api.java.operators.IterativeDataSet;
import org.apache.flink.api.java.operators.JoinOperator;
import org.apache.flink.api.java.operators.MapOperator;
import org.apache.flink.api.java.tuple.Tuple1;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.util.Collector;
import org.junit.Assert;
import org.junit.Test;

public class CollectionExecutionIterationTest
implements Serializable {
    @Test
    public void testBulkIteration() {
        try {
            CollectionEnvironment env = new CollectionEnvironment();
            IterativeDataSet iteration = env.fromElements((Object[])new Integer[]{1}).iterate(10);
            DataSet result = iteration.closeWith((DataSet)iteration.map((MapFunction)new AddSuperstepNumberMapper()));
            ArrayList collected = new ArrayList();
            result.output((OutputFormat)new LocalCollectionOutputFormat(collected));
            env.execute();
            Assert.assertEquals((long)1L, (long)collected.size());
            Assert.assertEquals((long)56L, (long)((Integer)collected.get(0)).intValue());
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testBulkIterationWithTerminationCriterion() {
        try {
            CollectionEnvironment env = new CollectionEnvironment();
            IterativeDataSet iteration = env.fromElements((Object[])new Integer[]{1}).iterate(100);
            MapOperator iterationResult = iteration.map((MapFunction)new AddSuperstepNumberMapper());
            FilterOperator terminationCriterion = iterationResult.filter((FilterFunction)new FilterFunction<Integer>(){

                public boolean filter(Integer value) {
                    return value < 50;
                }
            });
            ArrayList collected = new ArrayList();
            iteration.closeWith((DataSet)iterationResult, (DataSet)terminationCriterion).output((OutputFormat)new LocalCollectionOutputFormat(collected));
            env.execute();
            Assert.assertEquals((long)1L, (long)collected.size());
            Assert.assertEquals((long)56L, (long)((Integer)collected.get(0)).intValue());
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testDeltaIteration() {
        try {
            CollectionEnvironment env = new CollectionEnvironment();
            DataSource solInput = env.fromElements((Object[])new Tuple2[]{new Tuple2((Object)1, (Object)0), new Tuple2((Object)2, (Object)0), new Tuple2((Object)3, (Object)0), new Tuple2((Object)4, (Object)0)});
            DataSource workInput = env.fromElements((Object[])new Tuple1[]{new Tuple1((Object)1), new Tuple1((Object)2), new Tuple1((Object)3), new Tuple1((Object)4)});
            DeltaIteration iteration = solInput.iterateDelta((DataSet)workInput, 10, new int[]{0});
            JoinOperator.EquiJoin solDelta = iteration.getSolutionSet().join((DataSet)iteration.getWorkset()).where(new int[]{0}).equalTo(new int[]{0}).with((JoinFunction)new JoinFunction<Tuple2<Integer, Integer>, Tuple1<Integer>, Tuple2<Integer, Integer>>(){

                public Tuple2<Integer, Integer> join(Tuple2<Integer, Integer> first, Tuple1<Integer> second) throws Exception {
                    return new Tuple2(first.f0, (Object)((Integer)first.f1 + 1));
                }
            });
            FlatMapOperator nextWorkset = solDelta.flatMap((FlatMapFunction)new FlatMapFunction<Tuple2<Integer, Integer>, Tuple1<Integer>>(){

                public void flatMap(Tuple2<Integer, Integer> in, Collector<Tuple1<Integer>> out) throws Exception {
                    if ((Integer)in.f1 < (Integer)in.f0) {
                        out.collect((Object)new Tuple1(in.f0));
                    }
                }
            });
            ArrayList collected = new ArrayList();
            iteration.closeWith((DataSet)solDelta, (DataSet)nextWorkset).output((OutputFormat)new LocalCollectionOutputFormat(collected));
            env.execute();
            for (Tuple2 t : collected) {
                Assert.assertEquals((Object)t.f0, (Object)t.f1);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    public static class AddSuperstepNumberMapper
    extends RichMapFunction<Integer, Integer> {
        public Integer map(Integer value) {
            int superstep = this.getIterationRuntimeContext().getSuperstepNumber();
            return value + superstep;
        }
    }
}

