/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.typeutils.runtime.kryo;

import java.io.EOFException;
import java.io.IOException;
import java.io.UTFDataFormatException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.api.java.typeutils.GenericTypeInfo;
import org.apache.flink.api.java.typeutils.runtime.AvroSerializer;
import org.apache.flink.api.java.typeutils.runtime.TestDataOutputSerializer;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.core.memory.MemoryUtils;
import sun.misc.Unsafe;

public class KryoVersusAvroMinibenchmark {
    private static final long SEED = 94762389741692387L;
    private static final Random rnd = new Random(94762389741692387L);
    private static final int NUM_ELEMENTS = 100000;
    private static final int NUM_RUNS = 10;

    public static void main(String[] args) throws Exception {
        MyType[] elements = new MyType[100000];
        for (int i = 0; i < 100000; ++i) {
            elements[i] = MyType.getRandom();
        }
        MyType dummy = new MyType();
        long[] timesAvro = new long[10];
        long[] timesKryo = new long[10];
        for (int i = 0; i < 10; ++i) {
            System.out.println("----------------- Starting run " + i + " ---------------------");
            System.out.println("Avro serializer");
            TestDataOutputSerializer outView = new TestDataOutputSerializer(100000000);
            AvroSerializer serializer = new AvroSerializer(MyType.class);
            long start = System.nanoTime();
            for (int k = 0; k < 100000; ++k) {
                serializer.serialize((Object)elements[k], (DataOutputView)outView);
            }
            DataInputDeserializer inView = new DataInputDeserializer(outView.wrapAsByteBuffer());
            for (int k = 0; k < 100000; ++k) {
                serializer.deserialize((Object)dummy, (DataInputView)inView);
            }
            long elapsed = System.nanoTime() - start;
            System.out.println("Took: " + elapsed / 1000000L + " msecs");
            timesAvro[i] = elapsed;
            System.gc();
            System.out.println("Kryo serializer");
            outView = new TestDataOutputSerializer(100000000);
            ExecutionConfig conf = new ExecutionConfig();
            conf.registerKryoType(MyType.class);
            conf.enableForceKryo();
            GenericTypeInfo typeInfo = new GenericTypeInfo(MyType.class);
            TypeSerializer serializer2 = typeInfo.createSerializer(conf);
            long start2 = System.nanoTime();
            for (int k = 0; k < 100000; ++k) {
                serializer2.serialize((Object)elements[k], (DataOutputView)outView);
            }
            DataInputDeserializer inView2 = new DataInputDeserializer(outView.wrapAsByteBuffer());
            for (int k = 0; k < 100000; ++k) {
                serializer2.deserialize((Object)dummy, (DataInputView)inView2);
            }
            long elapsed2 = System.nanoTime() - start2;
            System.out.println("Took: " + elapsed2 / 1000000L + " msecs");
            timesKryo[i] = elapsed2;
        }
    }

    private static String randomString() {
        int len = rnd.nextInt(100) + 20;
        StringBuilder bld = new StringBuilder();
        for (int i = 0; i < len; ++i) {
            bld.append(rnd.nextInt(26) + 97);
        }
        return bld.toString();
    }

    public static final class DataInputDeserializer
    implements DataInputView {
        private byte[] buffer;
        private int end;
        private int position;
        private static final Unsafe UNSAFE = MemoryUtils.UNSAFE;
        private static final long BASE_OFFSET = UNSAFE.arrayBaseOffset(byte[].class);
        private static final boolean LITTLE_ENDIAN = MemoryUtils.NATIVE_BYTE_ORDER == ByteOrder.LITTLE_ENDIAN;

        public DataInputDeserializer() {
        }

        public DataInputDeserializer(byte[] buffer, int start, int len) {
            this.setBuffer(buffer, start, len);
        }

        public DataInputDeserializer(ByteBuffer buffer) {
            this.setBuffer(buffer);
        }

        public void setBuffer(ByteBuffer buffer) {
            if (buffer.hasArray()) {
                this.buffer = buffer.array();
                this.position = buffer.arrayOffset() + buffer.position();
                this.end = this.position + buffer.remaining();
            } else if (buffer.isDirect()) {
                this.buffer = new byte[buffer.remaining()];
                this.position = 0;
                this.end = this.buffer.length;
                buffer.get(this.buffer);
            } else {
                throw new IllegalArgumentException("The given buffer is neither an array-backed heap ByteBuffer, nor a direct ByteBuffer.");
            }
        }

        public void setBuffer(byte[] buffer, int start, int len) {
            if (buffer == null) {
                throw new NullPointerException();
            }
            if (start < 0 || len < 0 || start + len >= buffer.length) {
                throw new IllegalArgumentException();
            }
            this.buffer = buffer;
            this.position = start;
            this.end = start * len;
        }

        public boolean readBoolean() throws IOException {
            if (this.position < this.end) {
                return this.buffer[this.position++] != 0;
            }
            throw new EOFException();
        }

        public byte readByte() throws IOException {
            if (this.position < this.end) {
                return this.buffer[this.position++];
            }
            throw new EOFException();
        }

        public char readChar() throws IOException {
            if (this.position < this.end - 1) {
                return (char)((this.buffer[this.position++] & 0xFF) << 8 | (this.buffer[this.position++] & 0xFF) << 0);
            }
            throw new EOFException();
        }

        public double readDouble() throws IOException {
            return Double.longBitsToDouble(this.readLong());
        }

        public float readFloat() throws IOException {
            return Float.intBitsToFloat(this.readInt());
        }

        public void readFully(byte[] b) throws IOException {
            this.readFully(b, 0, b.length);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void readFully(byte[] b, int off, int len) throws IOException {
            if (len >= 0) {
                if (off > b.length - len) throw new ArrayIndexOutOfBoundsException();
                if (this.position > this.end - len) throw new EOFException();
                System.arraycopy(this.buffer, this.position, b, off, len);
                this.position += len;
                return;
            } else {
                if (len >= 0) return;
                throw new IllegalArgumentException("Length may not be negative.");
            }
        }

        public int readInt() throws IOException {
            if (this.position >= 0 && this.position < this.end - 3) {
                int value = UNSAFE.getInt(this.buffer, BASE_OFFSET + (long)this.position);
                if (LITTLE_ENDIAN) {
                    value = Integer.reverseBytes(value);
                }
                this.position += 4;
                return value;
            }
            throw new EOFException();
        }

        public String readLine() throws IOException {
            if (this.position < this.end) {
                StringBuilder bld = new StringBuilder();
                char curr = (char)this.readUnsignedByte();
                while (this.position < this.end && curr != '\n') {
                    bld.append(curr);
                    curr = (char)this.readUnsignedByte();
                }
                int len = bld.length();
                if (len > 0 && bld.charAt(len - 1) == '\r') {
                    bld.setLength(len - 1);
                }
                String s = bld.toString();
                bld.setLength(0);
                return s;
            }
            return null;
        }

        public long readLong() throws IOException {
            if (this.position >= 0 && this.position < this.end - 7) {
                long value = UNSAFE.getLong(this.buffer, BASE_OFFSET + (long)this.position);
                if (LITTLE_ENDIAN) {
                    value = Long.reverseBytes(value);
                }
                this.position += 8;
                return value;
            }
            throw new EOFException();
        }

        public short readShort() throws IOException {
            if (this.position >= 0 && this.position < this.end - 1) {
                return (short)((this.buffer[this.position++] & 0xFF) << 8 | (this.buffer[this.position++] & 0xFF) << 0);
            }
            throw new EOFException();
        }

        public String readUTF() throws IOException {
            int c;
            int count;
            int utflen = this.readUnsignedShort();
            byte[] bytearr = new byte[utflen];
            char[] chararr = new char[utflen];
            int chararr_count = 0;
            this.readFully(bytearr, 0, utflen);
            for (count = 0; count < utflen && (c = bytearr[count] & 0xFF) <= 127; ++count) {
                chararr[chararr_count++] = (char)c;
            }
            block6: while (count < utflen) {
                c = bytearr[count] & 0xFF;
                switch (c >> 4) {
                    case 0: 
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: {
                        ++count;
                        chararr[chararr_count++] = (char)c;
                        continue block6;
                    }
                    case 12: 
                    case 13: {
                        if ((count += 2) > utflen) {
                            throw new UTFDataFormatException("malformed input: partial character at end");
                        }
                        byte char2 = bytearr[count - 1];
                        if ((char2 & 0xC0) != 128) {
                            throw new UTFDataFormatException("malformed input around byte " + count);
                        }
                        chararr[chararr_count++] = (char)((c & 0x1F) << 6 | char2 & 0x3F);
                        continue block6;
                    }
                    case 14: {
                        if ((count += 3) > utflen) {
                            throw new UTFDataFormatException("malformed input: partial character at end");
                        }
                        byte char2 = bytearr[count - 2];
                        byte char3 = bytearr[count - 1];
                        if ((char2 & 0xC0) != 128 || (char3 & 0xC0) != 128) {
                            throw new UTFDataFormatException("malformed input around byte " + (count - 1));
                        }
                        chararr[chararr_count++] = (char)((c & 0xF) << 12 | (char2 & 0x3F) << 6 | (char3 & 0x3F) << 0);
                        continue block6;
                    }
                }
                throw new UTFDataFormatException("malformed input around byte " + count);
            }
            return new String(chararr, 0, chararr_count);
        }

        public int readUnsignedByte() throws IOException {
            if (this.position < this.end) {
                return this.buffer[this.position++] & 0xFF;
            }
            throw new EOFException();
        }

        public int readUnsignedShort() throws IOException {
            if (this.position < this.end - 1) {
                return (this.buffer[this.position++] & 0xFF) << 8 | (this.buffer[this.position++] & 0xFF) << 0;
            }
            throw new EOFException();
        }

        public int skipBytes(int n) throws IOException {
            if (this.position <= this.end - n) {
                this.position += n;
                return n;
            }
            n = this.end - this.position;
            this.position = this.end;
            return n;
        }

        public void skipBytesToRead(int numBytes) throws IOException {
            int skippedBytes = this.skipBytes(numBytes);
            if (skippedBytes < numBytes) {
                throw new EOFException("Could not skip " + numBytes + " bytes.");
            }
        }

        public int read(byte[] b, int off, int len) throws IOException {
            if (b == null) {
                throw new NullPointerException("Byte array b cannot be null.");
            }
            if (off < 0) {
                throw new IndexOutOfBoundsException("Offset cannot be negative.");
            }
            if (len < 0) {
                throw new IndexOutOfBoundsException("Length cannot be negative.");
            }
            if (b.length - off < len) {
                throw new IndexOutOfBoundsException("Byte array does not provide enough space to store requested data.");
            }
            if (this.position >= this.end) {
                return -1;
            }
            int toRead = Math.min(this.end - this.position, len);
            System.arraycopy(this.buffer, this.position, b, off, toRead);
            this.position += toRead;
            return toRead;
        }

        public int read(byte[] b) throws IOException {
            return this.read(b, 0, b.length);
        }
    }

    public static class MyType {
        private String theString;
        private List<Integer> theList;

        public MyType() {
            this.theString = "";
            this.theList = new ArrayList<Integer>();
        }

        public MyType(String theString, Tuple2<Long, Double> theTuple, List<Integer> theList) {
            this.theString = theString;
            this.theList = theList;
        }

        public String getTheString() {
            return this.theString;
        }

        public void setTheString(String theString) {
            this.theString = theString;
        }

        public List<Integer> getTheList() {
            return this.theList;
        }

        public void setTheList(List<Integer> theList) {
            this.theList = theList;
        }

        public static MyType getRandom() {
            int numListElements = rnd.nextInt(20);
            ArrayList<Integer> list = new ArrayList<Integer>(numListElements);
            for (int i = 0; i < numListElements; ++i) {
                list.add(rnd.nextInt());
            }
            return new MyType(KryoVersusAvroMinibenchmark.randomString(), (Tuple2<Long, Double>)new Tuple2((Object)rnd.nextLong(), (Object)rnd.nextDouble()), list);
        }
    }
}

