/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.typeutils.runtime;

import java.util.ArrayList;
import java.util.List;
import org.apache.avro.reflect.Nullable;
import org.apache.flink.api.common.typeutils.SerializerTestInstance;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.java.typeutils.runtime.AvroSerializer;
import org.junit.Assert;
import org.junit.Test;

public class AvroSerializerEmptyArrayTest {
    @Test
    public void testBookSerialization() {
        try {
            Book b = new Book(123L, "This is a test book", 26382648L);
            AvroSerializer serializer = new AvroSerializer(Book.class);
            SerializerTestInstance test = new SerializerTestInstance((TypeSerializer)serializer, Book.class, -1, (Object[])new Book[]{b});
            test.testAll();
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testSerialization() {
        try {
            ArrayList<String> titles = new ArrayList<String>();
            ArrayList<Book> books = new ArrayList<Book>();
            books.add(new Book(123L, "This is a test book", 1L));
            books.add(new Book(24234234L, "This is a test book", 1L));
            books.add(new Book(1234324L, "This is a test book", 3L));
            BookAuthor a = new BookAuthor(1L, titles, "Test Author");
            a.books = books;
            a.bookType = BookAuthor.BookType.journal;
            AvroSerializer serializer = new AvroSerializer(BookAuthor.class);
            SerializerTestInstance test = new SerializerTestInstance((TypeSerializer)serializer, BookAuthor.class, -1, (Object[])new BookAuthor[]{a});
            test.testAll();
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    public static class BookAuthor {
        long authorId;
        @Nullable
        List<String> bookTitles;
        @Nullable
        List<Book> books;
        String authorName;
        BookType bookType;

        public BookAuthor() {
        }

        public BookAuthor(long authorId, List<String> bookTitles, String authorName) {
            this.authorId = authorId;
            this.bookTitles = bookTitles;
            this.authorName = authorName;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (int)(this.authorId ^ this.authorId >>> 32);
            result = 31 * result + (this.authorName == null ? 0 : this.authorName.hashCode());
            result = 31 * result + (this.bookTitles == null ? 0 : this.bookTitles.hashCode());
            result = 31 * result + (this.bookType == null ? 0 : this.bookType.hashCode());
            result = 31 * result + (this.books == null ? 0 : this.books.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            BookAuthor other = (BookAuthor)obj;
            if (this.authorId != other.authorId) {
                return false;
            }
            if (this.authorName == null ? other.authorName != null : !this.authorName.equals(other.authorName)) {
                return false;
            }
            if (this.bookTitles == null ? other.bookTitles != null : !this.bookTitles.equals(other.bookTitles)) {
                return false;
            }
            if (this.bookType != other.bookType) {
                return false;
            }
            return !(this.books == null ? other.books != null : !this.books.equals(other.books));
        }

        static enum BookType {
            book,
            article,
            journal;

        }
    }

    public static class Book {
        long bookId;
        @Nullable
        String title;
        long authorId;

        public Book() {
        }

        public Book(long bookId, String title, long authorId) {
            this.bookId = bookId;
            this.title = title;
            this.authorId = authorId;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (int)(this.authorId ^ this.authorId >>> 32);
            result = 31 * result + (int)(this.bookId ^ this.bookId >>> 32);
            result = 31 * result + (this.title == null ? 0 : this.title.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Book other = (Book)obj;
            if (this.authorId != other.authorId) {
                return false;
            }
            if (this.bookId != other.bookId) {
                return false;
            }
            return !(this.title == null ? other.title != null : !this.title.equals(other.title));
        }
    }
}

