/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.typeutils;

import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.typeinfo.BasicTypeInfo;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.CompositeType;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.java.tuple.Tuple1;
import org.apache.flink.api.java.typeutils.TupleTypeInfo;
import org.apache.flink.api.java.typeutils.TupleTypeInfoBase;
import org.apache.flink.util.TestLogger;
import org.junit.Assert;
import org.junit.Test;

public class TupleTypeInfoTest
extends TestLogger {
    @Test
    public void testTupleTypeInfoSymmetricEqualityRelation() {
        boolean anonymousVsTuple;
        TupleTypeInfo tupleTypeInfo = new TupleTypeInfo(new TypeInformation[]{BasicTypeInfo.INT_TYPE_INFO});
        TupleTypeInfoBase<Tuple1> anonymousTupleTypeInfo = new TupleTypeInfoBase<Tuple1>(Tuple1.class, new TypeInformation[]{BasicTypeInfo.INT_TYPE_INFO}){
            private static final long serialVersionUID = -7985593598027660836L;

            public TypeSerializer<Tuple1> createSerializer(ExecutionConfig config) {
                return null;
            }

            protected CompositeType.TypeComparatorBuilder<Tuple1> createTypeComparatorBuilder() {
                return null;
            }

            public String[] getFieldNames() {
                return new String[0];
            }

            public int getFieldIndex(String fieldName) {
                return 0;
            }
        };
        boolean tupleVsAnonymous = tupleTypeInfo.equals((Object)anonymousTupleTypeInfo);
        Assert.assertTrue((String)"Equality relation should be symmetric", (tupleVsAnonymous == (anonymousVsTuple = anonymousTupleTypeInfo.equals((Object)tupleTypeInfo)) ? 1 : 0) != 0);
    }

    @Test
    public void testTupleTypeInfoEquality() {
        TupleTypeInfo tupleTypeInfo1 = new TupleTypeInfo(new TypeInformation[]{BasicTypeInfo.INT_TYPE_INFO, BasicTypeInfo.STRING_TYPE_INFO});
        TupleTypeInfo tupleTypeInfo2 = new TupleTypeInfo(new TypeInformation[]{BasicTypeInfo.INT_TYPE_INFO, BasicTypeInfo.STRING_TYPE_INFO});
        Assert.assertEquals((Object)tupleTypeInfo1, (Object)tupleTypeInfo2);
        Assert.assertEquals((long)tupleTypeInfo1.hashCode(), (long)tupleTypeInfo2.hashCode());
    }

    @Test
    public void testTupleTypeInfoInequality() {
        TupleTypeInfo tupleTypeInfo1 = new TupleTypeInfo(new TypeInformation[]{BasicTypeInfo.INT_TYPE_INFO, BasicTypeInfo.STRING_TYPE_INFO});
        TupleTypeInfo tupleTypeInfo2 = new TupleTypeInfo(new TypeInformation[]{BasicTypeInfo.INT_TYPE_INFO, BasicTypeInfo.BOOLEAN_TYPE_INFO});
        Assert.assertNotEquals((Object)tupleTypeInfo1, (Object)tupleTypeInfo2);
    }
}

