/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.type.extractor;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.flink.api.common.functions.CoGroupFunction;
import org.apache.flink.api.common.functions.CrossFunction;
import org.apache.flink.api.common.functions.FlatJoinFunction;
import org.apache.flink.api.common.functions.FlatMapFunction;
import org.apache.flink.api.common.functions.GroupReduceFunction;
import org.apache.flink.api.common.functions.InvalidTypesException;
import org.apache.flink.api.common.functions.MapFunction;
import org.apache.flink.api.common.functions.RichCoGroupFunction;
import org.apache.flink.api.common.functions.RichCrossFunction;
import org.apache.flink.api.common.functions.RichFlatJoinFunction;
import org.apache.flink.api.common.functions.RichFlatMapFunction;
import org.apache.flink.api.common.functions.RichGroupReduceFunction;
import org.apache.flink.api.common.functions.RichMapFunction;
import org.apache.flink.api.common.functions.RuntimeContext;
import org.apache.flink.api.common.typeinfo.BasicArrayTypeInfo;
import org.apache.flink.api.common.typeinfo.BasicTypeInfo;
import org.apache.flink.api.common.typeinfo.PrimitiveArrayTypeInfo;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.CompositeType;
import org.apache.flink.api.java.ExecutionEnvironment;
import org.apache.flink.api.java.functions.KeySelector;
import org.apache.flink.api.java.tuple.Tuple;
import org.apache.flink.api.java.tuple.Tuple0;
import org.apache.flink.api.java.tuple.Tuple1;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.api.java.tuple.Tuple3;
import org.apache.flink.api.java.tuple.Tuple9;
import org.apache.flink.api.java.typeutils.EnumTypeInfo;
import org.apache.flink.api.java.typeutils.GenericTypeInfo;
import org.apache.flink.api.java.typeutils.MissingTypeInfo;
import org.apache.flink.api.java.typeutils.ObjectArrayTypeInfo;
import org.apache.flink.api.java.typeutils.PojoTypeInfo;
import org.apache.flink.api.java.typeutils.ResultTypeQueryable;
import org.apache.flink.api.java.typeutils.TupleTypeInfo;
import org.apache.flink.api.java.typeutils.TypeExtractor;
import org.apache.flink.api.java.typeutils.TypeInfoParser;
import org.apache.flink.api.java.typeutils.ValueTypeInfo;
import org.apache.flink.api.java.typeutils.WritableTypeInfo;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.types.DoubleValue;
import org.apache.flink.types.IntValue;
import org.apache.flink.types.StringValue;
import org.apache.flink.types.Value;
import org.apache.flink.util.Collector;
import org.apache.hadoop.io.Writable;
import org.junit.Assert;
import org.junit.Test;

public class TypeExtractorTest {
    @Test
    public void testBasicType() {
        RichGroupReduceFunction<Boolean, Boolean> function = new RichGroupReduceFunction<Boolean, Boolean>(){
            private static final long serialVersionUID = 1L;

            public void reduce(Iterable<Boolean> values, Collector<Boolean> out) throws Exception {
            }
        };
        TypeInformation ti = TypeExtractor.getGroupReduceReturnTypes((GroupReduceFunction)function, (TypeInformation)TypeInfoParser.parse((String)"Boolean"));
        Assert.assertTrue((boolean)ti.isBasicType());
        Assert.assertEquals((Object)BasicTypeInfo.BOOLEAN_TYPE_INFO, (Object)ti);
        Assert.assertEquals(Boolean.class, (Object)ti.getTypeClass());
        Assert.assertTrue((boolean)TypeExtractor.getForClass(Boolean.class).isBasicType());
        Assert.assertEquals((Object)ti, (Object)TypeExtractor.getForClass(Boolean.class));
        Assert.assertEquals((Object)BasicTypeInfo.BOOLEAN_TYPE_INFO, (Object)TypeExtractor.getForObject((Object)true));
    }

    @Test
    public void testWritableType() {
        RichMapFunction<MyWritable, MyWritable> function = new RichMapFunction<MyWritable, MyWritable>(){
            private static final long serialVersionUID = 1L;

            public MyWritable map(MyWritable value) throws Exception {
                return null;
            }
        };
        TypeInformation ti = TypeExtractor.getMapReturnTypes((MapFunction)function, (TypeInformation)new WritableTypeInfo(MyWritable.class));
        Assert.assertTrue((boolean)(ti instanceof WritableTypeInfo));
        Assert.assertEquals(MyWritable.class, (Object)((WritableTypeInfo)ti).getTypeClass());
    }

    @Test
    public void testTupleWithBasicTypes() throws Exception {
        RichMapFunction<Tuple9<Integer, Long, Double, Float, Boolean, String, Character, Short, Byte>, Tuple9<Integer, Long, Double, Float, Boolean, String, Character, Short, Byte>> function = new RichMapFunction<Tuple9<Integer, Long, Double, Float, Boolean, String, Character, Short, Byte>, Tuple9<Integer, Long, Double, Float, Boolean, String, Character, Short, Byte>>(){
            private static final long serialVersionUID = 1L;

            public Tuple9<Integer, Long, Double, Float, Boolean, String, Character, Short, Byte> map(Tuple9<Integer, Long, Double, Float, Boolean, String, Character, Short, Byte> value) throws Exception {
                return null;
            }
        };
        TypeInformation ti = TypeExtractor.getMapReturnTypes((MapFunction)function, (TypeInformation)TypeInfoParser.parse((String)"Tuple9<Integer, Long, Double, Float, Boolean, String, Character, Short, Byte>"));
        Assert.assertTrue((boolean)ti.isTupleType());
        Assert.assertEquals((long)9L, (long)ti.getArity());
        Assert.assertTrue((boolean)(ti instanceof TupleTypeInfo));
        ArrayList ffd = new ArrayList();
        ((TupleTypeInfo)ti).getFlatFields("f3", 0, ffd);
        Assert.assertTrue((ffd.size() == 1 ? 1 : 0) != 0);
        Assert.assertEquals((long)3L, (long)((CompositeType.FlatFieldDescriptor)ffd.get(0)).getPosition());
        TupleTypeInfo tti = (TupleTypeInfo)ti;
        Assert.assertEquals(Tuple9.class, (Object)tti.getTypeClass());
        for (int i = 0; i < 9; ++i) {
            Assert.assertTrue((boolean)(tti.getTypeAt(i) instanceof BasicTypeInfo));
        }
        Assert.assertEquals((Object)BasicTypeInfo.INT_TYPE_INFO, (Object)tti.getTypeAt(0));
        Assert.assertEquals((Object)BasicTypeInfo.LONG_TYPE_INFO, (Object)tti.getTypeAt(1));
        Assert.assertEquals((Object)BasicTypeInfo.DOUBLE_TYPE_INFO, (Object)tti.getTypeAt(2));
        Assert.assertEquals((Object)BasicTypeInfo.FLOAT_TYPE_INFO, (Object)tti.getTypeAt(3));
        Assert.assertEquals((Object)BasicTypeInfo.BOOLEAN_TYPE_INFO, (Object)tti.getTypeAt(4));
        Assert.assertEquals((Object)BasicTypeInfo.STRING_TYPE_INFO, (Object)tti.getTypeAt(5));
        Assert.assertEquals((Object)BasicTypeInfo.CHAR_TYPE_INFO, (Object)tti.getTypeAt(6));
        Assert.assertEquals((Object)BasicTypeInfo.SHORT_TYPE_INFO, (Object)tti.getTypeAt(7));
        Assert.assertEquals((Object)BasicTypeInfo.BYTE_TYPE_INFO, (Object)tti.getTypeAt(8));
        Tuple9 t = new Tuple9((Object)1, (Object)1L, (Object)1.0, (Object)Float.valueOf(1.0f), (Object)false, (Object)"Hello World", (Object)Character.valueOf('w'), (Object)1, (Object)1);
        Assert.assertTrue((boolean)(TypeExtractor.getForObject((Object)t) instanceof TupleTypeInfo));
        TupleTypeInfo tti2 = (TupleTypeInfo)TypeExtractor.getForObject((Object)t);
        Assert.assertEquals((Object)BasicTypeInfo.INT_TYPE_INFO, (Object)tti2.getTypeAt(0));
        Assert.assertEquals((Object)BasicTypeInfo.LONG_TYPE_INFO, (Object)tti2.getTypeAt(1));
        Assert.assertEquals((Object)BasicTypeInfo.DOUBLE_TYPE_INFO, (Object)tti2.getTypeAt(2));
        Assert.assertEquals((Object)BasicTypeInfo.FLOAT_TYPE_INFO, (Object)tti2.getTypeAt(3));
        Assert.assertEquals((Object)BasicTypeInfo.BOOLEAN_TYPE_INFO, (Object)tti2.getTypeAt(4));
        Assert.assertEquals((Object)BasicTypeInfo.STRING_TYPE_INFO, (Object)tti2.getTypeAt(5));
        Assert.assertEquals((Object)BasicTypeInfo.CHAR_TYPE_INFO, (Object)tti2.getTypeAt(6));
        Assert.assertEquals((Object)BasicTypeInfo.SHORT_TYPE_INFO, (Object)tti2.getTypeAt(7));
        Assert.assertEquals((Object)BasicTypeInfo.BYTE_TYPE_INFO, (Object)tti2.getTypeAt(8));
        try {
            TypeExtractor.getForClass(Tuple9.class);
            Assert.fail((String)"Exception expected here");
        }
        catch (InvalidTypesException invalidTypesException) {
            // empty catch block
        }
    }

    @Test
    public void testTupleWithTuples() {
        RichFlatMapFunction<Tuple3<Tuple1<String>, Tuple1<Integer>, Tuple2<Long, Long>>, Tuple3<Tuple1<String>, Tuple1<Integer>, Tuple2<Long, Long>>> function = new RichFlatMapFunction<Tuple3<Tuple1<String>, Tuple1<Integer>, Tuple2<Long, Long>>, Tuple3<Tuple1<String>, Tuple1<Integer>, Tuple2<Long, Long>>>(){
            private static final long serialVersionUID = 1L;

            public void flatMap(Tuple3<Tuple1<String>, Tuple1<Integer>, Tuple2<Long, Long>> value, Collector<Tuple3<Tuple1<String>, Tuple1<Integer>, Tuple2<Long, Long>>> out) throws Exception {
            }
        };
        TypeInformation ti = TypeExtractor.getFlatMapReturnTypes((FlatMapFunction)function, (TypeInformation)TypeInfoParser.parse((String)"Tuple3<Tuple1<String>, Tuple1<Integer>, Tuple2<Long, Long>>"));
        Assert.assertTrue((boolean)ti.isTupleType());
        Assert.assertEquals((long)3L, (long)ti.getArity());
        Assert.assertTrue((boolean)(ti instanceof TupleTypeInfo));
        ArrayList ffd = new ArrayList();
        ((TupleTypeInfo)ti).getFlatFields("f0.f0", 0, ffd);
        Assert.assertEquals((long)0L, (long)((CompositeType.FlatFieldDescriptor)ffd.get(0)).getPosition());
        ffd.clear();
        ((TupleTypeInfo)ti).getFlatFields("f0.f0", 0, ffd);
        Assert.assertTrue((boolean)(((CompositeType.FlatFieldDescriptor)ffd.get(0)).getType() instanceof BasicTypeInfo));
        Assert.assertTrue((boolean)((CompositeType.FlatFieldDescriptor)ffd.get(0)).getType().getTypeClass().equals(String.class));
        ffd.clear();
        ((TupleTypeInfo)ti).getFlatFields("f1.f0", 0, ffd);
        Assert.assertEquals((long)1L, (long)((CompositeType.FlatFieldDescriptor)ffd.get(0)).getPosition());
        ffd.clear();
        TupleTypeInfo tti = (TupleTypeInfo)ti;
        Assert.assertEquals(Tuple3.class, (Object)tti.getTypeClass());
        Assert.assertTrue((boolean)tti.getTypeAt(0).isTupleType());
        Assert.assertTrue((boolean)tti.getTypeAt(1).isTupleType());
        Assert.assertTrue((boolean)tti.getTypeAt(2).isTupleType());
        Assert.assertEquals(Tuple1.class, (Object)tti.getTypeAt(0).getTypeClass());
        Assert.assertEquals(Tuple1.class, (Object)tti.getTypeAt(1).getTypeClass());
        Assert.assertEquals(Tuple2.class, (Object)tti.getTypeAt(2).getTypeClass());
        Assert.assertEquals((long)1L, (long)tti.getTypeAt(0).getArity());
        Assert.assertEquals((long)1L, (long)tti.getTypeAt(1).getArity());
        Assert.assertEquals((long)2L, (long)tti.getTypeAt(2).getArity());
        Assert.assertEquals((Object)BasicTypeInfo.STRING_TYPE_INFO, (Object)((TupleTypeInfo)tti.getTypeAt(0)).getTypeAt(0));
        Assert.assertEquals((Object)BasicTypeInfo.INT_TYPE_INFO, (Object)((TupleTypeInfo)tti.getTypeAt(1)).getTypeAt(0));
        Assert.assertEquals((Object)BasicTypeInfo.LONG_TYPE_INFO, (Object)((TupleTypeInfo)tti.getTypeAt(2)).getTypeAt(0));
        Assert.assertEquals((Object)BasicTypeInfo.LONG_TYPE_INFO, (Object)((TupleTypeInfo)tti.getTypeAt(2)).getTypeAt(1));
        Tuple3 t = new Tuple3((Object)new Tuple1((Object)"hello"), (Object)new Tuple1((Object)1), (Object)new Tuple2((Object)2L, (Object)3L));
        Assert.assertTrue((boolean)(TypeExtractor.getForObject((Object)t) instanceof TupleTypeInfo));
        TupleTypeInfo tti2 = (TupleTypeInfo)TypeExtractor.getForObject((Object)t);
        Assert.assertEquals((long)1L, (long)tti2.getTypeAt(0).getArity());
        Assert.assertEquals((long)1L, (long)tti2.getTypeAt(1).getArity());
        Assert.assertEquals((long)2L, (long)tti2.getTypeAt(2).getArity());
        Assert.assertEquals((Object)BasicTypeInfo.STRING_TYPE_INFO, (Object)((TupleTypeInfo)tti2.getTypeAt(0)).getTypeAt(0));
        Assert.assertEquals((Object)BasicTypeInfo.INT_TYPE_INFO, (Object)((TupleTypeInfo)tti2.getTypeAt(1)).getTypeAt(0));
        Assert.assertEquals((Object)BasicTypeInfo.LONG_TYPE_INFO, (Object)((TupleTypeInfo)tti2.getTypeAt(2)).getTypeAt(0));
        Assert.assertEquals((Object)BasicTypeInfo.LONG_TYPE_INFO, (Object)((TupleTypeInfo)tti2.getTypeAt(2)).getTypeAt(1));
    }

    @Test
    public void testTuple0() {
        RichFlatMapFunction<Tuple0, Tuple0> function = new RichFlatMapFunction<Tuple0, Tuple0>(){
            private static final long serialVersionUID = 1L;

            public void flatMap(Tuple0 value, Collector<Tuple0> out) throws Exception {
            }
        };
        TypeInformation ti = TypeExtractor.getFlatMapReturnTypes((FlatMapFunction)function, (TypeInformation)TypeInfoParser.parse((String)"Tuple0"));
        Assert.assertTrue((boolean)ti.isTupleType());
        Assert.assertEquals((long)0L, (long)ti.getArity());
        Assert.assertTrue((boolean)(ti instanceof TupleTypeInfo));
    }

    @Test
    public void testSubclassOfTuple() {
        RichFlatJoinFunction<CustomTuple, String, CustomTuple> function = new RichFlatJoinFunction<CustomTuple, String, CustomTuple>(){
            private static final long serialVersionUID = 1L;

            public void join(CustomTuple first, String second, Collector<CustomTuple> out) throws Exception {
                out.collect(null);
            }
        };
        TypeInformation ti = TypeExtractor.getFlatJoinReturnTypes((FlatJoinFunction)function, (TypeInformation)TypeInfoParser.parse((String)"Tuple2<String, Integer>"), (TypeInformation)TypeInfoParser.parse((String)"String"));
        Assert.assertTrue((boolean)ti.isTupleType());
        Assert.assertEquals((long)2L, (long)ti.getArity());
        Assert.assertEquals((Object)BasicTypeInfo.STRING_TYPE_INFO, (Object)((TupleTypeInfo)ti).getTypeAt(0));
        Assert.assertEquals((Object)BasicTypeInfo.INT_TYPE_INFO, (Object)((TupleTypeInfo)ti).getTypeAt(1));
        Assert.assertEquals(CustomTuple.class, (Object)((TupleTypeInfo)ti).getTypeClass());
        CustomTuple t = new CustomTuple("hello", 1);
        TypeInformation ti2 = TypeExtractor.getForObject((Object)((Object)t));
        Assert.assertTrue((boolean)ti2.isTupleType());
        Assert.assertEquals((long)2L, (long)ti2.getArity());
        Assert.assertEquals((Object)BasicTypeInfo.STRING_TYPE_INFO, (Object)((TupleTypeInfo)ti2).getTypeAt(0));
        Assert.assertEquals((Object)BasicTypeInfo.INT_TYPE_INFO, (Object)((TupleTypeInfo)ti2).getTypeAt(1));
        Assert.assertEquals(CustomTuple.class, (Object)((TupleTypeInfo)ti2).getTypeClass());
    }

    @Test
    public void testPojo() {
        RichCrossFunction<CustomType, Integer, CustomType> function = new RichCrossFunction<CustomType, Integer, CustomType>(){
            private static final long serialVersionUID = 1L;

            public CustomType cross(CustomType first, Integer second) throws Exception {
                return null;
            }
        };
        TypeInformation ti = TypeExtractor.getCrossReturnTypes((CrossFunction)function, (TypeInformation)TypeInfoParser.parse((String)"org.apache.flink.api.java.type.extractor.TypeExtractorTest$CustomType"), (TypeInformation)TypeInfoParser.parse((String)"Integer"));
        Assert.assertFalse((boolean)ti.isBasicType());
        Assert.assertFalse((boolean)ti.isTupleType());
        Assert.assertTrue((boolean)(ti instanceof PojoTypeInfo));
        Assert.assertEquals((Object)ti.getTypeClass(), CustomType.class);
        Assert.assertTrue((boolean)(TypeExtractor.getForClass(CustomType.class) instanceof PojoTypeInfo));
        Assert.assertEquals((Object)TypeExtractor.getForClass(CustomType.class).getTypeClass(), (Object)ti.getTypeClass());
        CustomType t = new CustomType("World", 1);
        TypeInformation ti2 = TypeExtractor.getForObject((Object)t);
        Assert.assertFalse((boolean)ti2.isBasicType());
        Assert.assertFalse((boolean)ti2.isTupleType());
        Assert.assertTrue((boolean)(ti2 instanceof PojoTypeInfo));
        Assert.assertEquals((Object)ti2.getTypeClass(), CustomType.class);
        Assert.assertFalse((boolean)(TypeExtractor.getForClass(PojoWithNonPublicDefaultCtor.class) instanceof PojoTypeInfo));
    }

    @Test
    public void testTupleWithPojo() {
        RichMapFunction<Tuple2<Long, CustomType>, Tuple2<Long, CustomType>> function = new RichMapFunction<Tuple2<Long, CustomType>, Tuple2<Long, CustomType>>(){
            private static final long serialVersionUID = 1L;

            public Tuple2<Long, CustomType> map(Tuple2<Long, CustomType> value) throws Exception {
                return null;
            }
        };
        TypeInformation ti = TypeExtractor.getMapReturnTypes((MapFunction)function, (TypeInformation)TypeInfoParser.parse((String)"Tuple2<Long,org.apache.flink.api.java.type.extractor.TypeExtractorTest$CustomType>"));
        Assert.assertTrue((boolean)ti.isTupleType());
        Assert.assertEquals((long)2L, (long)ti.getArity());
        TupleTypeInfo tti = (TupleTypeInfo)ti;
        Assert.assertEquals(Tuple2.class, (Object)tti.getTypeClass());
        ArrayList ffd = new ArrayList();
        tti.getFlatFields("f0", 0, ffd);
        Assert.assertEquals((long)1L, (long)ffd.size());
        Assert.assertEquals((long)0L, (long)((CompositeType.FlatFieldDescriptor)ffd.get(0)).getPosition());
        Assert.assertTrue((boolean)((CompositeType.FlatFieldDescriptor)ffd.get(0)).getType().getTypeClass().equals(Long.class));
        ffd.clear();
        tti.getFlatFields("f1.myField1", 0, ffd);
        Assert.assertEquals((long)1L, (long)((CompositeType.FlatFieldDescriptor)ffd.get(0)).getPosition());
        Assert.assertTrue((boolean)((CompositeType.FlatFieldDescriptor)ffd.get(0)).getType().getTypeClass().equals(String.class));
        ffd.clear();
        tti.getFlatFields("f1.myField2", 0, ffd);
        Assert.assertEquals((long)2L, (long)((CompositeType.FlatFieldDescriptor)ffd.get(0)).getPosition());
        Assert.assertTrue((boolean)((CompositeType.FlatFieldDescriptor)ffd.get(0)).getType().getTypeClass().equals(Integer.class));
        Assert.assertEquals(Long.class, (Object)tti.getTypeAt(0).getTypeClass());
        Assert.assertTrue((boolean)(tti.getTypeAt(1) instanceof PojoTypeInfo));
        Assert.assertEquals(CustomType.class, (Object)tti.getTypeAt(1).getTypeClass());
        Tuple2 t = new Tuple2((Object)1L, (Object)new CustomType("Hello", 1));
        TypeInformation ti2 = TypeExtractor.getForObject((Object)t);
        Assert.assertTrue((boolean)ti2.isTupleType());
        Assert.assertEquals((long)2L, (long)ti2.getArity());
        TupleTypeInfo tti2 = (TupleTypeInfo)ti2;
        Assert.assertEquals(Tuple2.class, (Object)tti2.getTypeClass());
        Assert.assertEquals(Long.class, (Object)tti2.getTypeAt(0).getTypeClass());
        Assert.assertTrue((boolean)(tti2.getTypeAt(1) instanceof PojoTypeInfo));
        Assert.assertEquals(CustomType.class, (Object)tti2.getTypeAt(1).getTypeClass());
    }

    @Test
    public void testValue() {
        KeySelector<StringValue, StringValue> function = new KeySelector<StringValue, StringValue>(){
            private static final long serialVersionUID = 1L;

            public StringValue getKey(StringValue value) {
                return null;
            }
        };
        TypeInformation ti = TypeExtractor.getKeySelectorTypes((KeySelector)function, (TypeInformation)TypeInfoParser.parse((String)"StringValue"));
        Assert.assertFalse((boolean)ti.isBasicType());
        Assert.assertFalse((boolean)ti.isTupleType());
        Assert.assertTrue((boolean)(ti instanceof ValueTypeInfo));
        Assert.assertEquals((Object)ti.getTypeClass(), StringValue.class);
        Assert.assertTrue((boolean)(TypeExtractor.getForClass(StringValue.class) instanceof ValueTypeInfo));
        Assert.assertEquals((Object)TypeExtractor.getForClass(StringValue.class).getTypeClass(), (Object)ti.getTypeClass());
        StringValue v = new StringValue((CharSequence)"Hello");
        Assert.assertTrue((boolean)(TypeExtractor.getForObject((Object)v) instanceof ValueTypeInfo));
        Assert.assertEquals((Object)TypeExtractor.getForObject((Object)v).getTypeClass(), (Object)ti.getTypeClass());
    }

    @Test
    public void testTupleOfValues() {
        RichMapFunction<Tuple2<StringValue, IntValue>, Tuple2<StringValue, IntValue>> function = new RichMapFunction<Tuple2<StringValue, IntValue>, Tuple2<StringValue, IntValue>>(){
            private static final long serialVersionUID = 1L;

            public Tuple2<StringValue, IntValue> map(Tuple2<StringValue, IntValue> value) throws Exception {
                return null;
            }
        };
        TypeInformation ti = TypeExtractor.getMapReturnTypes((MapFunction)function, (TypeInformation)TypeInfoParser.parse((String)"Tuple2<StringValue, IntValue>"));
        Assert.assertFalse((boolean)ti.isBasicType());
        Assert.assertTrue((boolean)ti.isTupleType());
        Assert.assertEquals(StringValue.class, (Object)((TupleTypeInfo)ti).getTypeAt(0).getTypeClass());
        Assert.assertEquals(IntValue.class, (Object)((TupleTypeInfo)ti).getTypeAt(1).getTypeClass());
        Tuple2 t = new Tuple2((Object)new StringValue((CharSequence)"x"), (Object)new IntValue(1));
        TypeInformation ti2 = TypeExtractor.getForObject((Object)t);
        Assert.assertFalse((boolean)ti2.isBasicType());
        Assert.assertTrue((boolean)ti2.isTupleType());
        Assert.assertEquals((Object)((TupleTypeInfo)ti2).getTypeAt(0).getTypeClass(), StringValue.class);
        Assert.assertEquals((Object)((TupleTypeInfo)ti2).getTypeAt(1).getTypeClass(), IntValue.class);
    }

    @Test
    public void testGenericsNotInSuperclass() {
        RichMapFunction<LongKeyValue<String>, LongKeyValue<String>> function = new RichMapFunction<LongKeyValue<String>, LongKeyValue<String>>(){
            private static final long serialVersionUID = 1L;

            public LongKeyValue<String> map(LongKeyValue<String> value) throws Exception {
                return null;
            }
        };
        TypeInformation ti = TypeExtractor.getMapReturnTypes((MapFunction)function, (TypeInformation)TypeInfoParser.parse((String)"Tuple2<Long, String>"));
        Assert.assertTrue((boolean)ti.isTupleType());
        Assert.assertEquals((long)2L, (long)ti.getArity());
        TupleTypeInfo tti = (TupleTypeInfo)ti;
        Assert.assertEquals(LongKeyValue.class, (Object)tti.getTypeClass());
        Assert.assertEquals((Object)BasicTypeInfo.LONG_TYPE_INFO, (Object)tti.getTypeAt(0));
        Assert.assertEquals((Object)BasicTypeInfo.STRING_TYPE_INFO, (Object)tti.getTypeAt(1));
    }

    @Test
    public void testChainedGenericsNotInSuperclass() {
        RichMapFunction<ChainedTwo<Integer>, ChainedTwo<Integer>> function = new RichMapFunction<ChainedTwo<Integer>, ChainedTwo<Integer>>(){
            private static final long serialVersionUID = 1L;

            public ChainedTwo<Integer> map(ChainedTwo<Integer> value) throws Exception {
                return null;
            }
        };
        TypeInformation ti = TypeExtractor.getMapReturnTypes((MapFunction)function, (TypeInformation)TypeInfoParser.parse((String)"Tuple3<String, Long, Integer>"));
        Assert.assertTrue((boolean)ti.isTupleType());
        Assert.assertEquals((long)3L, (long)ti.getArity());
        TupleTypeInfo tti = (TupleTypeInfo)ti;
        Assert.assertEquals(ChainedTwo.class, (Object)tti.getTypeClass());
        Assert.assertEquals((Object)BasicTypeInfo.STRING_TYPE_INFO, (Object)tti.getTypeAt(0));
        Assert.assertEquals((Object)BasicTypeInfo.LONG_TYPE_INFO, (Object)tti.getTypeAt(1));
        Assert.assertEquals((Object)BasicTypeInfo.INT_TYPE_INFO, (Object)tti.getTypeAt(2));
    }

    @Test
    public void testGenericsInDirectSuperclass() {
        RichMapFunction<ChainedThree, ChainedThree> function = new RichMapFunction<ChainedThree, ChainedThree>(){
            private static final long serialVersionUID = 1L;

            public ChainedThree map(ChainedThree value) throws Exception {
                return null;
            }
        };
        TypeInformation ti = TypeExtractor.getMapReturnTypes((MapFunction)function, (TypeInformation)TypeInfoParser.parse((String)"Tuple3<String, Long, String>"));
        Assert.assertTrue((boolean)ti.isTupleType());
        Assert.assertEquals((long)3L, (long)ti.getArity());
        TupleTypeInfo tti = (TupleTypeInfo)ti;
        Assert.assertEquals(ChainedThree.class, (Object)tti.getTypeClass());
        Assert.assertEquals((Object)BasicTypeInfo.STRING_TYPE_INFO, (Object)tti.getTypeAt(0));
        Assert.assertEquals((Object)BasicTypeInfo.LONG_TYPE_INFO, (Object)tti.getTypeAt(1));
        Assert.assertEquals((Object)BasicTypeInfo.STRING_TYPE_INFO, (Object)tti.getTypeAt(2));
    }

    @Test
    public void testGenericsNotInSuperclassWithNonGenericClassAtEnd() {
        RichMapFunction<ChainedFour, ChainedFour> function = new RichMapFunction<ChainedFour, ChainedFour>(){
            private static final long serialVersionUID = 1L;

            public ChainedFour map(ChainedFour value) throws Exception {
                return null;
            }
        };
        TypeInformation ti = TypeExtractor.getMapReturnTypes((MapFunction)function, (TypeInformation)TypeInfoParser.parse((String)"Tuple3<String, Long, String>"));
        Assert.assertTrue((boolean)ti.isTupleType());
        Assert.assertEquals((long)3L, (long)ti.getArity());
        TupleTypeInfo tti = (TupleTypeInfo)ti;
        Assert.assertEquals(ChainedFour.class, (Object)tti.getTypeClass());
        Assert.assertEquals((Object)BasicTypeInfo.STRING_TYPE_INFO, (Object)tti.getTypeAt(0));
        Assert.assertEquals((Object)BasicTypeInfo.LONG_TYPE_INFO, (Object)tti.getTypeAt(1));
        Assert.assertEquals((Object)BasicTypeInfo.STRING_TYPE_INFO, (Object)tti.getTypeAt(2));
    }

    @Test
    public void testMissingTupleGenerics() {
        RichMapFunction<String, Tuple2> function = new RichMapFunction<String, Tuple2>(){
            private static final long serialVersionUID = 1L;

            public Tuple2 map(String value) throws Exception {
                return null;
            }
        };
        TypeInformation ti = TypeExtractor.getMapReturnTypes((MapFunction)function, (TypeInformation)TypeInfoParser.parse((String)"String"), (String)"name", (boolean)true);
        Assert.assertTrue((boolean)(ti instanceof MissingTypeInfo));
        try {
            TypeExtractor.getMapReturnTypes((MapFunction)function, (TypeInformation)TypeInfoParser.parse((String)"String"));
            Assert.fail((String)"Expected an exception");
        }
        catch (InvalidTypesException invalidTypesException) {
            // empty catch block
        }
    }

    @Test
    public void testTupleSupertype() {
        RichMapFunction<String, Tuple> function = new RichMapFunction<String, Tuple>(){
            private static final long serialVersionUID = 1L;

            public Tuple map(String value) throws Exception {
                return null;
            }
        };
        TypeInformation ti = TypeExtractor.getMapReturnTypes((MapFunction)function, (TypeInformation)TypeInfoParser.parse((String)"String"), (String)"name", (boolean)true);
        Assert.assertTrue((boolean)(ti instanceof MissingTypeInfo));
        try {
            TypeExtractor.getMapReturnTypes((MapFunction)function, (TypeInformation)TypeInfoParser.parse((String)"String"));
            Assert.fail((String)"Expected an exception");
        }
        catch (InvalidTypesException invalidTypesException) {
            // empty catch block
        }
    }

    @Test
    public void testSameGenericVariable() {
        RichMapFunction<SameTypeVariable<String>, SameTypeVariable<String>> function = new RichMapFunction<SameTypeVariable<String>, SameTypeVariable<String>>(){
            private static final long serialVersionUID = 1L;

            public SameTypeVariable<String> map(SameTypeVariable<String> value) throws Exception {
                return null;
            }
        };
        TypeInformation ti = TypeExtractor.getMapReturnTypes((MapFunction)function, (TypeInformation)TypeInfoParser.parse((String)"Tuple2<String, String>"));
        Assert.assertTrue((boolean)ti.isTupleType());
        Assert.assertEquals((long)2L, (long)ti.getArity());
        TupleTypeInfo tti = (TupleTypeInfo)ti;
        Assert.assertEquals(SameTypeVariable.class, (Object)tti.getTypeClass());
        Assert.assertEquals((Object)BasicTypeInfo.STRING_TYPE_INFO, (Object)tti.getTypeAt(0));
        Assert.assertEquals((Object)BasicTypeInfo.STRING_TYPE_INFO, (Object)tti.getTypeAt(1));
    }

    @Test
    public void testNestedTupleGenerics() {
        RichMapFunction<Nested<String, Integer>, Nested<String, Integer>> function = new RichMapFunction<Nested<String, Integer>, Nested<String, Integer>>(){
            private static final long serialVersionUID = 1L;

            public Nested<String, Integer> map(Nested<String, Integer> value) throws Exception {
                return null;
            }
        };
        TypeInformation ti = TypeExtractor.getMapReturnTypes((MapFunction)function, (TypeInformation)TypeInfoParser.parse((String)"Tuple2<String, Tuple2<Integer, Integer>>"));
        Assert.assertTrue((boolean)ti.isTupleType());
        Assert.assertEquals((long)2L, (long)ti.getArity());
        TupleTypeInfo tti = (TupleTypeInfo)ti;
        Assert.assertEquals(Nested.class, (Object)tti.getTypeClass());
        Assert.assertEquals((Object)BasicTypeInfo.STRING_TYPE_INFO, (Object)tti.getTypeAt(0));
        Assert.assertTrue((boolean)tti.getTypeAt(1).isTupleType());
        Assert.assertEquals((long)2L, (long)tti.getTypeAt(1).getArity());
        TupleTypeInfo tti2 = (TupleTypeInfo)tti.getTypeAt(1);
        Assert.assertEquals(Tuple2.class, (Object)tti2.getTypeClass());
        Assert.assertEquals((Object)BasicTypeInfo.INT_TYPE_INFO, (Object)tti2.getTypeAt(0));
        Assert.assertEquals((Object)BasicTypeInfo.INT_TYPE_INFO, (Object)tti2.getTypeAt(1));
    }

    @Test
    public void testNestedTupleGenerics2() {
        RichMapFunction<Nested2<Boolean>, Nested2<Boolean>> function = new RichMapFunction<Nested2<Boolean>, Nested2<Boolean>>(){
            private static final long serialVersionUID = 1L;

            public Nested2<Boolean> map(Nested2<Boolean> value) throws Exception {
                return null;
            }
        };
        TypeInformation ti = TypeExtractor.getMapReturnTypes((MapFunction)function, (TypeInformation)TypeInfoParser.parse((String)"Tuple2<Boolean, Tuple2<Tuple2<Integer, Tuple2<Boolean, Boolean>>, Tuple2<Integer, Tuple2<Boolean, Boolean>>>>"));
        Assert.assertTrue((boolean)ti.isTupleType());
        Assert.assertEquals((long)2L, (long)ti.getArity());
        TupleTypeInfo tti = (TupleTypeInfo)ti;
        Assert.assertEquals((Object)BasicTypeInfo.BOOLEAN_TYPE_INFO, (Object)tti.getTypeAt(0));
        Assert.assertTrue((boolean)tti.getTypeAt(1).isTupleType());
        TupleTypeInfo tti2 = (TupleTypeInfo)tti.getTypeAt(1);
        Assert.assertTrue((boolean)tti2.getTypeAt(0).isTupleType());
        Assert.assertTrue((boolean)tti2.getTypeAt(1).isTupleType());
        TupleTypeInfo tti3 = (TupleTypeInfo)tti2.getTypeAt(0);
        Assert.assertEquals((Object)BasicTypeInfo.INT_TYPE_INFO, (Object)tti3.getTypeAt(0));
        Assert.assertTrue((boolean)tti3.getTypeAt(1).isTupleType());
        TupleTypeInfo tti4 = (TupleTypeInfo)tti3.getTypeAt(1);
        Assert.assertEquals((Object)BasicTypeInfo.BOOLEAN_TYPE_INFO, (Object)tti4.getTypeAt(0));
        Assert.assertEquals((Object)BasicTypeInfo.BOOLEAN_TYPE_INFO, (Object)tti4.getTypeAt(1));
    }

    @Test
    public void testFunctionWithMissingGenerics() {
        RichMapFunction function = new RichMapFunction(){
            private static final long serialVersionUID = 1L;

            public String map(Object value) throws Exception {
                return null;
            }
        };
        TypeInformation ti = TypeExtractor.getMapReturnTypes((MapFunction)function, (TypeInformation)TypeInfoParser.parse((String)"String"), (String)"name", (boolean)true);
        Assert.assertTrue((boolean)(ti instanceof MissingTypeInfo));
        try {
            TypeExtractor.getMapReturnTypes((MapFunction)function, (TypeInformation)TypeInfoParser.parse((String)"String"));
            Assert.fail((String)"Expected an exception");
        }
        catch (InvalidTypesException invalidTypesException) {
            // empty catch block
        }
    }

    @Test
    public void testFunctionWithMissingGenericsAndReturns() {
        RichMapFunction function = new RichMapFunction(){
            private static final long serialVersionUID = 1L;

            public Object map(Object value) throws Exception {
                return null;
            }
        };
        TypeInformation info = ExecutionEnvironment.getExecutionEnvironment().fromElements((Object[])new String[]{"arbitrary", "data"}).map((MapFunction)function).returns("String").getResultType();
        Assert.assertEquals((Object)TypeInfoParser.parse((String)"String"), (Object)info);
    }

    @Test
    public void testFunctionDependingOnInputAsSuperclass() {
        IdentityMapper<Boolean> function = new IdentityMapper<Boolean>(){
            private static final long serialVersionUID = 1L;
        };
        TypeInformation ti = TypeExtractor.getMapReturnTypes((MapFunction)function, (TypeInformation)TypeInfoParser.parse((String)"Boolean"));
        Assert.assertTrue((boolean)ti.isBasicType());
        Assert.assertEquals((Object)BasicTypeInfo.BOOLEAN_TYPE_INFO, (Object)ti);
    }

    @Test
    public void testFunctionDependingOnInputFromInput() {
        IdentityMapper function = new IdentityMapper();
        TypeInformation ti = TypeExtractor.getMapReturnTypes(function, (TypeInformation)BasicTypeInfo.BOOLEAN_TYPE_INFO);
        Assert.assertTrue((boolean)ti.isBasicType());
        Assert.assertEquals((Object)BasicTypeInfo.BOOLEAN_TYPE_INFO, (Object)ti);
    }

    @Test
    public void testFunctionDependingOnInputWithMissingInput() {
        IdentityMapper function = new IdentityMapper();
        try {
            TypeExtractor.getMapReturnTypes(function, null);
            Assert.fail((String)"exception expected");
        }
        catch (InvalidTypesException invalidTypesException) {
            // empty catch block
        }
    }

    @Test
    public void testFunctionDependingOnInputWithTupleInput() {
        IdentityMapper2 function = new IdentityMapper2();
        TupleTypeInfo inputType = new TupleTypeInfo(new TypeInformation[]{BasicTypeInfo.BOOLEAN_TYPE_INFO, BasicTypeInfo.STRING_TYPE_INFO});
        TypeInformation ti = TypeExtractor.getMapReturnTypes(function, (TypeInformation)inputType);
        Assert.assertTrue((boolean)ti.isBasicType());
        Assert.assertEquals((Object)BasicTypeInfo.BOOLEAN_TYPE_INFO, (Object)ti);
    }

    @Test
    public void testFunctionDependingOnInputWithCustomTupleInput() {
        IdentityMapper function = new IdentityMapper();
        TypeInformation ti = TypeExtractor.getMapReturnTypes(function, (TypeInformation)TypeInfoParser.parse((String)"Tuple2<String, String>"));
        Assert.assertTrue((boolean)ti.isTupleType());
        Assert.assertEquals((long)2L, (long)ti.getArity());
        TupleTypeInfo tti = (TupleTypeInfo)ti;
        Assert.assertEquals((Object)BasicTypeInfo.STRING_TYPE_INFO, (Object)tti.getTypeAt(0));
        Assert.assertEquals((Object)BasicTypeInfo.STRING_TYPE_INFO, (Object)tti.getTypeAt(1));
    }

    @Test
    public void testFunctionDependingOnUnknownInput() {
        IdentityMapper3 function = new IdentityMapper3();
        TypeInformation ti = TypeExtractor.getMapReturnTypes(function, (TypeInformation)BasicTypeInfo.BOOLEAN_TYPE_INFO, (String)"name", (boolean)true);
        Assert.assertTrue((boolean)(ti instanceof MissingTypeInfo));
        try {
            TypeExtractor.getMapReturnTypes(function, (TypeInformation)BasicTypeInfo.BOOLEAN_TYPE_INFO);
            Assert.fail((String)"Expected an exception");
        }
        catch (InvalidTypesException invalidTypesException) {
            // empty catch block
        }
    }

    @Test
    public void testFunctionDependingOnInputWithFunctionHierarchy() {
        IdentityMapper4 function = new IdentityMapper4();
        TypeInformation ti = TypeExtractor.getMapReturnTypes(function, (TypeInformation)BasicTypeInfo.STRING_TYPE_INFO);
        Assert.assertEquals((Object)BasicTypeInfo.STRING_TYPE_INFO, (Object)ti);
    }

    @Test
    public void testFunctionDependingOnInputWithFunctionHierarchy2() {
        IdentityMapper5 function = new IdentityMapper5();
        TypeInformation ti = TypeExtractor.getMapReturnTypes(function, (TypeInformation)new TupleTypeInfo(new TypeInformation[]{BasicTypeInfo.STRING_TYPE_INFO, BasicTypeInfo.STRING_TYPE_INFO}));
        Assert.assertTrue((boolean)ti.isTupleType());
        TupleTypeInfo tti = (TupleTypeInfo)ti;
        Assert.assertEquals((Object)BasicTypeInfo.STRING_TYPE_INFO, (Object)tti.getTypeAt(0));
        Assert.assertEquals((Object)BasicTypeInfo.STRING_TYPE_INFO, (Object)tti.getTypeAt(1));
    }

    @Test
    public void testFunctionWithNoGenericSuperclass() {
        Mapper2 function = new Mapper2();
        TypeInformation ti = TypeExtractor.getMapReturnTypes((MapFunction)function, (TypeInformation)TypeInfoParser.parse((String)"String"));
        Assert.assertTrue((boolean)ti.isBasicType());
        Assert.assertEquals((Object)BasicTypeInfo.STRING_TYPE_INFO, (Object)ti);
    }

    @Test
    public void testFunctionDependingPartialOnInput() {
        OneAppender<DoubleValue> function = new OneAppender<DoubleValue>(){
            private static final long serialVersionUID = 1L;
        };
        TypeInformation ti = TypeExtractor.getMapReturnTypes((MapFunction)function, (TypeInformation)TypeInfoParser.parse((String)"DoubleValue"));
        Assert.assertTrue((boolean)ti.isTupleType());
        Assert.assertEquals((long)2L, (long)ti.getArity());
        TupleTypeInfo tti = (TupleTypeInfo)ti;
        Assert.assertTrue((boolean)(tti.getTypeAt(0) instanceof ValueTypeInfo));
        ValueTypeInfo vti = (ValueTypeInfo)tti.getTypeAt(0);
        Assert.assertEquals(DoubleValue.class, (Object)vti.getTypeClass());
        Assert.assertTrue((boolean)tti.getTypeAt(1).isBasicType());
        Assert.assertEquals(Integer.class, (Object)tti.getTypeAt(1).getTypeClass());
    }

    @Test
    public void testFunctionDependingPartialOnInput2() {
        OneAppender function = new OneAppender();
        TypeInformation ti = TypeExtractor.getMapReturnTypes(function, (TypeInformation)new ValueTypeInfo(DoubleValue.class));
        Assert.assertTrue((boolean)ti.isTupleType());
        Assert.assertEquals((long)2L, (long)ti.getArity());
        TupleTypeInfo tti = (TupleTypeInfo)ti;
        Assert.assertTrue((boolean)(tti.getTypeAt(0) instanceof ValueTypeInfo));
        ValueTypeInfo vti = (ValueTypeInfo)tti.getTypeAt(0);
        Assert.assertEquals(DoubleValue.class, (Object)vti.getTypeClass());
        Assert.assertTrue((boolean)tti.getTypeAt(1).isBasicType());
        Assert.assertEquals(Integer.class, (Object)tti.getTypeAt(1).getTypeClass());
    }

    @Test
    public void testFunctionInputInOutputMultipleTimes() {
        FieldDuplicator function = new FieldDuplicator();
        TypeInformation ti = TypeExtractor.getMapReturnTypes(function, (TypeInformation)BasicTypeInfo.FLOAT_TYPE_INFO);
        Assert.assertTrue((boolean)ti.isTupleType());
        Assert.assertEquals((long)2L, (long)ti.getArity());
        TupleTypeInfo tti = (TupleTypeInfo)ti;
        Assert.assertEquals((Object)BasicTypeInfo.FLOAT_TYPE_INFO, (Object)tti.getTypeAt(0));
        Assert.assertEquals((Object)BasicTypeInfo.FLOAT_TYPE_INFO, (Object)tti.getTypeAt(1));
    }

    @Test
    public void testFunctionInputInOutputMultipleTimes2() {
        FieldDuplicator function = new FieldDuplicator();
        TypeInformation ti = TypeExtractor.getMapReturnTypes(function, (TypeInformation)new TupleTypeInfo(new TypeInformation[]{BasicTypeInfo.FLOAT_TYPE_INFO, BasicTypeInfo.FLOAT_TYPE_INFO}));
        Assert.assertTrue((boolean)ti.isTupleType());
        Assert.assertEquals((long)2L, (long)ti.getArity());
        TupleTypeInfo tti = (TupleTypeInfo)ti;
        Assert.assertTrue((boolean)tti.getTypeAt(0).isTupleType());
        TupleTypeInfo tti2 = (TupleTypeInfo)tti.getTypeAt(0);
        Assert.assertEquals((Object)BasicTypeInfo.FLOAT_TYPE_INFO, (Object)tti2.getTypeAt(0));
        Assert.assertEquals((Object)BasicTypeInfo.FLOAT_TYPE_INFO, (Object)tti2.getTypeAt(1));
        Assert.assertTrue((boolean)tti.getTypeAt(0).isTupleType());
        TupleTypeInfo tti3 = (TupleTypeInfo)tti.getTypeAt(1);
        Assert.assertEquals((Object)BasicTypeInfo.FLOAT_TYPE_INFO, (Object)tti3.getTypeAt(0));
        Assert.assertEquals((Object)BasicTypeInfo.FLOAT_TYPE_INFO, (Object)tti3.getTypeAt(1));
    }

    @Test
    public void testAbstractAndInterfaceTypes() {
        RichMapFunction<String, Testable> function = new RichMapFunction<String, Testable>(){
            private static final long serialVersionUID = 1L;

            public Testable map(String value) throws Exception {
                return null;
            }
        };
        TypeInformation ti = TypeExtractor.getMapReturnTypes((MapFunction)function, (TypeInformation)BasicTypeInfo.STRING_TYPE_INFO);
        Assert.assertTrue((boolean)(ti instanceof GenericTypeInfo));
        RichMapFunction<String, AbstractClassWithoutMember> function2 = new RichMapFunction<String, AbstractClassWithoutMember>(){
            private static final long serialVersionUID = 1L;

            public AbstractClassWithoutMember map(String value) throws Exception {
                return null;
            }
        };
        ti = TypeExtractor.getMapReturnTypes((MapFunction)function2, (TypeInformation)BasicTypeInfo.STRING_TYPE_INFO);
        Assert.assertTrue((boolean)(ti instanceof GenericTypeInfo));
        RichMapFunction<String, AbstractClassWithMember> function3 = new RichMapFunction<String, AbstractClassWithMember>(){
            private static final long serialVersionUID = 1L;

            public AbstractClassWithMember map(String value) throws Exception {
                return null;
            }
        };
        ti = TypeExtractor.getMapReturnTypes((MapFunction)function3, (TypeInformation)BasicTypeInfo.STRING_TYPE_INFO);
        Assert.assertTrue((boolean)(ti instanceof PojoTypeInfo));
    }

    @Test
    public void testValueSupertypeException() {
        RichMapFunction<StringValue, Value> function = new RichMapFunction<StringValue, Value>(){
            private static final long serialVersionUID = 1L;

            public Value map(StringValue value) throws Exception {
                return null;
            }
        };
        TypeInformation ti = TypeExtractor.getMapReturnTypes((MapFunction)function, (TypeInformation)TypeInfoParser.parse((String)"StringValue"), (String)"name", (boolean)true);
        Assert.assertTrue((boolean)(ti instanceof MissingTypeInfo));
        try {
            TypeExtractor.getMapReturnTypes((MapFunction)function, (TypeInformation)TypeInfoParser.parse((String)"StringValue"));
            Assert.fail((String)"Expected an exception");
        }
        catch (InvalidTypesException invalidTypesException) {
            // empty catch block
        }
    }

    @Test
    public void testBasicArray() {
        RichCoGroupFunction<String[], String[], String[]> function = new RichCoGroupFunction<String[], String[], String[]>(){
            private static final long serialVersionUID = 1L;

            public void coGroup(Iterable<String[]> first, Iterable<String[]> second, Collector<String[]> out) throws Exception {
            }
        };
        TypeInformation ti = TypeExtractor.getCoGroupReturnTypes((CoGroupFunction)function, (TypeInformation)TypeInfoParser.parse((String)"String[]"), (TypeInformation)TypeInfoParser.parse((String)"String[]"));
        Assert.assertFalse((boolean)ti.isBasicType());
        Assert.assertFalse((boolean)ti.isTupleType());
        Assert.assertTrue((ti instanceof BasicArrayTypeInfo || ti instanceof ObjectArrayTypeInfo ? 1 : 0) != 0);
        if (ti instanceof BasicArrayTypeInfo) {
            Assert.assertEquals((Object)BasicArrayTypeInfo.STRING_ARRAY_TYPE_INFO, (Object)ti);
        } else {
            Assert.assertEquals((Object)BasicTypeInfo.STRING_TYPE_INFO, (Object)((ObjectArrayTypeInfo)ti).getComponentInfo());
        }
    }

    @Test
    public void testBasicArray2() {
        IdentityMapper function = new IdentityMapper();
        TypeInformation ti = TypeExtractor.getMapReturnTypes(function, (TypeInformation)BasicArrayTypeInfo.BOOLEAN_ARRAY_TYPE_INFO);
        Assert.assertTrue((boolean)(ti instanceof BasicArrayTypeInfo));
        BasicArrayTypeInfo bati = (BasicArrayTypeInfo)ti;
        Assert.assertTrue((boolean)bati.getComponentInfo().isBasicType());
        Assert.assertEquals((Object)BasicTypeInfo.BOOLEAN_TYPE_INFO, (Object)bati.getComponentInfo());
    }

    @Test
    public void testCustomArray() {
        RichMapFunction<CustomArrayObject[], CustomArrayObject[]> function = new RichMapFunction<CustomArrayObject[], CustomArrayObject[]>(){
            private static final long serialVersionUID = 1L;

            public CustomArrayObject[] map(CustomArrayObject[] value) throws Exception {
                return null;
            }
        };
        TypeInformation ti = TypeExtractor.getMapReturnTypes((MapFunction)function, (TypeInformation)TypeInfoParser.parse((String)"org.apache.flink.api.java.type.extractor.TypeExtractorTest$CustomArrayObject[]"));
        Assert.assertTrue((boolean)(ti instanceof ObjectArrayTypeInfo));
        Assert.assertEquals(CustomArrayObject.class, (Object)((ObjectArrayTypeInfo)ti).getComponentInfo().getTypeClass());
    }

    @Test
    public void testTupleArray() {
        RichMapFunction<Tuple2<String, String>[], Tuple2<String, String>[]> function = new RichMapFunction<Tuple2<String, String>[], Tuple2<String, String>[]>(){
            private static final long serialVersionUID = 1L;

            public Tuple2<String, String>[] map(Tuple2<String, String>[] value) throws Exception {
                return null;
            }
        };
        TypeInformation ti = TypeExtractor.getMapReturnTypes((MapFunction)function, (TypeInformation)TypeInfoParser.parse((String)"Tuple2<String, String>[]"));
        Assert.assertTrue((boolean)(ti instanceof ObjectArrayTypeInfo));
        ObjectArrayTypeInfo oati = (ObjectArrayTypeInfo)ti;
        Assert.assertTrue((boolean)oati.getComponentInfo().isTupleType());
        TupleTypeInfo tti = (TupleTypeInfo)oati.getComponentInfo();
        Assert.assertEquals((Object)BasicTypeInfo.STRING_TYPE_INFO, (Object)tti.getTypeAt(0));
        Assert.assertEquals((Object)BasicTypeInfo.STRING_TYPE_INFO, (Object)tti.getTypeAt(1));
    }

    @Test
    public void testCustomArrayWithTypeVariable() {
        IdentityMapper function = new IdentityMapper();
        TypeInformation ti = TypeExtractor.getMapReturnTypes(function, (TypeInformation)TypeInfoParser.parse((String)"Tuple1<Boolean>[]"));
        Assert.assertTrue((boolean)(ti instanceof ObjectArrayTypeInfo));
        ObjectArrayTypeInfo oati = (ObjectArrayTypeInfo)ti;
        Assert.assertTrue((boolean)oati.getComponentInfo().isTupleType());
        TupleTypeInfo tti = (TupleTypeInfo)oati.getComponentInfo();
        Assert.assertEquals((Object)BasicTypeInfo.BOOLEAN_TYPE_INFO, (Object)tti.getTypeAt(0));
    }

    @Test
    public void testParameterizedArrays() {
        GenericArrayClass<Boolean> function = new GenericArrayClass<Boolean>(){
            private static final long serialVersionUID = 1L;
        };
        TypeInformation ti = TypeExtractor.getMapReturnTypes((MapFunction)function, (TypeInformation)TypeInfoParser.parse((String)"Boolean[]"));
        Assert.assertTrue((boolean)(ti instanceof ObjectArrayTypeInfo));
        ObjectArrayTypeInfo oati = (ObjectArrayTypeInfo)ti;
        Assert.assertEquals((Object)BasicTypeInfo.BOOLEAN_TYPE_INFO, (Object)oati.getComponentInfo());
    }

    @Test
    public void testParameterizedPojo() {
        RichMapFunction<InType, MyObject<String>> function = new RichMapFunction<InType, MyObject<String>>(){
            private static final long serialVersionUID = 1L;

            public MyObject<String> map(InType value) throws Exception {
                return null;
            }
        };
        TypeInformation inType = TypeExtractor.createTypeInfo(InType.class);
        TypeInformation ti = TypeExtractor.getMapReturnTypes((MapFunction)function, (TypeInformation)inType);
        Assert.assertTrue((boolean)(ti instanceof PojoTypeInfo));
    }

    @Test
    public void testFunctionDependingOnInputWithTupleInputWithTypeMismatch() {
        IdentityMapper2 function = new IdentityMapper2();
        TupleTypeInfo inputType = new TupleTypeInfo(new TypeInformation[]{BasicTypeInfo.BOOLEAN_TYPE_INFO, BasicTypeInfo.INT_TYPE_INFO});
        try {
            TypeExtractor.getMapReturnTypes(function, (TypeInformation)inputType);
            Assert.fail((String)"exception expected");
        }
        catch (InvalidTypesException invalidTypesException) {
            // empty catch block
        }
    }

    @Test
    public void testInputMismatchExceptions() {
        RichMapFunction<Tuple2<String, String>, String> function = new RichMapFunction<Tuple2<String, String>, String>(){
            private static final long serialVersionUID = 1L;

            public String map(Tuple2<String, String> value) throws Exception {
                return null;
            }
        };
        try {
            TypeExtractor.getMapReturnTypes((MapFunction)function, (TypeInformation)TypeInfoParser.parse((String)"Tuple2<Integer, String>"));
            Assert.fail((String)"exception expected");
        }
        catch (InvalidTypesException invalidTypesException) {
            // empty catch block
        }
        try {
            TypeExtractor.getMapReturnTypes((MapFunction)function, (TypeInformation)TypeInfoParser.parse((String)"Tuple3<String, String, String>"));
            Assert.fail((String)"exception expected");
        }
        catch (InvalidTypesException invalidTypesException) {
            // empty catch block
        }
        RichMapFunction<StringValue, String> function2 = new RichMapFunction<StringValue, String>(){
            private static final long serialVersionUID = 1L;

            public String map(StringValue value) throws Exception {
                return null;
            }
        };
        try {
            TypeExtractor.getMapReturnTypes((MapFunction)function2, (TypeInformation)TypeInfoParser.parse((String)"IntValue"));
            Assert.fail((String)"exception expected");
        }
        catch (InvalidTypesException invalidTypesException) {
            // empty catch block
        }
        RichMapFunction<Tuple1<Integer>[], String> function3 = new RichMapFunction<Tuple1<Integer>[], String>(){
            private static final long serialVersionUID = 1L;

            public String map(Tuple1<Integer>[] value) throws Exception {
                return null;
            }
        };
        try {
            TypeExtractor.getMapReturnTypes((MapFunction)function3, (TypeInformation)TypeInfoParser.parse((String)"Integer[]"));
            Assert.fail((String)"exception expected");
        }
        catch (InvalidTypesException invalidTypesException) {
            // empty catch block
        }
        RichMapFunction<Writable, String> function4 = new RichMapFunction<Writable, String>(){
            private static final long serialVersionUID = 1L;

            public String map(Writable value) throws Exception {
                return null;
            }
        };
        try {
            TypeExtractor.getMapReturnTypes((MapFunction)function4, (TypeInformation)new WritableTypeInfo(MyWritable.class));
            Assert.fail((String)"exception expected");
        }
        catch (InvalidTypesException invalidTypesException) {
            // empty catch block
        }
    }

    @Test
    public void testTypeErasure() {
        TypeInformation ti = TypeExtractor.getFlatMapReturnTypes(new DummyFlatMapFunction(), (TypeInformation)TypeInfoParser.parse((String)"Tuple2<String, Integer>"), (String)"name", (boolean)true);
        Assert.assertTrue((boolean)(ti instanceof MissingTypeInfo));
        try {
            TypeExtractor.getFlatMapReturnTypes(new DummyFlatMapFunction(), (TypeInformation)TypeInfoParser.parse((String)"Tuple2<String, Integer>"));
            Assert.fail((String)"Expected an exception");
        }
        catch (InvalidTypesException invalidTypesException) {
            // empty catch block
        }
    }

    @Test
    public void testResultTypeQueryable() {
        TypeInformation ti = TypeExtractor.getMapReturnTypes(new MyQueryableMapper(), (TypeInformation)BasicTypeInfo.STRING_TYPE_INFO);
        Assert.assertEquals((Object)BasicTypeInfo.INT_TYPE_INFO, (Object)ti);
    }

    @Test
    public void testTupleWithPrimitiveArray() {
        RichMapFunction<Integer, Tuple9<int[], double[], long[], byte[], char[], float[], short[], boolean[], String[]>> function = new RichMapFunction<Integer, Tuple9<int[], double[], long[], byte[], char[], float[], short[], boolean[], String[]>>(){
            private static final long serialVersionUID = 1L;

            public Tuple9<int[], double[], long[], byte[], char[], float[], short[], boolean[], String[]> map(Integer value) throws Exception {
                return null;
            }
        };
        TypeInformation ti = TypeExtractor.getMapReturnTypes((MapFunction)function, (TypeInformation)BasicTypeInfo.INT_TYPE_INFO);
        TupleTypeInfo tti = (TupleTypeInfo)ti;
        Assert.assertEquals((Object)PrimitiveArrayTypeInfo.INT_PRIMITIVE_ARRAY_TYPE_INFO, (Object)tti.getTypeAt(0));
        Assert.assertEquals((Object)PrimitiveArrayTypeInfo.DOUBLE_PRIMITIVE_ARRAY_TYPE_INFO, (Object)tti.getTypeAt(1));
        Assert.assertEquals((Object)PrimitiveArrayTypeInfo.LONG_PRIMITIVE_ARRAY_TYPE_INFO, (Object)tti.getTypeAt(2));
        Assert.assertEquals((Object)PrimitiveArrayTypeInfo.BYTE_PRIMITIVE_ARRAY_TYPE_INFO, (Object)tti.getTypeAt(3));
        Assert.assertEquals((Object)PrimitiveArrayTypeInfo.CHAR_PRIMITIVE_ARRAY_TYPE_INFO, (Object)tti.getTypeAt(4));
        Assert.assertEquals((Object)PrimitiveArrayTypeInfo.FLOAT_PRIMITIVE_ARRAY_TYPE_INFO, (Object)tti.getTypeAt(5));
        Assert.assertEquals((Object)PrimitiveArrayTypeInfo.SHORT_PRIMITIVE_ARRAY_TYPE_INFO, (Object)tti.getTypeAt(6));
        Assert.assertEquals((Object)PrimitiveArrayTypeInfo.BOOLEAN_PRIMITIVE_ARRAY_TYPE_INFO, (Object)tti.getTypeAt(7));
        Assert.assertEquals((Object)BasicArrayTypeInfo.STRING_ARRAY_TYPE_INFO, (Object)tti.getTypeAt(8));
    }

    @Test
    public void testFunction() {
        RichMapFunction<String, Boolean> mapInterface = new RichMapFunction<String, Boolean>(){
            private static final long serialVersionUID = 1L;

            public void setRuntimeContext(RuntimeContext t) {
            }

            public void open(Configuration parameters) throws Exception {
            }

            public RuntimeContext getRuntimeContext() {
                return null;
            }

            public void close() throws Exception {
            }

            public Boolean map(String record) throws Exception {
                return null;
            }
        };
        TypeInformation ti = TypeExtractor.getMapReturnTypes((MapFunction)mapInterface, (TypeInformation)BasicTypeInfo.STRING_TYPE_INFO);
        Assert.assertEquals((Object)BasicTypeInfo.BOOLEAN_TYPE_INFO, (Object)ti);
    }

    @Test
    public void testInterface() {
        MapFunction<String, Boolean> mapInterface = new MapFunction<String, Boolean>(){
            private static final long serialVersionUID = 1L;

            public Boolean map(String record) throws Exception {
                return null;
            }
        };
        TypeInformation ti = TypeExtractor.getMapReturnTypes((MapFunction)mapInterface, (TypeInformation)BasicTypeInfo.STRING_TYPE_INFO);
        Assert.assertEquals((Object)BasicTypeInfo.BOOLEAN_TYPE_INFO, (Object)ti);
    }

    @Test
    public void testExtractKeySelector() {
        KeySelector<String, Integer> selector = new KeySelector<String, Integer>(){

            public Integer getKey(String value) {
                return null;
            }
        };
        TypeInformation ti = TypeExtractor.getKeySelectorTypes((KeySelector)selector, (TypeInformation)BasicTypeInfo.STRING_TYPE_INFO);
        Assert.assertEquals((Object)BasicTypeInfo.INT_TYPE_INFO, (Object)ti);
        try {
            TypeExtractor.getKeySelectorTypes((KeySelector)selector, (TypeInformation)BasicTypeInfo.BOOLEAN_TYPE_INFO);
            Assert.fail();
        }
        catch (InvalidTypesException invalidTypesException) {
        }
        catch (Exception e) {
            Assert.fail((String)"wrong exception type");
        }
    }

    @Test
    public void testDuplicateValue() {
        TypeInformation ti = TypeExtractor.getMapReturnTypes(new DuplicateValue(), (TypeInformation)TypeInfoParser.parse((String)"Tuple1<String>"));
        Assert.assertTrue((boolean)ti.isTupleType());
        Assert.assertEquals((long)2L, (long)ti.getArity());
        TupleTypeInfo tti = (TupleTypeInfo)ti;
        Assert.assertEquals((Object)BasicTypeInfo.STRING_TYPE_INFO, (Object)tti.getTypeAt(0));
        Assert.assertEquals((Object)BasicTypeInfo.STRING_TYPE_INFO, (Object)tti.getTypeAt(1));
    }

    @Test
    public void testDuplicateValueNested() {
        TypeInformation ti = TypeExtractor.getMapReturnTypes(new DuplicateValueNested(), (TypeInformation)TypeInfoParser.parse((String)"Tuple1<Tuple1<String>>"));
        Assert.assertTrue((boolean)ti.isTupleType());
        Assert.assertEquals((long)2L, (long)ti.getArity());
        TupleTypeInfo tti = (TupleTypeInfo)ti;
        Assert.assertEquals((Object)BasicTypeInfo.STRING_TYPE_INFO, (Object)tti.getTypeAt(0));
        Assert.assertEquals((Object)BasicTypeInfo.STRING_TYPE_INFO, (Object)tti.getTypeAt(1));
    }

    @Test
    public void testInputInference1() {
        EdgeMapper em = new EdgeMapper();
        TypeInformation ti = TypeExtractor.getMapReturnTypes(em, (TypeInformation)TypeInfoParser.parse((String)"Tuple3<String, String, Double>"));
        Assert.assertTrue((boolean)ti.isTupleType());
        Assert.assertEquals((long)3L, (long)ti.getArity());
        TupleTypeInfo tti = (TupleTypeInfo)ti;
        Assert.assertEquals((Object)BasicTypeInfo.STRING_TYPE_INFO, (Object)tti.getTypeAt(0));
        Assert.assertEquals((Object)BasicTypeInfo.STRING_TYPE_INFO, (Object)tti.getTypeAt(1));
        Assert.assertEquals((Object)BasicTypeInfo.DOUBLE_TYPE_INFO, (Object)tti.getTypeAt(2));
    }

    @Test
    public void testInputInference2() {
        EdgeMapper2 em = new EdgeMapper2();
        TypeInformation ti = TypeExtractor.getMapReturnTypes(em, (TypeInformation)TypeInfoParser.parse((String)"Boolean"));
        Assert.assertTrue((boolean)ti.isTupleType());
        Assert.assertEquals((long)3L, (long)ti.getArity());
        TupleTypeInfo tti = (TupleTypeInfo)ti;
        Assert.assertEquals((Object)BasicTypeInfo.LONG_TYPE_INFO, (Object)tti.getTypeAt(0));
        Assert.assertEquals((Object)BasicTypeInfo.LONG_TYPE_INFO, (Object)tti.getTypeAt(1));
        Assert.assertEquals((Object)BasicTypeInfo.BOOLEAN_TYPE_INFO, (Object)tti.getTypeAt(2));
    }

    @Test
    public void testInputInference3() {
        EdgeMapper3 em = new EdgeMapper3();
        TypeInformation ti = TypeExtractor.getMapReturnTypes(em, (TypeInformation)TypeInfoParser.parse((String)"Tuple3<Boolean,Boolean,String>"));
        Assert.assertTrue((boolean)ti.isBasicType());
        Assert.assertEquals((Object)BasicTypeInfo.STRING_TYPE_INFO, (Object)ti);
    }

    @Test
    public void testInputInference4() {
        EdgeMapper4 em = new EdgeMapper4();
        TypeInformation ti = TypeExtractor.getMapReturnTypes(em, (TypeInformation)TypeInfoParser.parse((String)"Tuple3<Boolean,Boolean,String>[]"));
        Assert.assertTrue((boolean)ti.isBasicType());
        Assert.assertEquals((Object)BasicTypeInfo.STRING_TYPE_INFO, (Object)ti);
    }

    @Test
    public void testEnumType() {
        MapFunction<MyEnum, MyEnum> mf = new MapFunction<MyEnum, MyEnum>(){
            private static final long serialVersionUID = 1L;

            public MyEnum map(MyEnum value) throws Exception {
                return null;
            }
        };
        TypeInformation ti = TypeExtractor.getMapReturnTypes((MapFunction)mf, (TypeInformation)new EnumTypeInfo(MyEnum.class));
        Assert.assertTrue((boolean)(ti instanceof EnumTypeInfo));
        Assert.assertEquals((Object)ti.getTypeClass(), MyEnum.class);
    }

    @Test
    public void testMultiDimensionalArray() {
        Object function = new MapFunction<Tuple2<Integer, Double>[][], Tuple2<Integer, Double>[][]>(){
            private static final long serialVersionUID = 1L;

            public Tuple2<Integer, Double>[][] map(Tuple2<Integer, Double>[][] value) throws Exception {
                return null;
            }
        };
        TypeInformation ti = TypeExtractor.getMapReturnTypes((MapFunction)function, (TypeInformation)TypeInfoParser.parse((String)"Tuple2<Integer, Double>[][]"));
        Assert.assertEquals((Object)"ObjectArrayTypeInfo<ObjectArrayTypeInfo<Java Tuple2<Integer, Double>>>", (Object)ti.toString());
        function = new MapFunction<int[][][], int[][][]>(){
            private static final long serialVersionUID = 1L;

            public int[][][] map(int[][][] value) throws Exception {
                return null;
            }
        };
        ti = TypeExtractor.getMapReturnTypes((MapFunction)function, (TypeInformation)TypeInfoParser.parse((String)"int[][][]"));
        Assert.assertEquals((Object)"ObjectArrayTypeInfo<ObjectArrayTypeInfo<int[]>>", (Object)ti.toString());
        function = new MapFunction<Integer[][][], Integer[][][]>(){
            private static final long serialVersionUID = 1L;

            public Integer[][][] map(Integer[][][] value) throws Exception {
                return null;
            }
        };
        ti = TypeExtractor.getMapReturnTypes((MapFunction)function, (TypeInformation)TypeInfoParser.parse((String)"Integer[][][]"));
        Assert.assertEquals((Object)"ObjectArrayTypeInfo<ObjectArrayTypeInfo<BasicArrayTypeInfo<Integer>>>", (Object)ti.toString());
        function = new MapFunction<CustomType[][][], CustomType[][][]>(){
            private static final long serialVersionUID = 1L;

            public CustomType[][][] map(CustomType[][][] value) throws Exception {
                return null;
            }
        };
        ti = TypeExtractor.getMapReturnTypes((MapFunction)function, (TypeInformation)TypeInfoParser.parse((String)"org.apache.flink.api.java.type.extractor.TypeExtractorTest$CustomType<myField1=String,myField2=int>[][][]"));
        Assert.assertEquals((Object)"ObjectArrayTypeInfo<ObjectArrayTypeInfo<ObjectArrayTypeInfo<PojoType<org.apache.flink.api.java.type.extractor.TypeExtractorTest$CustomType, fields = [myField1: String, myField2: Integer]>>>>", (Object)ti.toString());
        ti = TypeExtractor.getMapReturnTypes(new MapperWithMultiDimGenericArray(), (TypeInformation)TypeInfoParser.parse((String)"String[][][]"));
        Assert.assertEquals((Object)"ObjectArrayTypeInfo<ObjectArrayTypeInfo<ObjectArrayTypeInfo<Java Tuple1<String>>>>", (Object)ti.toString());
    }

    @Test
    public void testInputMismatchWithRawFuntion() {
        MapWithResultTypeQueryable function = new MapWithResultTypeQueryable();
        TypeInformation ti = TypeExtractor.getMapReturnTypes((MapFunction)function, (TypeInformation)BasicTypeInfo.INT_TYPE_INFO);
        Assert.assertEquals((Object)BasicTypeInfo.STRING_TYPE_INFO, (Object)ti);
    }

    public static class MapWithResultTypeQueryable
    implements MapFunction,
    ResultTypeQueryable {
        private static final long serialVersionUID = 1L;

        public TypeInformation getProducedType() {
            return BasicTypeInfo.STRING_TYPE_INFO;
        }

        public Object map(Object value) throws Exception {
            return null;
        }
    }

    public static class MapperWithMultiDimGenericArray<T>
    implements MapFunction<T[][][], Tuple1<T>[][][]> {
        private static final long serialVersionUID = 1L;

        public Tuple1<T>[][][] map(T[][][] value) throws Exception {
            return null;
        }
    }

    public static enum MyEnum {
        ONE,
        TWO,
        THREE;

    }

    public static class EdgeMapper4<K, V>
    implements MapFunction<Edge<K, V>[], V> {
        private static final long serialVersionUID = 1L;

        public V map(Edge<K, V>[] value) throws Exception {
            return null;
        }
    }

    public static class EdgeMapper3<K, V>
    implements MapFunction<Edge<K, V>, V> {
        private static final long serialVersionUID = 1L;

        public V map(Edge<K, V> value) throws Exception {
            return null;
        }
    }

    public static class EdgeMapper2<V>
    implements MapFunction<V, Edge<Long, V>> {
        private static final long serialVersionUID = 1L;

        public Edge<Long, V> map(V value) throws Exception {
            return null;
        }
    }

    public static class EdgeMapper<K, V>
    implements MapFunction<Edge<K, V>, Edge<K, V>> {
        private static final long serialVersionUID = 1L;

        public Edge<K, V> map(Edge<K, V> value) throws Exception {
            return null;
        }
    }

    public static class Edge<K, V>
    extends Tuple3<K, K, V> {
        private static final long serialVersionUID = 1L;
    }

    public static class DuplicateValueNested<T>
    implements MapFunction<Tuple1<Tuple1<T>>, Tuple2<T, T>> {
        private static final long serialVersionUID = 1L;

        public Tuple2<T, T> map(Tuple1<Tuple1<T>> vertex) {
            return new Tuple2(null, null);
        }
    }

    public static class DuplicateValue<T>
    implements MapFunction<Tuple1<T>, Tuple2<T, T>> {
        private static final long serialVersionUID = 1L;

        public Tuple2<T, T> map(Tuple1<T> vertex) {
            return new Tuple2(vertex.f0, vertex.f0);
        }
    }

    public static class MyQueryableMapper<A>
    extends RichMapFunction<String, A>
    implements ResultTypeQueryable<A> {
        private static final long serialVersionUID = 1L;

        public TypeInformation<A> getProducedType() {
            return BasicTypeInfo.INT_TYPE_INFO;
        }

        public A map(String value) throws Exception {
            return null;
        }
    }

    public static class DummyFlatMapFunction<A, B, C, D>
    extends RichFlatMapFunction<Tuple2<A, B>, Tuple2<C, D>> {
        private static final long serialVersionUID = 1L;

        public void flatMap(Tuple2<A, B> value, Collector<Tuple2<C, D>> out) throws Exception {
        }
    }

    public static class InType
    extends MyObject<String> {
    }

    public static class MyObject<T> {
        public T myField;
    }

    public class GenericArrayClass<T>
    extends RichMapFunction<T[], T[]> {
        private static final long serialVersionUID = 1L;

        public T[] map(T[] value) throws Exception {
            return null;
        }
    }

    public class CustomArrayObject2<F>
    extends Tuple1<F> {
        private static final long serialVersionUID = 1L;
    }

    public static class CustomArrayObject {
    }

    public static abstract class AbstractClassWithMember {
        public int x;
    }

    public static abstract class AbstractClassWithoutMember {
    }

    public static interface Testable {
    }

    public class FieldDuplicator<T>
    extends RichMapFunction<T, Tuple2<T, T>> {
        private static final long serialVersionUID = 1L;

        public Tuple2<T, T> map(T value) {
            return new Tuple2(value, value);
        }
    }

    public class OneAppender<T>
    extends RichMapFunction<T, Tuple2<T, Integer>> {
        private static final long serialVersionUID = 1L;

        public Tuple2<T, Integer> map(T value) {
            return new Tuple2(value, (Object)1);
        }
    }

    public class Mapper2
    extends Mapper {
        private static final long serialVersionUID = 1L;

        @Override
        public String map(String value) throws Exception {
            return null;
        }
    }

    public class Mapper
    extends IdentityMapper<String> {
        private static final long serialVersionUID = 1L;

        @Override
        public String map(String value) throws Exception {
            return null;
        }
    }

    public class IdentityMapper5<D>
    extends IdentityMapper<Tuple2<D, D>> {
        private static final long serialVersionUID = 1L;
    }

    public class IdentityMapper4<D>
    extends IdentityMapper<D> {
        private static final long serialVersionUID = 1L;
    }

    public class IdentityMapper3<T, V>
    extends RichMapFunction<T, V> {
        private static final long serialVersionUID = 1L;

        public V map(T value) throws Exception {
            return null;
        }
    }

    public class IdentityMapper2<T>
    extends RichMapFunction<Tuple2<T, String>, T> {
        private static final long serialVersionUID = 1L;

        public T map(Tuple2<T, String> value) throws Exception {
            return null;
        }
    }

    public class IdentityMapper<T>
    extends RichMapFunction<T, T> {
        private static final long serialVersionUID = 1L;

        public T map(T value) throws Exception {
            return null;
        }
    }

    public static class Nested2<T>
    extends Nested<T, Nested<Integer, T>> {
        private static final long serialVersionUID = 1L;

        public Nested2(T field0, Tuple2<Nested<Integer, T>, Nested<Integer, T>> field1) {
            super(field0, field1);
        }
    }

    public static class Nested<V, T>
    extends Tuple2<V, Tuple2<T, T>> {
        private static final long serialVersionUID = 1L;

        public Nested(V field0, Tuple2<T, T> field1) {
            super(field0, field1);
        }
    }

    public static class SameTypeVariable<X>
    extends Tuple2<X, X> {
        private static final long serialVersionUID = 1L;

        public SameTypeVariable(X field0, X field1) {
            super(field0, field1);
        }
    }

    public static class ChainedFour
    extends ChainedThree {
        private static final long serialVersionUID = 1L;

        public ChainedFour(String field0, Long field1, String field2) {
            super(field0, field1, field2);
        }
    }

    public static class ChainedThree
    extends ChainedTwo<String> {
        private static final long serialVersionUID = 1L;

        public ChainedThree(String field0, Long field1, String field2) {
            super(field0, field1, field2);
        }
    }

    public static class ChainedTwo<V>
    extends ChainedOne<String, V> {
        private static final long serialVersionUID = 1L;

        public ChainedTwo(String field0, Long field1, V field2) {
            super(field0, field1, field2);
        }
    }

    public static class ChainedOne<X, Y>
    extends Tuple3<X, Long, Y> {
        private static final long serialVersionUID = 1L;

        public ChainedOne(X field0, Long field1, Y field2) {
            this.f0 = field0;
            this.f1 = field1;
            this.f2 = field2;
        }
    }

    public static class LongKeyValue<V>
    extends Tuple2<Long, V> {
        private static final long serialVersionUID = 1L;

        public LongKeyValue(Long field1, V field2) {
            this.f0 = field1;
            this.f1 = field2;
        }
    }

    public static class CustomType {
        public String myField1;
        public int myField2;

        public CustomType() {
        }

        public CustomType(String myField1, int myField2) {
            this.myField1 = myField1;
            this.myField2 = myField2;
        }
    }

    public static class PojoWithNonPublicDefaultCtor {
        public int foo;
        public int bar;

        PojoWithNonPublicDefaultCtor() {
        }
    }

    public static class CustomTuple
    extends Tuple2<String, Integer> {
        private static final long serialVersionUID = 1L;

        public CustomTuple(String myField1, Integer myField2) {
            this.setFields(myField1, myField2);
        }

        public String getMyField1() {
            return (String)this.f0;
        }

        public int getMyField2() {
            return (Integer)this.f1;
        }
    }

    public static class MyWritable
    implements Writable {
        public void write(DataOutput out) throws IOException {
        }

        public void readFields(DataInput in) throws IOException {
        }
    }
}

