/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.operators.translation;

import java.io.Serializable;
import org.apache.flink.api.common.functions.ReduceFunction;
import org.apache.flink.api.common.functions.RichReduceFunction;
import org.apache.flink.api.common.io.OutputFormat;
import org.apache.flink.api.common.operators.GenericDataSinkBase;
import org.apache.flink.api.common.operators.GenericDataSourceBase;
import org.apache.flink.api.common.operators.base.MapOperatorBase;
import org.apache.flink.api.common.operators.base.ReduceOperatorBase;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.DataSet;
import org.apache.flink.api.java.ExecutionEnvironment;
import org.apache.flink.api.java.LocalEnvironment;
import org.apache.flink.api.java.functions.KeySelector;
import org.apache.flink.api.java.io.DiscardingOutputFormat;
import org.apache.flink.api.java.operators.ReduceOperator;
import org.apache.flink.api.java.operators.translation.JavaPlan;
import org.apache.flink.api.java.operators.translation.KeyExtractingMapper;
import org.apache.flink.api.java.operators.translation.PlanUnwrappingReduceOperator;
import org.apache.flink.api.java.tuple.Tuple3;
import org.apache.flink.api.java.typeutils.TupleTypeInfo;
import org.apache.flink.api.java.typeutils.ValueTypeInfo;
import org.apache.flink.types.LongValue;
import org.apache.flink.types.StringValue;
import org.junit.Assert;
import org.junit.Test;

public class ReduceTranslationTests
implements Serializable {
    @Test
    public void translateNonGroupedReduce() {
        try {
            int parallelism = 8;
            LocalEnvironment env = ExecutionEnvironment.createLocalEnvironment((int)8);
            DataSet<Tuple3<Double, StringValue, LongValue>> initialData = ReduceTranslationTests.getSourceDataSet((ExecutionEnvironment)env);
            initialData.reduce((ReduceFunction)new RichReduceFunction<Tuple3<Double, StringValue, LongValue>>(){

                public Tuple3<Double, StringValue, LongValue> reduce(Tuple3<Double, StringValue, LongValue> value1, Tuple3<Double, StringValue, LongValue> value2) {
                    return value1;
                }
            }).output((OutputFormat)new DiscardingOutputFormat());
            JavaPlan p = env.createProgramPlan();
            GenericDataSinkBase sink = (GenericDataSinkBase)p.getDataSinks().iterator().next();
            ReduceOperatorBase reducer = (ReduceOperatorBase)sink.getInput();
            Assert.assertEquals((Object)initialData.getType(), (Object)reducer.getOperatorInfo().getInputType());
            Assert.assertEquals((Object)initialData.getType(), (Object)reducer.getOperatorInfo().getOutputType());
            Assert.assertTrue((reducer.getKeyColumns(0) == null || reducer.getKeyColumns(0).length == 0 ? 1 : 0) != 0);
            Assert.assertTrue((reducer.getParallelism() == 1 || reducer.getParallelism() == -1 ? 1 : 0) != 0);
            Assert.assertTrue((boolean)(reducer.getInput() instanceof GenericDataSourceBase));
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            e.printStackTrace();
            Assert.fail((String)("Test caused an error: " + e.getMessage()));
        }
    }

    @Test
    public void translateGroupedReduceNoMapper() {
        try {
            int parallelism = 8;
            LocalEnvironment env = ExecutionEnvironment.createLocalEnvironment((int)8);
            DataSet<Tuple3<Double, StringValue, LongValue>> initialData = ReduceTranslationTests.getSourceDataSet((ExecutionEnvironment)env);
            initialData.groupBy(new int[]{2}).reduce((ReduceFunction)new RichReduceFunction<Tuple3<Double, StringValue, LongValue>>(){

                public Tuple3<Double, StringValue, LongValue> reduce(Tuple3<Double, StringValue, LongValue> value1, Tuple3<Double, StringValue, LongValue> value2) {
                    return value1;
                }
            }).output((OutputFormat)new DiscardingOutputFormat());
            JavaPlan p = env.createProgramPlan();
            GenericDataSinkBase sink = (GenericDataSinkBase)p.getDataSinks().iterator().next();
            ReduceOperatorBase reducer = (ReduceOperatorBase)sink.getInput();
            Assert.assertEquals((Object)initialData.getType(), (Object)reducer.getOperatorInfo().getInputType());
            Assert.assertEquals((Object)initialData.getType(), (Object)reducer.getOperatorInfo().getOutputType());
            Assert.assertTrue((reducer.getParallelism() == 8 || reducer.getParallelism() == -1 ? 1 : 0) != 0);
            Assert.assertArrayEquals((int[])new int[]{2}, (int[])reducer.getKeyColumns(0));
            Assert.assertTrue((boolean)(reducer.getInput() instanceof GenericDataSourceBase));
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            e.printStackTrace();
            Assert.fail((String)("Test caused an error: " + e.getMessage()));
        }
    }

    @Test
    public void translateGroupedReduceWithkeyExtractor() {
        try {
            int parallelism = 8;
            LocalEnvironment env = ExecutionEnvironment.createLocalEnvironment((int)8);
            DataSet<Tuple3<Double, StringValue, LongValue>> initialData = ReduceTranslationTests.getSourceDataSet((ExecutionEnvironment)env);
            ((ReduceOperator)initialData.groupBy((KeySelector)new KeySelector<Tuple3<Double, StringValue, LongValue>, StringValue>(){

                public StringValue getKey(Tuple3<Double, StringValue, LongValue> value) {
                    return (StringValue)value.f1;
                }
            }).reduce((ReduceFunction)new RichReduceFunction<Tuple3<Double, StringValue, LongValue>>(){

                public Tuple3<Double, StringValue, LongValue> reduce(Tuple3<Double, StringValue, LongValue> value1, Tuple3<Double, StringValue, LongValue> value2) {
                    return value1;
                }
            }).setParallelism(4)).output((OutputFormat)new DiscardingOutputFormat());
            JavaPlan p = env.createProgramPlan();
            GenericDataSinkBase sink = (GenericDataSinkBase)p.getDataSinks().iterator().next();
            MapOperatorBase keyProjector = (MapOperatorBase)sink.getInput();
            PlanUnwrappingReduceOperator reducer = (PlanUnwrappingReduceOperator)keyProjector.getInput();
            MapOperatorBase keyExtractor = (MapOperatorBase)reducer.getInput();
            Assert.assertEquals((long)1L, (long)keyExtractor.getParallelism());
            Assert.assertEquals((long)4L, (long)reducer.getParallelism());
            Assert.assertEquals((long)4L, (long)keyProjector.getParallelism());
            TupleTypeInfo keyValueInfo = new TupleTypeInfo(new TypeInformation[]{new ValueTypeInfo(StringValue.class), initialData.getType()});
            Assert.assertEquals((Object)initialData.getType(), (Object)keyExtractor.getOperatorInfo().getInputType());
            Assert.assertEquals((Object)keyValueInfo, (Object)keyExtractor.getOperatorInfo().getOutputType());
            Assert.assertEquals((Object)keyValueInfo, (Object)reducer.getOperatorInfo().getInputType());
            Assert.assertEquals((Object)keyValueInfo, (Object)reducer.getOperatorInfo().getOutputType());
            Assert.assertEquals((Object)keyValueInfo, (Object)keyProjector.getOperatorInfo().getInputType());
            Assert.assertEquals((Object)initialData.getType(), (Object)keyProjector.getOperatorInfo().getOutputType());
            Assert.assertEquals(KeyExtractingMapper.class, (Object)keyExtractor.getUserCodeWrapper().getUserCodeClass());
            Assert.assertTrue((boolean)(keyExtractor.getInput() instanceof GenericDataSourceBase));
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            e.printStackTrace();
            Assert.fail((String)("Test caused an error: " + e.getMessage()));
        }
    }

    private static final DataSet<Tuple3<Double, StringValue, LongValue>> getSourceDataSet(ExecutionEnvironment env) {
        return env.fromElements((Object[])new Tuple3[]{new Tuple3((Object)3.141592, (Object)new StringValue((CharSequence)"foobar"), (Object)new LongValue(77L))}).setParallelism(1);
    }
}

