/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.operators.translation;

import java.io.Serializable;
import java.util.ArrayList;
import org.apache.flink.api.common.io.OutputFormat;
import org.apache.flink.api.common.operators.GenericDataSinkBase;
import org.apache.flink.api.common.operators.GenericDataSourceBase;
import org.apache.flink.api.common.operators.base.GroupReduceOperatorBase;
import org.apache.flink.api.common.operators.base.MapOperatorBase;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.DataSet;
import org.apache.flink.api.java.ExecutionEnvironment;
import org.apache.flink.api.java.LocalEnvironment;
import org.apache.flink.api.java.functions.KeySelector;
import org.apache.flink.api.java.io.DiscardingOutputFormat;
import org.apache.flink.api.java.operators.DataSource;
import org.apache.flink.api.java.operators.DistinctOperator;
import org.apache.flink.api.java.operators.translation.JavaPlan;
import org.apache.flink.api.java.operators.translation.KeyExtractingMapper;
import org.apache.flink.api.java.operators.translation.PlanUnwrappingReduceGroupOperator;
import org.apache.flink.api.java.tuple.Tuple3;
import org.apache.flink.api.java.typeutils.TupleTypeInfo;
import org.apache.flink.api.java.typeutils.ValueTypeInfo;
import org.apache.flink.types.LongValue;
import org.apache.flink.types.StringValue;
import org.junit.Assert;
import org.junit.Test;

public class DistinctTranslationTest {
    @Test
    public void testCombinable() {
        try {
            ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
            DataSource input = env.fromElements((Object[])new String[]{"1", "2", "1", "3"});
            DistinctOperator op = input.distinct((KeySelector)new KeySelector<String, String>(){

                public String getKey(String value) {
                    return value;
                }
            });
            op.output((OutputFormat)new DiscardingOutputFormat());
            JavaPlan p = env.createProgramPlan();
            GroupReduceOperatorBase reduceOp = (GroupReduceOperatorBase)((GenericDataSinkBase)p.getDataSinks().iterator().next()).getInput();
            Assert.assertTrue((boolean)reduceOp.isCombinable());
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void translateDistinctPlain() {
        try {
            int parallelism = 8;
            LocalEnvironment env = ExecutionEnvironment.createLocalEnvironment((int)8);
            DataSet<Tuple3<Double, StringValue, LongValue>> initialData = DistinctTranslationTest.getSourceDataSet((ExecutionEnvironment)env);
            initialData.distinct().output((OutputFormat)new DiscardingOutputFormat());
            JavaPlan p = env.createProgramPlan();
            GenericDataSinkBase sink = (GenericDataSinkBase)p.getDataSinks().iterator().next();
            GroupReduceOperatorBase reducer = (GroupReduceOperatorBase)sink.getInput();
            Assert.assertEquals((Object)initialData.getType(), (Object)reducer.getOperatorInfo().getInputType());
            Assert.assertEquals((Object)initialData.getType(), (Object)reducer.getOperatorInfo().getOutputType());
            Assert.assertArrayEquals((int[])new int[]{0, 1, 2}, (int[])reducer.getKeyColumns(0));
            Assert.assertTrue((reducer.getParallelism() == 1 || reducer.getParallelism() == -1 ? 1 : 0) != 0);
            Assert.assertTrue((boolean)(reducer.getInput() instanceof GenericDataSourceBase));
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            e.printStackTrace();
            Assert.fail((String)("Test caused an error: " + e.getMessage()));
        }
    }

    @Test
    public void translateDistinctPlain2() {
        try {
            int parallelism = 8;
            LocalEnvironment env = ExecutionEnvironment.createLocalEnvironment((int)8);
            DataSet<CustomType> initialData = DistinctTranslationTest.getSourcePojoDataSet((ExecutionEnvironment)env);
            initialData.distinct().output((OutputFormat)new DiscardingOutputFormat());
            JavaPlan p = env.createProgramPlan();
            GenericDataSinkBase sink = (GenericDataSinkBase)p.getDataSinks().iterator().next();
            GroupReduceOperatorBase reducer = (GroupReduceOperatorBase)sink.getInput();
            Assert.assertEquals((Object)initialData.getType(), (Object)reducer.getOperatorInfo().getInputType());
            Assert.assertEquals((Object)initialData.getType(), (Object)reducer.getOperatorInfo().getOutputType());
            Assert.assertArrayEquals((int[])new int[]{0}, (int[])reducer.getKeyColumns(0));
            Assert.assertTrue((reducer.getParallelism() == 1 || reducer.getParallelism() == -1 ? 1 : 0) != 0);
            Assert.assertTrue((boolean)(reducer.getInput() instanceof GenericDataSourceBase));
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            e.printStackTrace();
            Assert.fail((String)("Test caused an error: " + e.getMessage()));
        }
    }

    @Test
    public void translateDistinctPosition() {
        try {
            int parallelism = 8;
            LocalEnvironment env = ExecutionEnvironment.createLocalEnvironment((int)8);
            DataSet<Tuple3<Double, StringValue, LongValue>> initialData = DistinctTranslationTest.getSourceDataSet((ExecutionEnvironment)env);
            initialData.distinct(new int[]{1, 2}).output((OutputFormat)new DiscardingOutputFormat());
            JavaPlan p = env.createProgramPlan();
            GenericDataSinkBase sink = (GenericDataSinkBase)p.getDataSinks().iterator().next();
            GroupReduceOperatorBase reducer = (GroupReduceOperatorBase)sink.getInput();
            Assert.assertEquals((Object)initialData.getType(), (Object)reducer.getOperatorInfo().getInputType());
            Assert.assertEquals((Object)initialData.getType(), (Object)reducer.getOperatorInfo().getOutputType());
            Assert.assertArrayEquals((int[])new int[]{1, 2}, (int[])reducer.getKeyColumns(0));
            Assert.assertTrue((reducer.getParallelism() == 1 || reducer.getParallelism() == -1 ? 1 : 0) != 0);
            Assert.assertTrue((boolean)(reducer.getInput() instanceof GenericDataSourceBase));
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            e.printStackTrace();
            Assert.fail((String)("Test caused an error: " + e.getMessage()));
        }
    }

    @Test
    public void translateDistinctKeySelector() {
        try {
            int parallelism = 8;
            LocalEnvironment env = ExecutionEnvironment.createLocalEnvironment((int)8);
            DataSet<Tuple3<Double, StringValue, LongValue>> initialData = DistinctTranslationTest.getSourceDataSet((ExecutionEnvironment)env);
            ((DistinctOperator)initialData.distinct((KeySelector)new KeySelector<Tuple3<Double, StringValue, LongValue>, StringValue>(){

                public StringValue getKey(Tuple3<Double, StringValue, LongValue> value) {
                    return (StringValue)value.f1;
                }
            }).setParallelism(4)).output((OutputFormat)new DiscardingOutputFormat());
            JavaPlan p = env.createProgramPlan();
            GenericDataSinkBase sink = (GenericDataSinkBase)p.getDataSinks().iterator().next();
            PlanUnwrappingReduceGroupOperator reducer = (PlanUnwrappingReduceGroupOperator)sink.getInput();
            MapOperatorBase keyExtractor = (MapOperatorBase)reducer.getInput();
            Assert.assertEquals((long)1L, (long)keyExtractor.getParallelism());
            Assert.assertEquals((long)4L, (long)reducer.getParallelism());
            TupleTypeInfo keyValueInfo = new TupleTypeInfo(new TypeInformation[]{new ValueTypeInfo(StringValue.class), initialData.getType()});
            Assert.assertEquals((Object)initialData.getType(), (Object)keyExtractor.getOperatorInfo().getInputType());
            Assert.assertEquals((Object)keyValueInfo, (Object)keyExtractor.getOperatorInfo().getOutputType());
            Assert.assertEquals((Object)keyValueInfo, (Object)reducer.getOperatorInfo().getInputType());
            Assert.assertEquals((Object)initialData.getType(), (Object)reducer.getOperatorInfo().getOutputType());
            Assert.assertEquals(KeyExtractingMapper.class, (Object)keyExtractor.getUserCodeWrapper().getUserCodeClass());
            Assert.assertTrue((boolean)(keyExtractor.getInput() instanceof GenericDataSourceBase));
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            e.printStackTrace();
            Assert.fail((String)("Test caused an error: " + e.getMessage()));
        }
    }

    @Test
    public void translateDistinctExpressionKey() {
        try {
            int parallelism = 8;
            LocalEnvironment env = ExecutionEnvironment.createLocalEnvironment((int)8);
            DataSet<CustomType> initialData = DistinctTranslationTest.getSourcePojoDataSet((ExecutionEnvironment)env);
            initialData.distinct(new String[]{"myInt"}).output((OutputFormat)new DiscardingOutputFormat());
            JavaPlan p = env.createProgramPlan();
            GenericDataSinkBase sink = (GenericDataSinkBase)p.getDataSinks().iterator().next();
            GroupReduceOperatorBase reducer = (GroupReduceOperatorBase)sink.getInput();
            Assert.assertEquals((Object)initialData.getType(), (Object)reducer.getOperatorInfo().getInputType());
            Assert.assertEquals((Object)initialData.getType(), (Object)reducer.getOperatorInfo().getOutputType());
            Assert.assertArrayEquals((int[])new int[]{0}, (int[])reducer.getKeyColumns(0));
            Assert.assertTrue((reducer.getParallelism() == 1 || reducer.getParallelism() == -1 ? 1 : 0) != 0);
            Assert.assertTrue((boolean)(reducer.getInput() instanceof GenericDataSourceBase));
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            e.printStackTrace();
            Assert.fail((String)("Test caused an error: " + e.getMessage()));
        }
    }

    private static final DataSet<Tuple3<Double, StringValue, LongValue>> getSourceDataSet(ExecutionEnvironment env) {
        return env.fromElements((Object[])new Tuple3[]{new Tuple3((Object)3.141592, (Object)new StringValue((CharSequence)"foobar"), (Object)new LongValue(77L))}).setParallelism(1);
    }

    private static DataSet<CustomType> getSourcePojoDataSet(ExecutionEnvironment env) {
        ArrayList<CustomType> data = new ArrayList<CustomType>();
        data.add(new CustomType(1));
        return env.fromCollection(data);
    }

    public static class CustomType
    implements Serializable {
        private static final long serialVersionUID = 1L;
        public int myInt;

        public CustomType() {
        }

        public CustomType(int i) {
            this.myInt = i;
        }

        public String toString() {
            return "" + this.myInt;
        }
    }
}

