/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.operators.translation;

import java.io.Serializable;
import java.util.Iterator;
import org.apache.flink.api.common.InvalidProgramException;
import org.apache.flink.api.common.aggregators.Aggregator;
import org.apache.flink.api.common.aggregators.AggregatorWithName;
import org.apache.flink.api.common.aggregators.LongSumAggregator;
import org.apache.flink.api.common.functions.CoGroupFunction;
import org.apache.flink.api.common.functions.JoinFunction;
import org.apache.flink.api.common.functions.MapFunction;
import org.apache.flink.api.common.functions.RichCoGroupFunction;
import org.apache.flink.api.common.functions.RichJoinFunction;
import org.apache.flink.api.common.functions.RichMapFunction;
import org.apache.flink.api.common.io.OutputFormat;
import org.apache.flink.api.common.operators.GenericDataSinkBase;
import org.apache.flink.api.common.operators.base.DeltaIterationBase;
import org.apache.flink.api.common.operators.base.InnerJoinOperatorBase;
import org.apache.flink.api.common.operators.base.MapOperatorBase;
import org.apache.flink.api.java.DataSet;
import org.apache.flink.api.java.ExecutionEnvironment;
import org.apache.flink.api.java.io.DiscardingOutputFormat;
import org.apache.flink.api.java.operators.DataSource;
import org.apache.flink.api.java.operators.DeltaIteration;
import org.apache.flink.api.java.operators.JoinOperator;
import org.apache.flink.api.java.operators.translation.JavaPlan;
import org.apache.flink.api.java.operators.translation.WrappingFunction;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.api.java.tuple.Tuple3;
import org.apache.flink.util.Collector;
import org.junit.Assert;
import org.junit.Test;

public class DeltaIterationTranslationTest
implements Serializable {
    @Test
    public void testCorrectTranslation() {
        try {
            String JOB_NAME = "Test JobName";
            String ITERATION_NAME = "Test Name";
            String BEFORE_NEXT_WORKSET_MAP = "Some Mapper";
            String AGGREGATOR_NAME = "AggregatorName";
            int[] ITERATION_KEYS = new int[]{2};
            int NUM_ITERATIONS = 13;
            int DEFAULT_parallelism = 133;
            int ITERATION_parallelism = 77;
            ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
            env.setParallelism(133);
            DataSource initialSolutionSet = env.fromElements((Object[])new Tuple3[]{new Tuple3((Object)3.44, (Object)5L, (Object)"abc")});
            DataSource initialWorkSet = env.fromElements((Object[])new Tuple2[]{new Tuple2((Object)1.23, (Object)"abc")});
            DeltaIteration iteration = initialSolutionSet.iterateDelta((DataSet)initialWorkSet, 13, ITERATION_KEYS);
            iteration.name("Test Name").parallelism(77);
            iteration.registerAggregator("AggregatorName", (Aggregator)new LongSumAggregator());
            JoinOperator.ProjectJoin worksetSelfJoin = iteration.getWorkset().map(new IdentityMapper()).join((DataSet)iteration.getWorkset()).where(new int[]{1}).equalTo(new int[]{1}).projectFirst(new int[]{0, 1});
            JoinOperator.EquiJoin joined = worksetSelfJoin.join((DataSet)iteration.getSolutionSet()).where(new int[]{1}).equalTo(new int[]{2}).with((JoinFunction)new SolutionWorksetJoin());
            DataSet result = iteration.closeWith((DataSet)joined, (DataSet)joined.map((MapFunction)new NextWorksetMapper()).name("Some Mapper"));
            result.output((OutputFormat)new DiscardingOutputFormat());
            result.writeAsText("/dev/null");
            JavaPlan p = env.createProgramPlan("Test JobName");
            Assert.assertEquals((Object)"Test JobName", (Object)p.getJobName());
            Assert.assertEquals((long)133L, (long)p.getDefaultParallelism());
            Iterator sinks = p.getDataSinks().iterator();
            GenericDataSinkBase sink1 = (GenericDataSinkBase)sinks.next();
            GenericDataSinkBase sink2 = (GenericDataSinkBase)sinks.next();
            DeltaIterationBase iteration2 = (DeltaIterationBase)sink1.getInput();
            Assert.assertEquals((Object)iteration2, (Object)sink2.getInput());
            Assert.assertEquals((long)13L, (long)iteration2.getMaximumNumberOfIterations());
            Assert.assertArrayEquals((int[])ITERATION_KEYS, (int[])iteration2.getSolutionSetKeyFields());
            Assert.assertEquals((long)77L, (long)iteration2.getParallelism());
            Assert.assertEquals((Object)"Test Name", (Object)iteration2.getName());
            MapOperatorBase nextWorksetMapper = (MapOperatorBase)iteration2.getNextWorkset();
            InnerJoinOperatorBase solutionSetJoin = (InnerJoinOperatorBase)iteration2.getSolutionSetDelta();
            InnerJoinOperatorBase worksetSelfJoin2 = (InnerJoinOperatorBase)solutionSetJoin.getFirstInput();
            MapOperatorBase worksetMapper = (MapOperatorBase)worksetSelfJoin2.getFirstInput();
            Assert.assertEquals(IdentityMapper.class, (Object)worksetMapper.getUserCodeWrapper().getUserCodeClass());
            Assert.assertEquals(NextWorksetMapper.class, (Object)nextWorksetMapper.getUserCodeWrapper().getUserCodeClass());
            if (solutionSetJoin.getUserCodeWrapper().getUserCodeObject() instanceof WrappingFunction) {
                WrappingFunction wf = (WrappingFunction)solutionSetJoin.getUserCodeWrapper().getUserCodeObject();
                Assert.assertEquals(SolutionWorksetJoin.class, wf.getWrappedFunction().getClass());
            } else {
                Assert.assertEquals(SolutionWorksetJoin.class, (Object)solutionSetJoin.getUserCodeWrapper().getUserCodeClass());
            }
            Assert.assertEquals((Object)"Some Mapper", (Object)nextWorksetMapper.getName());
            Assert.assertEquals((Object)"AggregatorName", (Object)((AggregatorWithName)iteration2.getAggregators().getAllRegisteredAggregators().iterator().next()).getName());
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testRejectWhenSolutionSetKeysDontMatchJoin() {
        try {
            ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
            DataSource initialSolutionSet = env.fromElements((Object[])new Tuple3[]{new Tuple3((Object)3.44, (Object)5L, (Object)"abc")});
            DataSource initialWorkSet = env.fromElements((Object[])new Tuple2[]{new Tuple2((Object)1.23, (Object)"abc")});
            DeltaIteration iteration = initialSolutionSet.iterateDelta((DataSet)initialWorkSet, 10, new int[]{1});
            try {
                iteration.getWorkset().join((DataSet)iteration.getSolutionSet()).where(new int[]{1}).equalTo(new int[]{2});
                Assert.fail((String)"Accepted invalid program.");
            }
            catch (InvalidProgramException invalidProgramException) {
                // empty catch block
            }
            try {
                iteration.getSolutionSet().join((DataSet)iteration.getWorkset()).where(new int[]{2}).equalTo(new int[]{1});
                Assert.fail((String)"Accepted invalid program.");
            }
            catch (InvalidProgramException invalidProgramException) {}
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testRejectWhenSolutionSetKeysDontMatchCoGroup() {
        try {
            ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
            DataSource initialSolutionSet = env.fromElements((Object[])new Tuple3[]{new Tuple3((Object)3.44, (Object)5L, (Object)"abc")});
            DataSource initialWorkSet = env.fromElements((Object[])new Tuple2[]{new Tuple2((Object)1.23, (Object)"abc")});
            DeltaIteration iteration = initialSolutionSet.iterateDelta((DataSet)initialWorkSet, 10, new int[]{1});
            try {
                iteration.getWorkset().coGroup((DataSet)iteration.getSolutionSet()).where(new int[]{1}).equalTo(new int[]{2}).with((CoGroupFunction)new SolutionWorksetCoGroup1());
                Assert.fail((String)"Accepted invalid program.");
            }
            catch (InvalidProgramException invalidProgramException) {
                // empty catch block
            }
            try {
                iteration.getSolutionSet().coGroup((DataSet)iteration.getWorkset()).where(new int[]{2}).equalTo(new int[]{1}).with((CoGroupFunction)new SolutionWorksetCoGroup2());
                Assert.fail((String)"Accepted invalid program.");
            }
            catch (InvalidProgramException invalidProgramException) {}
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    public static class SolutionWorksetCoGroup2
    extends RichCoGroupFunction<Tuple3<Double, Long, String>, Tuple2<Double, String>, Tuple3<Double, Long, String>> {
        public void coGroup(Iterable<Tuple3<Double, Long, String>> second, Iterable<Tuple2<Double, String>> first, Collector<Tuple3<Double, Long, String>> out) {
        }
    }

    public static class SolutionWorksetCoGroup1
    extends RichCoGroupFunction<Tuple2<Double, String>, Tuple3<Double, Long, String>, Tuple3<Double, Long, String>> {
        public void coGroup(Iterable<Tuple2<Double, String>> first, Iterable<Tuple3<Double, Long, String>> second, Collector<Tuple3<Double, Long, String>> out) {
        }
    }

    public static class IdentityMapper<T>
    extends RichMapFunction<T, T> {
        public T map(T value) throws Exception {
            return value;
        }
    }

    public static class NextWorksetMapper
    extends RichMapFunction<Tuple3<Double, Long, String>, Tuple2<Double, String>> {
        public Tuple2<Double, String> map(Tuple3<Double, Long, String> value) {
            return null;
        }
    }

    public static class SolutionWorksetJoin
    extends RichJoinFunction<Tuple2<Double, String>, Tuple3<Double, Long, String>, Tuple3<Double, Long, String>> {
        public Tuple3<Double, Long, String> join(Tuple2<Double, String> first, Tuple3<Double, Long, String> second) {
            return null;
        }
    }
}

