/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.operators;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.flink.api.common.typeinfo.BasicTypeInfo;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.operators.Keys;
import org.apache.flink.api.java.type.extractor.PojoTypeExtractionTest;
import org.apache.flink.api.java.typeutils.TupleTypeInfo;
import org.apache.flink.api.java.typeutils.TypeExtractor;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.powermock.modules.junit4.PowerMockRunner;
import org.powermock.reflect.Whitebox;

@RunWith(value=PowerMockRunner.class)
public class KeysTest {
    @Test
    public void testTupleRangeCheck() throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        Method rangeCheckFieldsMethod = Whitebox.getMethod(Keys.class, (String)"rangeCheckFields", (Class[])new Class[]{int[].class, Integer.TYPE});
        int[] result = (int[])rangeCheckFieldsMethod.invoke(null, new int[]{1, 2, 3, 4}, 4);
        Assert.assertArrayEquals((int[])new int[]{1, 2, 3, 4}, (int[])result);
        result = (int[])rangeCheckFieldsMethod.invoke(null, new int[]{1, 2, 2, 3, 4}, 4);
        Assert.assertArrayEquals((int[])new int[]{1, 2, 3, 4}, (int[])result);
        result = (int[])rangeCheckFieldsMethod.invoke(null, new int[]{1, 2, 2, 2, 2, 2, 2, 3, 3, 4}, 4);
        Assert.assertArrayEquals((int[])new int[]{1, 2, 3, 4}, (int[])result);
        result = (int[])rangeCheckFieldsMethod.invoke(null, new int[]{0}, 0);
        Assert.assertArrayEquals((int[])new int[]{0}, (int[])result);
        Throwable ex = null;
        try {
            result = (int[])rangeCheckFieldsMethod.invoke(null, new int[]{5}, 0);
        }
        catch (Throwable iae) {
            ex = iae;
        }
        Assert.assertNotNull((Object)ex);
    }

    @Test
    public void testStandardTupleKeys() {
        TupleTypeInfo typeInfo = new TupleTypeInfo(new TypeInformation[]{BasicTypeInfo.STRING_TYPE_INFO, BasicTypeInfo.STRING_TYPE_INFO, BasicTypeInfo.STRING_TYPE_INFO, BasicTypeInfo.STRING_TYPE_INFO, BasicTypeInfo.STRING_TYPE_INFO, BasicTypeInfo.STRING_TYPE_INFO, BasicTypeInfo.STRING_TYPE_INFO});
        for (int i = 1; i < 8; ++i) {
            int[] ints = new int[i];
            for (int j = 0; j < i; ++j) {
                ints[j] = j;
            }
            int[] inInts = Arrays.copyOf(ints, ints.length);
            Keys.ExpressionKeys ek = new Keys.ExpressionKeys(inInts, (TypeInformation)typeInfo);
            Assert.assertArrayEquals((int[])ints, (int[])ek.computeLogicalKeyPositions());
            Assert.assertEquals((long)ints.length, (long)ek.computeLogicalKeyPositions().length);
            ArrayUtils.reverse((int[])ints);
            inInts = Arrays.copyOf(ints, ints.length);
            ek = new Keys.ExpressionKeys(inInts, (TypeInformation)typeInfo);
            Assert.assertArrayEquals((int[])ints, (int[])ek.computeLogicalKeyPositions());
            Assert.assertEquals((long)ints.length, (long)ek.computeLogicalKeyPositions().length);
        }
    }

    @Test
    public void testInvalidTuple() throws Throwable {
        TupleTypeInfo typeInfo = new TupleTypeInfo(new TypeInformation[]{BasicTypeInfo.STRING_TYPE_INFO, new TupleTypeInfo(new TypeInformation[]{BasicTypeInfo.STRING_TYPE_INFO, BasicTypeInfo.STRING_TYPE_INFO, BasicTypeInfo.STRING_TYPE_INFO}), BasicTypeInfo.STRING_TYPE_INFO});
        String[][] tests = new String[][]{{"f0.f1"}, {"f11"}, {"f-35"}, {"f0.f33"}, {"f1.f33"}};
        for (int i = 0; i < tests.length; ++i) {
            Throwable e = null;
            try {
                new Keys.ExpressionKeys(tests[i], (TypeInformation)typeInfo);
            }
            catch (Throwable t) {
                e = t;
            }
            Assert.assertNotNull((Object)e);
        }
    }

    @Test
    public void testInvalidPojo() throws Throwable {
        TypeInformation ti = TypeExtractor.getForClass(PojoTypeExtractionTest.ComplexNestedClass.class);
        String[][] tests = new String[][]{{"nonexistent"}, {"date.abc"}};
        for (int i = 0; i < tests.length; ++i) {
            Throwable e = null;
            try {
                new Keys.ExpressionKeys(tests[i], ti);
            }
            catch (Throwable t) {
                e = t;
            }
            Assert.assertNotNull((Object)e);
        }
    }

    @Test
    public void testTupleKeyExpansion() {
        TupleTypeInfo typeInfo = new TupleTypeInfo(new TypeInformation[]{BasicTypeInfo.STRING_TYPE_INFO, new TupleTypeInfo(new TypeInformation[]{BasicTypeInfo.STRING_TYPE_INFO, BasicTypeInfo.STRING_TYPE_INFO, BasicTypeInfo.STRING_TYPE_INFO}), BasicTypeInfo.STRING_TYPE_INFO});
        Keys.ExpressionKeys fpk = new Keys.ExpressionKeys(new int[]{0}, (TypeInformation)typeInfo);
        Assert.assertArrayEquals((int[])new int[]{0}, (int[])fpk.computeLogicalKeyPositions());
        fpk = new Keys.ExpressionKeys(new int[]{1}, (TypeInformation)typeInfo);
        Assert.assertArrayEquals((int[])new int[]{1, 2, 3}, (int[])fpk.computeLogicalKeyPositions());
        fpk = new Keys.ExpressionKeys(new int[]{2}, (TypeInformation)typeInfo);
        Assert.assertArrayEquals((int[])new int[]{4}, (int[])fpk.computeLogicalKeyPositions());
        fpk = new Keys.ExpressionKeys(new int[]{0, 1, 2}, (TypeInformation)typeInfo);
        Assert.assertArrayEquals((int[])new int[]{0, 1, 2, 3, 4}, (int[])fpk.computeLogicalKeyPositions());
        fpk = new Keys.ExpressionKeys(null, (TypeInformation)typeInfo, true);
        Assert.assertArrayEquals((int[])new int[]{0, 1, 2, 3, 4}, (int[])fpk.computeLogicalKeyPositions());
        fpk = new Keys.ExpressionKeys(new int[]{0, 1, 1, 1, 2}, (TypeInformation)typeInfo);
        Assert.assertArrayEquals((int[])new int[]{0, 1, 2, 3, 4}, (int[])fpk.computeLogicalKeyPositions());
        fpk = new Keys.ExpressionKeys(new String[]{"*"}, (TypeInformation)typeInfo);
        Assert.assertArrayEquals((int[])new int[]{0, 1, 2, 3, 4}, (int[])fpk.computeLogicalKeyPositions());
        fpk = new Keys.ExpressionKeys(new String[]{"_"}, (TypeInformation)typeInfo);
        Assert.assertArrayEquals((int[])new int[]{0, 1, 2, 3, 4}, (int[])fpk.computeLogicalKeyPositions());
        fpk = new Keys.ExpressionKeys(new String[]{"f2"}, (TypeInformation)typeInfo);
        Assert.assertArrayEquals((int[])new int[]{4}, (int[])fpk.computeLogicalKeyPositions());
        fpk = new Keys.ExpressionKeys(new String[]{"f0", "f1.f0", "f1.f1", "f1.f2", "f2"}, (TypeInformation)typeInfo);
        Assert.assertArrayEquals((int[])new int[]{0, 1, 2, 3, 4}, (int[])fpk.computeLogicalKeyPositions());
        fpk = new Keys.ExpressionKeys(new String[]{"f0", "f1.f0", "f1.f1", "f2"}, (TypeInformation)typeInfo);
        Assert.assertArrayEquals((int[])new int[]{0, 1, 2, 4}, (int[])fpk.computeLogicalKeyPositions());
        fpk = new Keys.ExpressionKeys(new String[]{"f2", "f0"}, (TypeInformation)typeInfo);
        Assert.assertArrayEquals((int[])new int[]{4, 0}, (int[])fpk.computeLogicalKeyPositions());
        fpk = new Keys.ExpressionKeys(new String[]{"f2", "f2", "f2", "f0"}, (TypeInformation)typeInfo);
        Assert.assertArrayEquals((int[])new int[]{4, 0}, (int[])fpk.computeLogicalKeyPositions());
        TupleTypeInfo complexTypeInfo = new TupleTypeInfo(new TypeInformation[]{BasicTypeInfo.STRING_TYPE_INFO, new TupleTypeInfo(new TypeInformation[]{new TupleTypeInfo(new TypeInformation[]{BasicTypeInfo.STRING_TYPE_INFO, BasicTypeInfo.STRING_TYPE_INFO, BasicTypeInfo.STRING_TYPE_INFO}), BasicTypeInfo.STRING_TYPE_INFO, BasicTypeInfo.STRING_TYPE_INFO}), BasicTypeInfo.STRING_TYPE_INFO});
        Keys.ExpressionKeys complexFpk = new Keys.ExpressionKeys(new int[]{0}, (TypeInformation)complexTypeInfo);
        Assert.assertArrayEquals((int[])new int[]{0}, (int[])complexFpk.computeLogicalKeyPositions());
        complexFpk = new Keys.ExpressionKeys(new int[]{0, 1, 2}, (TypeInformation)complexTypeInfo);
        Assert.assertArrayEquals((int[])new int[]{0, 1, 2, 3, 4, 5, 6}, (int[])complexFpk.computeLogicalKeyPositions());
        complexFpk = new Keys.ExpressionKeys(new String[]{"*"}, (TypeInformation)complexTypeInfo);
        Assert.assertArrayEquals((int[])new int[]{0, 1, 2, 3, 4, 5, 6}, (int[])complexFpk.computeLogicalKeyPositions());
        complexFpk = new Keys.ExpressionKeys(new String[]{"_"}, (TypeInformation)complexTypeInfo);
        Assert.assertArrayEquals((int[])new int[]{0, 1, 2, 3, 4, 5, 6}, (int[])complexFpk.computeLogicalKeyPositions());
        complexFpk = new Keys.ExpressionKeys(new String[]{"f1.f0.*"}, (TypeInformation)complexTypeInfo);
        Assert.assertArrayEquals((int[])new int[]{1, 2, 3}, (int[])complexFpk.computeLogicalKeyPositions());
        complexFpk = new Keys.ExpressionKeys(new String[]{"f1.f0"}, (TypeInformation)complexTypeInfo);
        Assert.assertArrayEquals((int[])new int[]{1, 2, 3}, (int[])complexFpk.computeLogicalKeyPositions());
        complexFpk = new Keys.ExpressionKeys(new String[]{"f2"}, (TypeInformation)complexTypeInfo);
        Assert.assertArrayEquals((int[])new int[]{6}, (int[])complexFpk.computeLogicalKeyPositions());
    }

    @Test
    public void testPojoKeys() {
        TypeInformation ti = TypeExtractor.getForClass(PojoWithMultiplePojos.class);
        Keys.ExpressionKeys ek = new Keys.ExpressionKeys(new String[]{"*"}, ti);
        Assert.assertArrayEquals((int[])new int[]{0, 1, 2, 3, 4}, (int[])ek.computeLogicalKeyPositions());
        ek = new Keys.ExpressionKeys(new String[]{"p1.*"}, ti);
        Assert.assertArrayEquals((int[])new int[]{1, 2}, (int[])ek.computeLogicalKeyPositions());
        ek = new Keys.ExpressionKeys(new String[]{"p2.*"}, ti);
        Assert.assertArrayEquals((int[])new int[]{3, 4}, (int[])ek.computeLogicalKeyPositions());
        ek = new Keys.ExpressionKeys(new String[]{"p1"}, ti);
        Assert.assertArrayEquals((int[])new int[]{1, 2}, (int[])ek.computeLogicalKeyPositions());
        ek = new Keys.ExpressionKeys(new String[]{"p2"}, ti);
        Assert.assertArrayEquals((int[])new int[]{3, 4}, (int[])ek.computeLogicalKeyPositions());
        ek = new Keys.ExpressionKeys(new String[]{"i0"}, ti);
        Assert.assertArrayEquals((int[])new int[]{0}, (int[])ek.computeLogicalKeyPositions());
    }

    @Test
    public void testTupleWithNestedPojo() {
        TupleTypeInfo ti = new TupleTypeInfo(new TypeInformation[]{BasicTypeInfo.INT_TYPE_INFO, TypeExtractor.getForClass(Pojo1.class), TypeExtractor.getForClass(PojoWithMultiplePojos.class)});
        Keys.ExpressionKeys ek = new Keys.ExpressionKeys(new int[]{0}, (TypeInformation)ti);
        Assert.assertArrayEquals((int[])new int[]{0}, (int[])ek.computeLogicalKeyPositions());
        ek = new Keys.ExpressionKeys(new int[]{1}, (TypeInformation)ti);
        Assert.assertArrayEquals((int[])new int[]{1, 2}, (int[])ek.computeLogicalKeyPositions());
        ek = new Keys.ExpressionKeys(new int[]{2}, (TypeInformation)ti);
        Assert.assertArrayEquals((int[])new int[]{3, 4, 5, 6, 7}, (int[])ek.computeLogicalKeyPositions());
        ek = new Keys.ExpressionKeys(new int[0], (TypeInformation)ti, true);
        Assert.assertArrayEquals((int[])new int[]{0, 1, 2, 3, 4, 5, 6, 7}, (int[])ek.computeLogicalKeyPositions());
    }

    public static class PojoWithMultiplePojos {
        public Pojo1 p1;
        public Pojo2 p2;
        public Integer i0;
    }

    public static class Pojo2 {
        public String a2;
        public String b2;
    }

    public static class Pojo1 {
        public String a;
        public String b;
    }
}

