/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.operator;

import java.util.ArrayList;
import java.util.List;
import org.apache.flink.api.common.InvalidProgramException;
import org.apache.flink.api.common.operators.Order;
import org.apache.flink.api.common.typeinfo.BasicTypeInfo;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.ExecutionEnvironment;
import org.apache.flink.api.java.operators.DataSource;
import org.apache.flink.api.java.tuple.Tuple5;
import org.apache.flink.api.java.typeutils.TupleTypeInfo;
import org.junit.Assert;
import org.junit.Test;

public class FirstNOperatorTest {
    private final List<Tuple5<Integer, Long, String, Long, Integer>> emptyTupleData = new ArrayList<Tuple5<Integer, Long, String, Long, Integer>>();
    private final TupleTypeInfo<Tuple5<Integer, Long, String, Long, Integer>> tupleTypeInfo = new TupleTypeInfo(new TypeInformation[]{BasicTypeInfo.INT_TYPE_INFO, BasicTypeInfo.LONG_TYPE_INFO, BasicTypeInfo.STRING_TYPE_INFO, BasicTypeInfo.LONG_TYPE_INFO, BasicTypeInfo.INT_TYPE_INFO});

    @Test
    public void testUngroupedFirstN() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource tupleDs = env.fromCollection(this.emptyTupleData, this.tupleTypeInfo);
        try {
            tupleDs.first(1);
        }
        catch (Exception e) {
            Assert.fail();
        }
        try {
            tupleDs.first(10);
        }
        catch (Exception e) {
            Assert.fail();
        }
        try {
            tupleDs.first(0);
            Assert.fail();
        }
        catch (InvalidProgramException e) {
        }
        catch (Exception e) {
            Assert.fail();
        }
        try {
            tupleDs.first(-1);
            Assert.fail();
        }
        catch (InvalidProgramException e) {
        }
        catch (Exception e) {
            Assert.fail();
        }
    }

    @Test
    public void testGroupedFirstN() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource tupleDs = env.fromCollection(this.emptyTupleData, this.tupleTypeInfo);
        try {
            tupleDs.groupBy(new int[]{2}).first(1);
        }
        catch (Exception e) {
            Assert.fail();
        }
        try {
            tupleDs.groupBy(new int[]{1, 3}).first(10);
        }
        catch (Exception e) {
            Assert.fail();
        }
        try {
            tupleDs.groupBy(new int[]{0}).first(0);
            Assert.fail();
        }
        catch (InvalidProgramException e) {
        }
        catch (Exception e) {
            Assert.fail();
        }
        try {
            tupleDs.groupBy(new int[]{2}).first(-1);
            Assert.fail();
        }
        catch (InvalidProgramException e) {
        }
        catch (Exception e) {
            Assert.fail();
        }
    }

    @Test
    public void testGroupedSortedFirstN() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource tupleDs = env.fromCollection(this.emptyTupleData, this.tupleTypeInfo);
        try {
            tupleDs.groupBy(new int[]{2}).sortGroup(4, Order.ASCENDING).first(1);
        }
        catch (Exception e) {
            Assert.fail();
        }
        try {
            tupleDs.groupBy(new int[]{1, 3}).sortGroup(4, Order.ASCENDING).first(10);
        }
        catch (Exception e) {
            Assert.fail();
        }
        try {
            tupleDs.groupBy(new int[]{0}).sortGroup(4, Order.ASCENDING).first(0);
            Assert.fail();
        }
        catch (InvalidProgramException e) {
        }
        catch (Exception e) {
            Assert.fail();
        }
        try {
            tupleDs.groupBy(new int[]{2}).sortGroup(4, Order.ASCENDING).first(-1);
            Assert.fail();
        }
        catch (InvalidProgramException e) {
        }
        catch (Exception e) {
            Assert.fail();
        }
    }
}

