/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.hadoop.mapred;

import java.io.IOException;
import org.apache.flink.api.common.typeinfo.BasicTypeInfo;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.hadoop.mapred.HadoopInputFormat;
import org.apache.flink.api.java.typeutils.TupleTypeInfo;
import org.apache.hadoop.mapred.FileInputFormat;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.RecordReader;
import org.apache.hadoop.mapred.Reporter;
import org.junit.Assert;
import org.junit.Test;

public class HadoopInputFormatTest {
    @Test
    public void checkTypeInformation() {
        try {
            HadoopInputFormat hadoopInputFormat = new HadoopInputFormat(new DummyVoidKeyInputFormat(), Void.class, Long.class, new JobConf());
            TypeInformation tupleType = hadoopInputFormat.getProducedType();
            TupleTypeInfo testTupleType = new TupleTypeInfo(new TypeInformation[]{BasicTypeInfo.VOID_TYPE_INFO, BasicTypeInfo.LONG_TYPE_INFO});
            if (tupleType.isTupleType()) {
                if (!((TupleTypeInfo)tupleType).equals((Object)testTupleType)) {
                    Assert.fail((String)"Tuple type information was not set correctly!");
                }
            } else {
                Assert.fail((String)"Type information was not set to tuple type information!");
            }
        }
        catch (Exception ex) {
            Assert.fail((String)("Test failed due to a " + ex.getClass().getSimpleName() + ": " + ex.getMessage()));
        }
    }

    public class DummyVoidKeyInputFormat<T>
    extends FileInputFormat<Void, T> {
        public RecordReader<Void, T> getRecordReader(InputSplit inputSplit, JobConf jobConf, Reporter reporter) throws IOException {
            return null;
        }
    }
}

