/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.examples.java.wordcount;

import org.apache.flink.api.common.functions.FlatMapFunction;
import org.apache.flink.api.common.functions.ReduceFunction;
import org.apache.flink.api.java.DataSet;
import org.apache.flink.api.java.ExecutionEnvironment;
import org.apache.flink.api.java.operators.ReduceOperator;
import org.apache.flink.core.fs.FileSystem;
import org.apache.flink.examples.java.wordcount.util.WordCountData;
import org.apache.flink.util.Collector;

public class PojoExample {
    private static boolean fileOutput = false;
    private static String textPath;
    private static String outputPath;

    public static void main(String[] args) throws Exception {
        if (!PojoExample.parseParameters(args)) {
            return;
        }
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSet<String> text = PojoExample.getTextDataSet(env);
        ReduceOperator counts = text.flatMap((FlatMapFunction)new Tokenizer()).groupBy(new String[]{"word"}).reduce((ReduceFunction)new ReduceFunction<Word>(){

            public Word reduce(Word value1, Word value2) throws Exception {
                return new Word(value1.word, value1.frequency + value2.frequency);
            }
        });
        if (fileOutput) {
            counts.writeAsText(outputPath, FileSystem.WriteMode.OVERWRITE);
            env.execute("WordCount-Pojo Example");
        } else {
            counts.print();
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private static boolean parseParameters(String[] args) {
        if (args.length <= 0) {
            System.out.println("Executing WordCount example with built-in default data.");
            System.out.println("  Provide parameters to read input data from a file.");
            System.out.println("  Usage: WordCount <text path> <result path>");
            return true;
        }
        fileOutput = true;
        if (args.length == 2) {
            textPath = args[0];
            outputPath = args[1];
            return true;
        }
        System.err.println("Usage: WordCount <text path> <result path>");
        return false;
    }

    private static DataSet<String> getTextDataSet(ExecutionEnvironment env) {
        if (fileOutput) {
            return env.readTextFile(textPath);
        }
        return WordCountData.getDefaultTextLineDataSet(env);
    }

    public static final class Tokenizer
    implements FlatMapFunction<String, Word> {
        private static final long serialVersionUID = 1L;

        public void flatMap(String value, Collector<Word> out) {
            String[] tokens;
            for (String token : tokens = value.toLowerCase().split("\\W+")) {
                if (token.length() <= 0) continue;
                out.collect((Object)new Word(token, 1));
            }
        }
    }

    public static class Word {
        private String word;
        private Integer frequency;

        public Word() {
        }

        public Word(String word, int i) {
            this.word = word;
            this.frequency = i;
        }

        public String getWord() {
            return this.word;
        }

        public void setWord(String word) {
            this.word = word;
        }

        public Integer getFrequency() {
            return this.frequency;
        }

        public void setFrequency(Integer frequency) {
            this.frequency = frequency;
        }

        public String toString() {
            return "Word=" + this.word + " freq=" + this.frequency;
        }
    }
}

