/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.examples.java.graph;

import java.util.ArrayList;
import org.apache.flink.api.common.functions.FilterFunction;
import org.apache.flink.api.common.functions.FlatMapFunction;
import org.apache.flink.api.common.functions.GroupReduceFunction;
import org.apache.flink.api.common.functions.MapFunction;
import org.apache.flink.api.java.DataSet;
import org.apache.flink.api.java.ExecutionEnvironment;
import org.apache.flink.api.java.aggregation.Aggregations;
import org.apache.flink.api.java.functions.FunctionAnnotation;
import org.apache.flink.api.java.operators.GroupReduceOperator;
import org.apache.flink.api.java.operators.IterativeDataSet;
import org.apache.flink.api.java.operators.MapOperator;
import org.apache.flink.api.java.tuple.Tuple1;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.examples.java.graph.util.PageRankData;
import org.apache.flink.util.Collector;

public class PageRankBasic {
    private static final double DAMPENING_FACTOR = 0.85;
    private static final double EPSILON = 1.0E-4;
    private static boolean fileOutput = false;
    private static String pagesInputPath = null;
    private static String linksInputPath = null;
    private static String outputPath = null;
    private static long numPages = 0L;
    private static int maxIterations = 10;

    public static void main(String[] args) throws Exception {
        if (!PageRankBasic.parseParameters(args)) {
            return;
        }
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSet<Long> pagesInput = PageRankBasic.getPagesDataSet(env);
        DataSet<Tuple2<Long, Long>> linksInput = PageRankBasic.getLinksDataSet(env);
        MapOperator pagesWithRanks = pagesInput.map((MapFunction)new RankAssigner(1.0 / (double)numPages));
        GroupReduceOperator adjacencyListInput = linksInput.groupBy(new int[]{0}).reduceGroup((GroupReduceFunction)new BuildOutgoingEdgeList());
        IterativeDataSet iteration = pagesWithRanks.iterate(maxIterations);
        MapOperator newRanks = iteration.join((DataSet)adjacencyListInput).where(new int[]{0}).equalTo(new int[]{0}).flatMap((FlatMapFunction)new JoinVertexWithEdgesMatch()).groupBy(new int[]{0}).aggregate(Aggregations.SUM, 1).map((MapFunction)new Dampener(0.85, numPages));
        DataSet finalPageRanks = iteration.closeWith((DataSet)newRanks, (DataSet)newRanks.join((DataSet)iteration).where(new int[]{0}).equalTo(new int[]{0}).filter((FilterFunction)new EpsilonFilter()));
        if (fileOutput) {
            finalPageRanks.writeAsCsv(outputPath, "\n", " ");
        } else {
            finalPageRanks.print();
        }
        env.execute("Basic Page Rank Example");
    }

    /*
     * Enabled aggressive block sorting
     */
    private static boolean parseParameters(String[] args) {
        if (args.length <= 0) {
            System.out.println("Executing PageRank Basic example with default parameters and built-in default data.");
            System.out.println("  Provide parameters to read input data from files.");
            System.out.println("  See the documentation for the correct format of input files.");
            System.out.println("  Usage: PageRankBasic <pages path> <links path> <output path> <num pages> <num iterations>");
            numPages = PageRankData.getNumberOfPages();
            return true;
        }
        if (args.length == 5) {
            fileOutput = true;
            pagesInputPath = args[0];
            linksInputPath = args[1];
            outputPath = args[2];
            numPages = Integer.parseInt(args[3]);
            maxIterations = Integer.parseInt(args[4]);
            return true;
        }
        System.err.println("Usage: PageRankBasic <pages path> <links path> <output path> <num pages> <num iterations>");
        return false;
    }

    private static DataSet<Long> getPagesDataSet(ExecutionEnvironment env) {
        if (fileOutput) {
            return env.readCsvFile(pagesInputPath).fieldDelimiter(' ').lineDelimiter("\n").types(Long.class).map((MapFunction)new MapFunction<Tuple1<Long>, Long>(){

                public Long map(Tuple1<Long> v) {
                    return (Long)v.f0;
                }
            });
        }
        return PageRankData.getDefaultPagesDataSet(env);
    }

    private static DataSet<Tuple2<Long, Long>> getLinksDataSet(ExecutionEnvironment env) {
        if (fileOutput) {
            return env.readCsvFile(linksInputPath).fieldDelimiter(' ').lineDelimiter("\n").types(Long.class, Long.class);
        }
        return PageRankData.getDefaultEdgeDataSet(env);
    }

    public static final class EpsilonFilter
    implements FilterFunction<Tuple2<Tuple2<Long, Double>, Tuple2<Long, Double>>> {
        public boolean filter(Tuple2<Tuple2<Long, Double>, Tuple2<Long, Double>> value) {
            return Math.abs((Double)((Tuple2)value.f0).f1 - (Double)((Tuple2)value.f1).f1) > 1.0E-4;
        }
    }

    @FunctionAnnotation.ConstantFields(value={"0"})
    public static final class Dampener
    implements MapFunction<Tuple2<Long, Double>, Tuple2<Long, Double>> {
        private final double dampening;
        private final double randomJump;

        public Dampener(double dampening, double numVertices) {
            this.dampening = dampening;
            this.randomJump = (1.0 - dampening) / numVertices;
        }

        public Tuple2<Long, Double> map(Tuple2<Long, Double> value) {
            value.f1 = (Double)value.f1 * this.dampening + this.randomJump;
            return value;
        }
    }

    public static final class JoinVertexWithEdgesMatch
    implements FlatMapFunction<Tuple2<Tuple2<Long, Double>, Tuple2<Long, Long[]>>, Tuple2<Long, Double>> {
        public void flatMap(Tuple2<Tuple2<Long, Double>, Tuple2<Long, Long[]>> value, Collector<Tuple2<Long, Double>> out) {
            Long[] neigbors = (Long[])((Tuple2)value.f1).f1;
            double rank = (Double)((Tuple2)value.f0).f1;
            double rankToDistribute = rank / (double)neigbors.length;
            for (int i = 0; i < neigbors.length; ++i) {
                out.collect((Object)new Tuple2((Object)neigbors[i], (Object)rankToDistribute));
            }
        }
    }

    @FunctionAnnotation.ConstantFields(value={"0"})
    public static final class BuildOutgoingEdgeList
    implements GroupReduceFunction<Tuple2<Long, Long>, Tuple2<Long, Long[]>> {
        private final ArrayList<Long> neighbors = new ArrayList();

        public void reduce(Iterable<Tuple2<Long, Long>> values, Collector<Tuple2<Long, Long[]>> out) {
            this.neighbors.clear();
            Long id = 0L;
            for (Tuple2<Long, Long> n : values) {
                id = (Long)n.f0;
                this.neighbors.add((Long)n.f1);
            }
            out.collect((Object)new Tuple2((Object)id, (Object)this.neighbors.toArray(new Long[this.neighbors.size()])));
        }
    }

    public static final class RankAssigner
    implements MapFunction<Long, Tuple2<Long, Double>> {
        Tuple2<Long, Double> outPageWithRank;

        public RankAssigner(double rank) {
            this.outPageWithRank = new Tuple2((Object)-1L, (Object)rank);
        }

        public Tuple2<Long, Double> map(Long page) {
            this.outPageWithRank.f0 = page;
            return this.outPageWithRank;
        }
    }
}

