/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.examples.java.relational;

import org.apache.flink.api.common.functions.FilterFunction;
import org.apache.flink.api.common.functions.MapFunction;
import org.apache.flink.api.java.DataSet;
import org.apache.flink.api.java.ExecutionEnvironment;
import org.apache.flink.api.java.aggregation.Aggregations;
import org.apache.flink.api.java.operators.JoinOperator;
import org.apache.flink.api.java.operators.MapOperator;
import org.apache.flink.api.java.operators.ProjectOperator;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.api.java.tuple.Tuple3;
import org.apache.flink.api.java.tuple.Tuple4;
import org.apache.flink.api.java.tuple.Tuple5;

public class TPCHQuery10 {
    private static String customerPath;
    private static String ordersPath;
    private static String lineitemPath;
    private static String nationPath;
    private static String outputPath;

    public static void main(String[] args) throws Exception {
        if (!TPCHQuery10.parseParameters(args)) {
            return;
        }
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSet<Tuple5<Integer, String, String, Integer, Double>> customers = TPCHQuery10.getCustomerDataSet(env);
        DataSet<Tuple3<Integer, Integer, String>> orders = TPCHQuery10.getOrdersDataSet(env);
        DataSet<Tuple4<Integer, Double, Double, String>> lineitems = TPCHQuery10.getLineitemDataSet(env);
        DataSet<Tuple2<Integer, String>> nations = TPCHQuery10.getNationsDataSet(env);
        ProjectOperator ordersFilteredByYear = orders.filter((FilterFunction)new FilterFunction<Tuple3<Integer, Integer, String>>(){

            public boolean filter(Tuple3<Integer, Integer, String> o) {
                return Integer.parseInt(((String)o.f2).substring(0, 4)) > 1990;
            }
        }).project(new int[]{0, 1});
        MapOperator lineitemsFilteredByFlag = lineitems.filter((FilterFunction)new FilterFunction<Tuple4<Integer, Double, Double, String>>(){

            public boolean filter(Tuple4<Integer, Double, Double, String> l) {
                return ((String)l.f3).equals("R");
            }
        }).map((MapFunction)new MapFunction<Tuple4<Integer, Double, Double, String>, Tuple2<Integer, Double>>(){

            public Tuple2<Integer, Double> map(Tuple4<Integer, Double, Double, String> l) {
                return new Tuple2(l.f0, (Object)((Double)l.f1 * (1.0 - (Double)l.f2)));
            }
        });
        JoinOperator.ProjectJoin revenueByCustomer = ordersFilteredByYear.joinWithHuge((DataSet)lineitemsFilteredByFlag).where(new int[]{0}).equalTo(new int[]{0}).projectFirst(new int[]{1}).projectSecond(new int[]{1});
        revenueByCustomer = revenueByCustomer.groupBy(new int[]{0}).aggregate(Aggregations.SUM, 1);
        JoinOperator.ProjectJoin customerWithNation = customers.joinWithTiny(nations).where(new int[]{3}).equalTo(new int[]{0}).projectFirst(new int[]{0, 1, 2}).projectSecond(new int[]{1}).projectFirst(new int[]{4});
        JoinOperator.ProjectJoin result = customerWithNation.join((DataSet)revenueByCustomer).where(new int[]{0}).equalTo(new int[]{0}).projectFirst(new int[]{0, 1, 2, 3, 4}).projectSecond(new int[]{1});
        result.writeAsCsv(outputPath, "\n", "|");
        env.execute("TPCH Query 10 Example");
    }

    private static boolean parseParameters(String[] programArguments) {
        if (programArguments.length > 0) {
            if (programArguments.length != 5) {
                System.err.println("Usage: TPCHQuery10 <customer-csv path> <orders-csv path> <lineitem-csv path> <nation-csv path> <result path>");
                return false;
            }
        } else {
            System.err.println("This program expects data from the TPC-H benchmark as input data.\n  Due to legal restrictions, we can not ship generated data.\n  You can find the TPC-H data generator at http://www.tpc.org/tpch/.\n  Usage: TPCHQuery10 <customer-csv path> <orders-csv path> <lineitem-csv path> <nation-csv path> <result path>");
            return false;
        }
        customerPath = programArguments[0];
        ordersPath = programArguments[1];
        lineitemPath = programArguments[2];
        nationPath = programArguments[3];
        outputPath = programArguments[4];
        return true;
    }

    private static DataSet<Tuple5<Integer, String, String, Integer, Double>> getCustomerDataSet(ExecutionEnvironment env) {
        return env.readCsvFile(customerPath).fieldDelimiter('|').includeFields("11110100").types(Integer.class, String.class, String.class, Integer.class, Double.class);
    }

    private static DataSet<Tuple3<Integer, Integer, String>> getOrdersDataSet(ExecutionEnvironment env) {
        return env.readCsvFile(ordersPath).fieldDelimiter('|').includeFields("110010000").types(Integer.class, Integer.class, String.class);
    }

    private static DataSet<Tuple4<Integer, Double, Double, String>> getLineitemDataSet(ExecutionEnvironment env) {
        return env.readCsvFile(lineitemPath).fieldDelimiter('|').includeFields("1000011010000000").types(Integer.class, Double.class, Double.class, String.class);
    }

    private static DataSet<Tuple2<Integer, String>> getNationsDataSet(ExecutionEnvironment env) {
        return env.readCsvFile(nationPath).fieldDelimiter('|').includeFields("1100").types(Integer.class, String.class);
    }
}

