/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.examples.java.ml;

import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import org.apache.flink.api.common.functions.MapFunction;
import org.apache.flink.api.common.functions.ReduceFunction;
import org.apache.flink.api.common.functions.RichMapFunction;
import org.apache.flink.api.java.DataSet;
import org.apache.flink.api.java.ExecutionEnvironment;
import org.apache.flink.api.java.operators.IterativeDataSet;
import org.apache.flink.api.java.operators.MapOperator;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.examples.java.ml.util.LinearRegressionData;

public class LinearRegression {
    private static boolean fileOutput = false;
    private static String dataPath = null;
    private static String outputPath = null;
    private static int numIterations = 10;

    public static void main(String[] args) throws Exception {
        if (!LinearRegression.parseParameters(args)) {
            return;
        }
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSet<Data> data = LinearRegression.getDataSet(env);
        DataSet<Params> parameters = LinearRegression.getParamsDataSet(env);
        IterativeDataSet loop = parameters.iterate(numIterations);
        MapOperator new_parameters = ((MapOperator)data.map((MapFunction)new SubUpdate()).withBroadcastSet((DataSet)loop, "parameters")).reduce((ReduceFunction)new UpdateAccumulator()).map((MapFunction)new Update());
        DataSet result = loop.closeWith((DataSet)new_parameters);
        if (fileOutput) {
            result.writeAsText(outputPath);
        } else {
            result.print();
        }
        env.execute("Linear Regression example");
    }

    /*
     * Enabled aggressive block sorting
     */
    private static boolean parseParameters(String[] programArguments) {
        if (programArguments.length <= 0) {
            System.out.println("Executing Linear Regression example with default parameters and built-in default data.");
            System.out.println("  Provide parameters to read input data from files.");
            System.out.println("  See the documentation for the correct format of input files.");
            System.out.println("  We provide a data generator to create synthetic input files for this program.");
            System.out.println("  Usage: LinearRegression <data path> <result path> <num iterations>");
            return true;
        }
        fileOutput = true;
        if (programArguments.length == 3) {
            dataPath = programArguments[0];
            outputPath = programArguments[1];
            numIterations = Integer.parseInt(programArguments[2]);
            return true;
        }
        System.err.println("Usage: LinearRegression <data path> <result path> <num iterations>");
        return false;
    }

    private static DataSet<Data> getDataSet(ExecutionEnvironment env) {
        if (fileOutput) {
            return env.readCsvFile(dataPath).fieldDelimiter(' ').includeFields(new boolean[]{true, true}).types(Double.class, Double.class).map((MapFunction)new TupleDataConverter());
        }
        return LinearRegressionData.getDefaultDataDataSet(env);
    }

    private static DataSet<Params> getParamsDataSet(ExecutionEnvironment env) {
        return LinearRegressionData.getDefaultParamsDataSet(env);
    }

    public static class Update
    implements MapFunction<Tuple2<Params, Integer>, Params> {
        public Params map(Tuple2<Params, Integer> arg0) throws Exception {
            return ((Params)arg0.f0).div((Integer)arg0.f1);
        }
    }

    public static class UpdateAccumulator
    implements ReduceFunction<Tuple2<Params, Integer>> {
        public Tuple2<Params, Integer> reduce(Tuple2<Params, Integer> val1, Tuple2<Params, Integer> val2) {
            double new_theta0 = ((Params)val1.f0).theta0 + ((Params)val2.f0).theta0;
            double new_theta1 = ((Params)val1.f0).theta1 + ((Params)val2.f0).theta1;
            Params result = new Params(new_theta0, new_theta1);
            return new Tuple2((Object)result, (Object)((Integer)val1.f1 + (Integer)val2.f1));
        }
    }

    public static class SubUpdate
    extends RichMapFunction<Data, Tuple2<Params, Integer>> {
        private Collection<Params> parameters;
        private Params parameter;
        private int count = 1;

        public void open(Configuration parameters) throws Exception {
            this.parameters = this.getRuntimeContext().getBroadcastVariable("parameters");
        }

        public Tuple2<Params, Integer> map(Data in) throws Exception {
            Iterator<Params> iterator = this.parameters.iterator();
            while (iterator.hasNext()) {
                Params p;
                this.parameter = p = iterator.next();
            }
            double theta_0 = this.parameter.theta0 - 0.01 * (this.parameter.theta0 + this.parameter.theta1 * in.x - in.y);
            double theta_1 = this.parameter.theta1 - 0.01 * ((this.parameter.theta0 + this.parameter.theta1 * in.x - in.y) * in.x);
            return new Tuple2((Object)new Params(theta_0, theta_1), (Object)this.count);
        }
    }

    public static final class TupleParamsConverter
    implements MapFunction<Tuple2<Double, Double>, Params> {
        public Params map(Tuple2<Double, Double> t) throws Exception {
            return new Params((Double)t.f0, (Double)t.f1);
        }
    }

    public static final class TupleDataConverter
    implements MapFunction<Tuple2<Double, Double>, Data> {
        public Data map(Tuple2<Double, Double> t) throws Exception {
            return new Data((Double)t.f0, (Double)t.f1);
        }
    }

    public static class Params
    implements Serializable {
        private double theta0;
        private double theta1;

        public Params() {
        }

        public Params(double x0, double x1) {
            this.theta0 = x0;
            this.theta1 = x1;
        }

        public String toString() {
            return this.theta0 + " " + this.theta1;
        }

        public double getTheta0() {
            return this.theta0;
        }

        public double getTheta1() {
            return this.theta1;
        }

        public void setTheta0(double theta0) {
            this.theta0 = theta0;
        }

        public void setTheta1(double theta1) {
            this.theta1 = theta1;
        }

        public Params div(Integer a) {
            this.theta0 /= (double)a.intValue();
            this.theta1 /= (double)a.intValue();
            return this;
        }
    }

    public static class Data
    implements Serializable {
        public double x;
        public double y;

        public Data() {
        }

        public Data(double x, double y) {
            this.x = x;
            this.y = y;
        }

        public String toString() {
            return "(" + this.x + "|" + this.y + ")";
        }
    }
}

