/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.example.java.clustering;

import java.io.Serializable;
import java.util.Collection;
import org.apache.flink.api.common.functions.MapFunction;
import org.apache.flink.api.common.functions.ReduceFunction;
import org.apache.flink.api.java.DataSet;
import org.apache.flink.api.java.ExecutionEnvironment;
import org.apache.flink.api.java.IterativeDataSet;
import org.apache.flink.api.java.functions.RichMapFunction;
import org.apache.flink.api.java.operators.MapOperator;
import org.apache.flink.api.java.operators.SingleInputUdfOperator;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.api.java.tuple.Tuple3;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.example.java.clustering.util.KMeansData;

public class KMeans {
    private static boolean fileOutput = false;
    private static String pointsPath = null;
    private static String centersPath = null;
    private static String outputPath = null;
    private static int numIterations = 10;

    public static void main(String[] args) throws Exception {
        if (!KMeans.parseParameters(args)) {
            return;
        }
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSet<Point> points = KMeans.getPointDataSet(env);
        DataSet<Centroid> centroids = KMeans.getCentroidDataSet(env);
        IterativeDataSet loop = centroids.iterate(numIterations);
        MapOperator newCentroids = ((MapOperator)points.map((MapFunction)new SelectNearestCenter()).withBroadcastSet((DataSet)loop, "centroids")).map((MapFunction)new CountAppender()).groupBy(new int[]{0}).reduce((ReduceFunction)new CentroidAccumulator()).map((MapFunction)new CentroidAverager());
        DataSet finalCentroids = loop.closeWith((DataSet)newCentroids);
        SingleInputUdfOperator clusteredPoints = points.map((MapFunction)new SelectNearestCenter()).withBroadcastSet(finalCentroids, "centroids");
        if (fileOutput) {
            clusteredPoints.writeAsCsv(outputPath, "\n", " ");
        } else {
            clusteredPoints.print();
        }
        env.execute("KMeans Example");
    }

    /*
     * Enabled aggressive block sorting
     */
    private static boolean parseParameters(String[] programArguments) {
        if (programArguments.length <= 0) {
            System.out.println("Executing K-Means example with default parameters and built-in default data.");
            System.out.println("  Provide parameters to read input data from files.");
            System.out.println("  See the documentation for the correct format of input files.");
            System.out.println("  We provide a data generator to create synthetic input files for this program.");
            System.out.println("  Usage: KMeans <points path> <centers path> <result path> <num iterations>");
            return true;
        }
        fileOutput = true;
        if (programArguments.length == 4) {
            pointsPath = programArguments[0];
            centersPath = programArguments[1];
            outputPath = programArguments[2];
            numIterations = Integer.parseInt(programArguments[3]);
            return true;
        }
        System.err.println("Usage: KMeans <points path> <centers path> <result path> <num iterations>");
        return false;
    }

    private static DataSet<Point> getPointDataSet(ExecutionEnvironment env) {
        if (fileOutput) {
            return env.readCsvFile(pointsPath).fieldDelimiter(' ').includeFields(new boolean[]{true, true}).types(Double.class, Double.class).map((MapFunction)new TuplePointConverter());
        }
        return KMeansData.getDefaultPointDataSet(env);
    }

    private static DataSet<Centroid> getCentroidDataSet(ExecutionEnvironment env) {
        if (fileOutput) {
            return env.readCsvFile(centersPath).fieldDelimiter(' ').includeFields(new boolean[]{true, true, true}).types(Integer.class, Double.class, Double.class).map((MapFunction)new TupleCentroidConverter());
        }
        return KMeansData.getDefaultCentroidDataSet(env);
    }

    public static final class CentroidAverager
    implements MapFunction<Tuple3<Integer, Point, Long>, Centroid> {
        public Centroid map(Tuple3<Integer, Point, Long> value) {
            return new Centroid((Integer)value.f0, ((Point)value.f1).div((Long)value.f2));
        }
    }

    public static final class CentroidAccumulator
    implements ReduceFunction<Tuple3<Integer, Point, Long>> {
        public Tuple3<Integer, Point, Long> reduce(Tuple3<Integer, Point, Long> val1, Tuple3<Integer, Point, Long> val2) {
            return new Tuple3(val1.f0, (Object)((Point)val1.f1).add((Point)val2.f1), (Object)((Long)val1.f2 + (Long)val2.f2));
        }
    }

    public static final class CountAppender
    implements MapFunction<Tuple2<Integer, Point>, Tuple3<Integer, Point, Long>> {
        public Tuple3<Integer, Point, Long> map(Tuple2<Integer, Point> t) {
            return new Tuple3(t.f0, t.f1, (Object)1L);
        }
    }

    public static final class SelectNearestCenter
    extends RichMapFunction<Point, Tuple2<Integer, Point>> {
        private Collection<Centroid> centroids;

        public void open(Configuration parameters) throws Exception {
            this.centroids = this.getRuntimeContext().getBroadcastVariable("centroids");
        }

        public Tuple2<Integer, Point> map(Point p) throws Exception {
            double minDistance = Double.MAX_VALUE;
            int closestCentroidId = -1;
            for (Centroid centroid : this.centroids) {
                double distance = p.euclideanDistance(centroid);
                if (!(distance < minDistance)) continue;
                minDistance = distance;
                closestCentroidId = centroid.id;
            }
            return new Tuple2((Object)closestCentroidId, (Object)p);
        }
    }

    public static final class TupleCentroidConverter
    implements MapFunction<Tuple3<Integer, Double, Double>, Centroid> {
        public Centroid map(Tuple3<Integer, Double, Double> t) throws Exception {
            return new Centroid((Integer)t.f0, (Double)t.f1, (Double)t.f2);
        }
    }

    public static final class TuplePointConverter
    implements MapFunction<Tuple2<Double, Double>, Point> {
        public Point map(Tuple2<Double, Double> t) throws Exception {
            return new Point((Double)t.f0, (Double)t.f1);
        }
    }

    public static class Centroid
    extends Point {
        public int id;

        public Centroid() {
        }

        public Centroid(int id, double x, double y) {
            super(x, y);
            this.id = id;
        }

        public Centroid(int id, Point p) {
            super(p.x, p.y);
            this.id = id;
        }

        @Override
        public String toString() {
            return this.id + " " + super.toString();
        }
    }

    public static class Point
    implements Serializable {
        public double x;
        public double y;

        public Point() {
        }

        public Point(double x, double y) {
            this.x = x;
            this.y = y;
        }

        public Point add(Point other) {
            this.x += other.x;
            this.y += other.y;
            return this;
        }

        public Point div(long val) {
            this.x /= (double)val;
            this.y /= (double)val;
            return this;
        }

        public double euclideanDistance(Point other) {
            return Math.sqrt((this.x - other.x) * (this.x - other.x) + (this.y - other.y) * (this.y - other.y));
        }

        public void clear() {
            this.y = 0.0;
            this.x = 0.0;
        }

        public String toString() {
            return this.x + " " + this.y;
        }
    }
}

