/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.addons.hbase;

import java.util.Map;
import org.apache.flink.addons.hbase.HBaseRowInputFormat;
import org.apache.flink.addons.hbase.HBaseTableSchema;
import org.apache.flink.api.common.io.InputFormat;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.DataSet;
import org.apache.flink.api.java.ExecutionEnvironment;
import org.apache.flink.api.java.typeutils.RowTypeInfo;
import org.apache.flink.table.api.TableSchema;
import org.apache.flink.table.sources.BatchTableSource;
import org.apache.flink.table.sources.ProjectableTableSource;
import org.apache.flink.types.Row;
import org.apache.flink.util.Preconditions;
import org.apache.hadoop.conf.Configuration;

public class HBaseTableSource
implements BatchTableSource<Row>,
ProjectableTableSource<Row> {
    private Configuration conf;
    private String tableName;
    private HBaseTableSchema hBaseSchema;
    private TableSchema tableSchema;

    public HBaseTableSource(Configuration conf, String tableName) {
        this.conf = conf;
        this.tableName = (String)Preconditions.checkNotNull((Object)tableName, (String)"Table  name");
        this.hBaseSchema = new HBaseTableSchema();
    }

    private HBaseTableSource(Configuration conf, String tableName, TableSchema tableSchema) {
        this.conf = conf;
        this.tableName = (String)Preconditions.checkNotNull((Object)tableName, (String)"Table  name");
        this.hBaseSchema = new HBaseTableSchema();
        this.tableSchema = tableSchema;
    }

    public void addColumn(String family, String qualifier, Class<?> clazz) {
        this.hBaseSchema.addColumn(family, qualifier, clazz);
    }

    public void setCharset(String charset) {
        this.hBaseSchema.setCharset(charset);
    }

    public TypeInformation<Row> getReturnType() {
        return new RowTypeInfo(this.getFieldTypes(), this.getFieldNames());
    }

    public TableSchema getTableSchema() {
        if (this.tableSchema == null) {
            return new TableSchema(this.getFieldNames(), this.getFieldTypes());
        }
        return this.tableSchema;
    }

    private String[] getFieldNames() {
        return this.hBaseSchema.getFamilyNames();
    }

    private TypeInformation[] getFieldTypes() {
        String[] famNames = this.hBaseSchema.getFamilyNames();
        TypeInformation[] fieldTypes = new TypeInformation[this.hBaseSchema.getFamilyNames().length];
        int i = 0;
        for (String family : famNames) {
            fieldTypes[i] = new RowTypeInfo(this.hBaseSchema.getQualifierTypes(family), this.hBaseSchema.getQualifierNames(family));
            ++i;
        }
        return fieldTypes;
    }

    public DataSet<Row> getDataSet(ExecutionEnvironment execEnv) {
        return execEnv.createInput((InputFormat)new HBaseRowInputFormat(this.conf, this.tableName, this.hBaseSchema), this.getReturnType());
    }

    public HBaseTableSource projectFields(int[] fields) {
        String[] famNames = this.hBaseSchema.getFamilyNames();
        HBaseTableSource newTableSource = new HBaseTableSource(this.conf, this.tableName, this.getTableSchema().copy());
        for (int field : fields) {
            String family = famNames[field];
            Map<String, TypeInformation<?>> familyInfo = this.hBaseSchema.getFamilyInfo(family);
            for (String qualifier : familyInfo.keySet()) {
                newTableSource.addColumn(family, qualifier, familyInfo.get(qualifier).getTypeClass());
            }
        }
        return newTableSource;
    }

    public String explainSource() {
        return "";
    }
}

