/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.addons.hbase;

import java.io.Serializable;
import java.nio.charset.Charset;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.flink.addons.hbase.HBaseRowInputFormat;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.typeutils.TypeExtractor;
import org.apache.flink.util.Preconditions;

public class HBaseTableSchema
implements Serializable {
    private final Map<String, Map<String, TypeInformation<?>>> familyMap = new LinkedHashMap();
    private String charset = "UTF-8";

    void addColumn(String family, String qualifier, Class<?> clazz) {
        Preconditions.checkNotNull((Object)family, (String)"family name");
        Preconditions.checkNotNull((Object)qualifier, (String)"qualifier name");
        Preconditions.checkNotNull(clazz, (String)"class type");
        Map<String, TypeInformation<?>> qualifierMap = this.familyMap.get(family);
        if (!HBaseRowInputFormat.isSupportedType(clazz)) {
            throw new IllegalArgumentException("Unsupported class type found " + clazz + ". Better to use byte[].class and deserialize using user defined scalar functions");
        }
        if (qualifierMap == null) {
            qualifierMap = new LinkedHashMap();
        }
        qualifierMap.put(qualifier, TypeExtractor.getForClass(clazz));
        this.familyMap.put(family, qualifierMap);
    }

    void setCharset(String charset) {
        this.charset = charset;
    }

    String[] getFamilyNames() {
        return this.familyMap.keySet().toArray(new String[this.familyMap.size()]);
    }

    byte[][] getFamilyKeys() {
        Charset c = Charset.forName(this.charset);
        byte[][] familyKeys = new byte[this.familyMap.size()][];
        int i = 0;
        for (String name : this.familyMap.keySet()) {
            familyKeys[i++] = name.getBytes(c);
        }
        return familyKeys;
    }

    String[] getQualifierNames(String family) {
        Map<String, TypeInformation<?>> qualifierMap = this.familyMap.get(family);
        if (qualifierMap == null) {
            throw new IllegalArgumentException("Family " + family + " does not exist in schema.");
        }
        String[] qualifierNames = new String[qualifierMap.size()];
        int i = 0;
        Iterator<String> iterator = qualifierMap.keySet().iterator();
        while (iterator.hasNext()) {
            String qualifier;
            qualifierNames[i] = qualifier = iterator.next();
            ++i;
        }
        return qualifierNames;
    }

    byte[][] getQualifierKeys(String family) {
        Map<String, TypeInformation<?>> qualifierMap = this.familyMap.get(family);
        if (qualifierMap == null) {
            throw new IllegalArgumentException("Family " + family + " does not exist in schema.");
        }
        Charset c = Charset.forName(this.charset);
        byte[][] qualifierKeys = new byte[qualifierMap.size()][];
        int i = 0;
        for (String name : qualifierMap.keySet()) {
            qualifierKeys[i++] = name.getBytes(c);
        }
        return qualifierKeys;
    }

    TypeInformation<?>[] getQualifierTypes(String family) {
        Map<String, TypeInformation<?>> qualifierMap = this.familyMap.get(family);
        if (qualifierMap == null) {
            throw new IllegalArgumentException("Family " + family + " does not exist in schema.");
        }
        TypeInformation[] typeInformation = new TypeInformation[qualifierMap.size()];
        int i = 0;
        Iterator<TypeInformation<?>> iterator = qualifierMap.values().iterator();
        while (iterator.hasNext()) {
            TypeInformation<?> typeInfo;
            typeInformation[i] = typeInfo = iterator.next();
            ++i;
        }
        return typeInformation;
    }

    Map<String, TypeInformation<?>> getFamilyInfo(String family) {
        return this.familyMap.get(family);
    }

    String getStringCharset() {
        return this.charset;
    }
}

