/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.addons.hbase;

import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.charset.Charset;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import org.apache.flink.addons.hbase.AbstractTableInputFormat;
import org.apache.flink.addons.hbase.HBaseTableSchema;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.typeutils.ResultTypeQueryable;
import org.apache.flink.api.java.typeutils.RowTypeInfo;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.types.Row;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.TableNotFoundException;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.util.Bytes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HBaseRowInputFormat
extends AbstractTableInputFormat<Row>
implements ResultTypeQueryable<Row> {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LoggerFactory.getLogger(HBaseRowInputFormat.class);
    private String tableName;
    private transient org.apache.hadoop.conf.Configuration conf;
    private HBaseTableSchema schema;
    private transient Charset stringCharset;
    private byte[][] families;
    private byte[][][] qualifiers;
    private int[][] types;
    private Row resultRow;
    private Row[] familyRows;

    public HBaseRowInputFormat(org.apache.hadoop.conf.Configuration conf, String tableName, HBaseTableSchema schema) {
        this.tableName = tableName;
        this.conf = conf;
        this.schema = schema;
        String[] familyNames = schema.getFamilyNames();
        this.families = schema.getFamilyKeys();
        this.qualifiers = new byte[this.families.length][][];
        this.types = new int[this.families.length][];
        for (int f = 0; f < this.families.length; ++f) {
            this.qualifiers[f] = schema.getQualifierKeys(familyNames[f]);
            TypeInformation<?>[] typeInfos = schema.getQualifierTypes(familyNames[f]);
            this.types[f] = new int[typeInfos.length];
            for (int i = 0; i < typeInfos.length; ++i) {
                int typeIdx = HBaseRowInputFormat.getTypeIndex(typeInfos[i].getTypeClass());
                if (typeIdx < 0) {
                    throw new IllegalArgumentException("Unsupported type: " + typeInfos[i]);
                }
                this.types[f][i] = typeIdx;
            }
        }
    }

    @Override
    public void configure(Configuration parameters) {
        LOG.info("Initializing HBase configuration.");
        this.connectToTable();
        if (this.table != null) {
            this.scan = this.getScanner();
        }
        this.resultRow = new Row(this.families.length);
        this.familyRows = new Row[this.families.length];
        for (int f = 0; f < this.families.length; ++f) {
            this.familyRows[f] = new Row(this.qualifiers[f].length);
            this.resultRow.setField(f, (Object)this.familyRows[f]);
        }
        this.stringCharset = Charset.forName(this.schema.getStringCharset());
    }

    @Override
    protected Scan getScanner() {
        Scan scan = new Scan();
        for (int f = 0; f < this.families.length; ++f) {
            byte[] family = this.families[f];
            for (int q = 0; q < this.qualifiers[f].length; ++q) {
                byte[] quantifier = this.qualifiers[f][q];
                scan.addColumn(family, quantifier);
            }
        }
        return scan;
    }

    @Override
    public String getTableName() {
        return this.tableName;
    }

    @Override
    protected Row mapResultToOutType(Result res) {
        for (int f = 0; f < this.families.length; ++f) {
            byte[] familyKey = this.families[f];
            Row familyRow = this.familyRows[f];
            for (int q = 0; q < this.qualifiers[f].length; ++q) {
                byte[] qualifier = this.qualifiers[f][q];
                int typeIdx = this.types[f][q];
                byte[] value = res.getValue(familyKey, qualifier);
                if (value != null) {
                    familyRow.setField(q, this.deserialize(value, typeIdx));
                    continue;
                }
                familyRow.setField(q, null);
            }
            this.resultRow.setField(f, (Object)familyRow);
        }
        return this.resultRow;
    }

    private void connectToTable() {
        if (this.conf == null) {
            this.conf = HBaseConfiguration.create();
        }
        try {
            Connection conn = ConnectionFactory.createConnection((org.apache.hadoop.conf.Configuration)this.conf);
            this.table = (HTable)conn.getTable(TableName.valueOf((String)this.tableName));
        }
        catch (TableNotFoundException tnfe) {
            LOG.error("The table " + this.tableName + " not found ", (Throwable)tnfe);
            throw new RuntimeException("HBase table '" + this.tableName + "' not found.", tnfe);
        }
        catch (IOException ioe) {
            LOG.error("Exception while creating connection to HBase.", (Throwable)ioe);
            throw new RuntimeException("Cannot create connection to HBase.", ioe);
        }
    }

    public TypeInformation<Row> getProducedType() {
        String[] famNames = this.schema.getFamilyNames();
        TypeInformation[] typeInfos = new TypeInformation[famNames.length];
        int i = 0;
        for (String family : famNames) {
            typeInfos[i] = new RowTypeInfo(this.schema.getQualifierTypes(family), this.schema.getQualifierNames(family));
            ++i;
        }
        return new RowTypeInfo(typeInfos, famNames);
    }

    private Object deserialize(byte[] value, int typeIdx) {
        switch (typeIdx) {
            case 0: {
                return value;
            }
            case 1: {
                return new String(value, this.stringCharset);
            }
            case 2: {
                return value[0];
            }
            case 3: {
                return Bytes.toShort((byte[])value);
            }
            case 4: {
                return Bytes.toInt((byte[])value);
            }
            case 5: {
                return Bytes.toLong((byte[])value);
            }
            case 6: {
                return Float.valueOf(Bytes.toFloat((byte[])value));
            }
            case 7: {
                return Bytes.toDouble((byte[])value);
            }
            case 8: {
                return Bytes.toBoolean((byte[])value);
            }
            case 9: {
                return new Timestamp(Bytes.toLong((byte[])value));
            }
            case 10: {
                return new Date(Bytes.toLong((byte[])value));
            }
            case 11: {
                return new Time(Bytes.toLong((byte[])value));
            }
            case 12: {
                return Bytes.toBigDecimal((byte[])value);
            }
            case 13: {
                return new BigInteger(value);
            }
        }
        throw new IllegalArgumentException("Unknown type index " + typeIdx);
    }

    private static int getTypeIndex(Class<?> clazz) {
        if (byte[].class.equals(clazz)) {
            return 0;
        }
        if (String.class.equals(clazz)) {
            return 1;
        }
        if (Byte.class.equals(clazz)) {
            return 2;
        }
        if (Short.class.equals(clazz)) {
            return 3;
        }
        if (Integer.class.equals(clazz)) {
            return 4;
        }
        if (Long.class.equals(clazz)) {
            return 5;
        }
        if (Float.class.equals(clazz)) {
            return 6;
        }
        if (Double.class.equals(clazz)) {
            return 7;
        }
        if (Boolean.class.equals(clazz)) {
            return 8;
        }
        if (Timestamp.class.equals(clazz)) {
            return 9;
        }
        if (Date.class.equals(clazz)) {
            return 10;
        }
        if (Time.class.equals(clazz)) {
            return 11;
        }
        if (BigDecimal.class.equals(clazz)) {
            return 12;
        }
        if (BigInteger.class.equals(clazz)) {
            return 13;
        }
        return -1;
    }

    static boolean isSupportedType(Class<?> clazz) {
        return HBaseRowInputFormat.getTypeIndex(clazz) != -1;
    }
}

