/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.addons.hbase;

import java.io.IOException;
import java.util.ArrayList;
import org.apache.flink.addons.hbase.TableInputSplit;
import org.apache.flink.api.common.io.LocatableInputSplitAssigner;
import org.apache.flink.api.common.io.RichInputFormat;
import org.apache.flink.api.common.io.statistics.BaseStatistics;
import org.apache.flink.api.java.tuple.Tuple;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.core.io.InputSplitAssigner;
import org.apache.flink.core.io.LocatableInputSplit;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class TableInputFormat<T extends Tuple>
extends RichInputFormat<T, TableInputSplit> {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LoggerFactory.getLogger(TableInputFormat.class);
    private boolean endReached = false;
    protected transient HTable table;
    protected transient Scan scan;
    private ResultScanner rs;
    private byte[] lastRow;
    private int scannedRows;

    protected abstract Scan getScanner();

    protected abstract String getTableName();

    protected abstract T mapResultToTuple(Result var1);

    public void configure(Configuration parameters) {
        this.table = this.createTable();
        this.scan = this.getScanner();
    }

    private HTable createTable() {
        LOG.info("Initializing HBaseConfiguration");
        org.apache.hadoop.conf.Configuration hConf = HBaseConfiguration.create();
        try {
            return new HTable(hConf, this.getTableName());
        }
        catch (Exception e) {
            LOG.error("Error instantiating a new HTable instance", (Throwable)e);
            return null;
        }
    }

    public boolean reachedEnd() throws IOException {
        return this.endReached;
    }

    public T nextRecord(T reuse) throws IOException {
        block4: {
            if (this.rs == null) {
                throw new IOException("No table result scanner provided!");
            }
            try {
                Result res = this.rs.next();
                if (res != null) {
                    ++this.scannedRows;
                    this.lastRow = res.getRow();
                    return this.mapResultToTuple(res);
                }
            }
            catch (Exception e) {
                this.rs.close();
                StringBuffer logMsg = new StringBuffer("Error after scan of ").append(this.scannedRows).append(" rows. Retry with a new scanner...");
                LOG.warn(logMsg.toString(), (Throwable)e);
                this.scan.setStartRow(this.lastRow);
                this.rs = this.table.getScanner(this.scan);
                Result res = this.rs.next();
                if (res == null) break block4;
                ++this.scannedRows;
                this.lastRow = res.getRow();
                return this.mapResultToTuple(res);
            }
        }
        this.endReached = true;
        return null;
    }

    public void open(TableInputSplit split) throws IOException {
        if (split == null) {
            throw new IOException("Input split is null!");
        }
        if (this.table == null) {
            throw new IOException("No HTable provided!");
        }
        if (this.scan == null) {
            throw new IOException("No Scan instance provided");
        }
        this.logSplitInfo("opening", split);
        this.scan.setStartRow(split.getStartRow());
        this.lastRow = split.getEndRow();
        this.scan.setStopRow(this.lastRow);
        this.rs = this.table.getScanner(this.scan);
        this.endReached = false;
        this.scannedRows = 0;
    }

    public void close() throws IOException {
        if (this.rs != null) {
            this.rs.close();
        }
        if (this.table != null) {
            this.table.close();
        }
        LOG.info("Closing split (scanned {} rows)", (Object)this.scannedRows);
        this.lastRow = null;
    }

    public TableInputSplit[] createInputSplits(int minNumSplits) throws IOException {
        Pair keys = this.table.getStartEndKeys();
        if (keys == null || keys.getFirst() == null || ((byte[][])keys.getFirst()).length == 0) {
            throw new IOException("Expecting at least one region.");
        }
        byte[] startRow = this.scan.getStartRow();
        byte[] stopRow = this.scan.getStopRow();
        boolean scanWithNoLowerBound = startRow.length == 0;
        boolean scanWithNoUpperBound = stopRow.length == 0;
        ArrayList<TableInputSplit> splits = new ArrayList<TableInputSplit>(minNumSplits);
        for (int i = 0; i < ((byte[][])keys.getFirst()).length; ++i) {
            boolean isLastRegion;
            byte[] startKey = ((byte[][])keys.getFirst())[i];
            byte[] endKey = ((byte[][])keys.getSecond())[i];
            String regionLocation = this.table.getRegionLocation(startKey, false).getHostnamePort();
            if (!TableInputFormat.includeRegionInSplit(startKey, endKey)) continue;
            String[] hosts = new String[]{regionLocation};
            boolean bl = isLastRegion = endKey.length == 0;
            if (!scanWithNoLowerBound && !isLastRegion && Bytes.compareTo((byte[])startRow, (byte[])endKey) >= 0 || !scanWithNoUpperBound && Bytes.compareTo((byte[])stopRow, (byte[])startKey) <= 0) continue;
            byte[] splitStart = scanWithNoLowerBound || Bytes.compareTo((byte[])startKey, (byte[])startRow) >= 0 ? startKey : startRow;
            byte[] splitStop = (scanWithNoUpperBound || Bytes.compareTo((byte[])endKey, (byte[])stopRow) <= 0) && !isLastRegion ? endKey : stopRow;
            int id = splits.size();
            TableInputSplit split = new TableInputSplit(id, hosts, this.table.getTableName(), splitStart, splitStop);
            splits.add(split);
        }
        LOG.info("Created " + splits.size() + " splits");
        for (TableInputSplit split : splits) {
            this.logSplitInfo("created", split);
        }
        return splits.toArray(new TableInputSplit[0]);
    }

    private void logSplitInfo(String action, TableInputSplit split) {
        int splitId = split.getSplitNumber();
        String splitStart = Bytes.toString((byte[])split.getStartRow());
        String splitEnd = Bytes.toString((byte[])split.getEndRow());
        String splitStartKey = splitStart.isEmpty() ? "-" : splitStart;
        String splitStopKey = splitEnd.isEmpty() ? "-" : splitEnd;
        String[] hostnames = split.getHostnames();
        LOG.info("{} split [{}|{}|{}|{}]", new Object[]{action, splitId, hostnames, splitStartKey, splitStopKey});
    }

    private static boolean includeRegionInSplit(byte[] startKey, byte[] endKey) {
        return true;
    }

    public InputSplitAssigner getInputSplitAssigner(TableInputSplit[] inputSplits) {
        return new LocatableInputSplitAssigner((LocatableInputSplit[])inputSplits);
    }

    public BaseStatistics getStatistics(BaseStatistics cachedStatistics) {
        return null;
    }
}

