/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.fs.hdfs;

import java.io.IOException;
import org.apache.flink.core.fs.FileSystem;
import org.apache.flink.core.fs.FileSystemKind;
import org.apache.flink.core.fs.Path;
import org.apache.flink.runtime.fs.hdfs.HadoopFileSystem;
import org.apache.flink.util.TestLogger;
import org.junit.Assert;
import org.junit.Test;

public class HdfsKindTest
extends TestLogger {
    @Test
    public void testHdfsKind() throws IOException {
        FileSystem fs = new Path("hdfs://localhost:55445/my/file").getFileSystem();
        Assert.assertEquals((Object)FileSystemKind.FILE_SYSTEM, (Object)fs.getKind());
    }

    @Test
    public void testS3Kind() throws IOException {
        try {
            Class.forName("org.apache.hadoop.fs.s3.S3FileSystem");
        }
        catch (ClassNotFoundException ignored) {
            this.log.info("Skipping test 'testS3Kind()' because the S3 file system is not in the class path");
            return;
        }
        FileSystem s3 = new Path("s3://myId:mySecret@bucket/some/bucket/some/object").getFileSystem();
        Assert.assertEquals((Object)FileSystemKind.OBJECT_STORE, (Object)s3.getKind());
    }

    @Test
    public void testS3nKind() throws IOException {
        try {
            Class.forName("org.apache.hadoop.fs.s3native.NativeS3FileSystem");
        }
        catch (ClassNotFoundException ignored) {
            this.log.info("Skipping test 'testS3nKind()' because the Native S3 file system is not in the class path");
            return;
        }
        FileSystem s3n = new Path("s3n://myId:mySecret@bucket/some/bucket/some/object").getFileSystem();
        Assert.assertEquals((Object)FileSystemKind.OBJECT_STORE, (Object)s3n.getKind());
    }

    @Test
    public void testS3aKind() throws IOException {
        try {
            Class.forName("org.apache.hadoop.fs.s3a.S3AFileSystem");
        }
        catch (ClassNotFoundException ignored) {
            this.log.info("Skipping test 'testS3aKind()' because the S3AFileSystem is not in the class path");
            return;
        }
        FileSystem s3a = new Path("s3a://myId:mySecret@bucket/some/bucket/some/object").getFileSystem();
        Assert.assertEquals((Object)FileSystemKind.OBJECT_STORE, (Object)s3a.getKind());
    }

    @Test
    public void testS3fileSystemSchemes() {
        Assert.assertEquals((Object)FileSystemKind.OBJECT_STORE, (Object)HadoopFileSystem.getKindForScheme((String)"s3"));
        Assert.assertEquals((Object)FileSystemKind.OBJECT_STORE, (Object)HadoopFileSystem.getKindForScheme((String)"s3n"));
        Assert.assertEquals((Object)FileSystemKind.OBJECT_STORE, (Object)HadoopFileSystem.getKindForScheme((String)"s3a"));
        Assert.assertEquals((Object)FileSystemKind.OBJECT_STORE, (Object)HadoopFileSystem.getKindForScheme((String)"EMRFS"));
    }

    @Test
    public void testViewFs() {
        Assert.assertEquals((Object)FileSystemKind.FILE_SYSTEM, (Object)HadoopFileSystem.getKindForScheme((String)"viewfs"));
    }
}

