/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.fs.hdfs;

import java.io.File;
import org.apache.flink.core.fs.AbstractRecoverableWriterTest;
import org.apache.flink.core.fs.Path;
import org.apache.flink.runtime.fs.hdfs.HadoopFileSystem;
import org.apache.flink.runtime.util.HadoopUtils;
import org.apache.flink.util.OperatingSystem;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.junit.AfterClass;
import org.junit.Assume;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.rules.TemporaryFolder;

public class HadoopRecoverableWriterTest
extends AbstractRecoverableWriterTest {
    @ClassRule
    public static final TemporaryFolder TEMP_FOLDER = new TemporaryFolder();
    private static MiniDFSCluster hdfsCluster;
    private static org.apache.flink.core.fs.FileSystem fileSystem;
    private static Path basePath;

    @BeforeClass
    public static void testHadoopVersion() {
        Assume.assumeTrue((boolean)HadoopUtils.isMinHadoopVersion((int)2, (int)7));
    }

    @BeforeClass
    public static void verifyOS() {
        Assume.assumeTrue((String)"HDFS cluster cannot be started on Windows without extensions.", (!OperatingSystem.isWindows() ? 1 : 0) != 0);
    }

    @BeforeClass
    public static void createHDFS() throws Exception {
        File baseDir = TEMP_FOLDER.newFolder();
        Configuration hdConf = new Configuration();
        hdConf.set("hdfs.minidfs.basedir", baseDir.getAbsolutePath());
        MiniDFSCluster.Builder builder = new MiniDFSCluster.Builder(hdConf);
        hdfsCluster = builder.build();
        DistributedFileSystem hdfs = hdfsCluster.getFileSystem();
        fileSystem = new HadoopFileSystem((FileSystem)hdfs);
        basePath = new Path(hdfs.getUri() + "/tests");
    }

    @AfterClass
    public static void destroyHDFS() throws Exception {
        if (hdfsCluster != null) {
            hdfsCluster.getFileSystem().delete(new org.apache.hadoop.fs.Path(basePath.toUri()), true);
            hdfsCluster.shutdown();
        }
    }

    public Path getBasePath() {
        return basePath;
    }

    public org.apache.flink.core.fs.FileSystem initializeFileSystem() {
        return fileSystem;
    }
}

