/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.util;

import org.apache.flink.runtime.util.HadoopUtils;
import org.apache.flink.util.TestLogger;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.security.token.delegation.DelegationTokenIdentifier;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.Token;
import org.junit.AfterClass;
import org.junit.Assume;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.jupiter.api.Assertions;
import org.mockito.Mockito;
import sun.security.krb5.Config;
import sun.security.krb5.KrbException;

public class HadoopUtilsTest
extends TestLogger {
    @BeforeClass
    public static void setPropertiesToEnableKerberosConfigInit() throws KrbException {
        System.setProperty("java.security.krb5.realm", "EXAMPLE.COM");
        System.setProperty("java.security.krb5.kdc", "kdc");
        System.setProperty("java.security.krb5.conf", "/dev/null");
        Config.refresh();
    }

    @AfterClass
    public static void cleanupHadoopConfigs() {
        UserGroupInformation.setConfiguration((Configuration)new Configuration());
    }

    @Test
    public void testShouldReturnFalseWhenNoKerberosCredentialsOrDelegationTokens() {
        UserGroupInformation.setConfiguration((Configuration)HadoopUtilsTest.getHadoopConfigWithAuthMethod(UserGroupInformation.AuthenticationMethod.KERBEROS));
        UserGroupInformation userWithoutCredentialsOrTokens = HadoopUtilsTest.createTestUser(UserGroupInformation.AuthenticationMethod.KERBEROS);
        Assume.assumeFalse((boolean)userWithoutCredentialsOrTokens.hasKerberosCredentials());
        boolean isKerberosEnabled = HadoopUtils.isKerberosSecurityEnabled((UserGroupInformation)userWithoutCredentialsOrTokens);
        boolean result = HadoopUtils.areKerberosCredentialsValid((UserGroupInformation)userWithoutCredentialsOrTokens, (boolean)true);
        Assertions.assertTrue((boolean)isKerberosEnabled);
        Assertions.assertFalse((boolean)result);
    }

    @Test
    public void testShouldReturnTrueWhenDelegationTokenIsPresent() {
        UserGroupInformation.setConfiguration((Configuration)HadoopUtilsTest.getHadoopConfigWithAuthMethod(UserGroupInformation.AuthenticationMethod.KERBEROS));
        UserGroupInformation userWithoutCredentialsButHavingToken = HadoopUtilsTest.createTestUser(UserGroupInformation.AuthenticationMethod.KERBEROS);
        userWithoutCredentialsButHavingToken.addToken(HadoopUtilsTest.getHDFSDelegationToken());
        Assume.assumeFalse((boolean)userWithoutCredentialsButHavingToken.hasKerberosCredentials());
        boolean result = HadoopUtils.areKerberosCredentialsValid((UserGroupInformation)userWithoutCredentialsButHavingToken, (boolean)true);
        Assertions.assertTrue((boolean)result);
    }

    @Test
    public void testShouldReturnTrueWhenKerberosCredentialsArePresent() {
        UserGroupInformation.setConfiguration((Configuration)HadoopUtilsTest.getHadoopConfigWithAuthMethod(UserGroupInformation.AuthenticationMethod.KERBEROS));
        UserGroupInformation userWithCredentials = (UserGroupInformation)Mockito.mock(UserGroupInformation.class);
        Mockito.when((Object)userWithCredentials.getAuthenticationMethod()).thenReturn((Object)UserGroupInformation.AuthenticationMethod.KERBEROS);
        Mockito.when((Object)userWithCredentials.hasKerberosCredentials()).thenReturn((Object)true);
        boolean result = HadoopUtils.areKerberosCredentialsValid((UserGroupInformation)userWithCredentials, (boolean)true);
        Assertions.assertTrue((boolean)result);
    }

    @Test
    public void isKerberosSecurityEnabled_NoKerberos_ReturnsFalse() {
        UserGroupInformation.setConfiguration((Configuration)HadoopUtilsTest.getHadoopConfigWithAuthMethod(UserGroupInformation.AuthenticationMethod.PROXY));
        UserGroupInformation userWithAuthMethodOtherThanKerberos = HadoopUtilsTest.createTestUser(UserGroupInformation.AuthenticationMethod.PROXY);
        boolean result = HadoopUtils.isKerberosSecurityEnabled((UserGroupInformation)userWithAuthMethodOtherThanKerberos);
        Assertions.assertFalse((boolean)result);
    }

    @Test
    public void testShouldReturnTrueIfTicketCacheIsNotUsed() {
        UserGroupInformation.setConfiguration((Configuration)HadoopUtilsTest.getHadoopConfigWithAuthMethod(UserGroupInformation.AuthenticationMethod.KERBEROS));
        UserGroupInformation user = HadoopUtilsTest.createTestUser(UserGroupInformation.AuthenticationMethod.KERBEROS);
        boolean result = HadoopUtils.areKerberosCredentialsValid((UserGroupInformation)user, (boolean)false);
        Assertions.assertTrue((boolean)result);
    }

    @Test
    public void testShouldCheckIfTheUserHasHDFSDelegationToken() {
        UserGroupInformation userWithToken = HadoopUtilsTest.createTestUser(UserGroupInformation.AuthenticationMethod.KERBEROS);
        userWithToken.addToken(HadoopUtilsTest.getHDFSDelegationToken());
        boolean result = HadoopUtils.hasHDFSDelegationToken((UserGroupInformation)userWithToken);
        Assertions.assertTrue((boolean)result);
    }

    @Test
    public void testShouldReturnFalseIfTheUserHasNoHDFSDelegationToken() {
        UserGroupInformation userWithoutToken = HadoopUtilsTest.createTestUser(UserGroupInformation.AuthenticationMethod.KERBEROS);
        Assume.assumeTrue((boolean)userWithoutToken.getTokens().isEmpty());
        boolean result = HadoopUtils.hasHDFSDelegationToken((UserGroupInformation)userWithoutToken);
        Assertions.assertFalse((boolean)result);
    }

    private static Configuration getHadoopConfigWithAuthMethod(UserGroupInformation.AuthenticationMethod authenticationMethod) {
        Configuration conf = new Configuration(true);
        conf.set("hadoop.security.authentication", authenticationMethod.name());
        return conf;
    }

    private static UserGroupInformation createTestUser(UserGroupInformation.AuthenticationMethod authenticationMethod) {
        UserGroupInformation user = UserGroupInformation.createRemoteUser((String)"test-user");
        user.setAuthenticationMethod(authenticationMethod);
        return user;
    }

    private static Token<DelegationTokenIdentifier> getHDFSDelegationToken() {
        Token token = new Token();
        token.setKind(HadoopUtils.HDFS_DELEGATION_TOKEN_KIND);
        return token;
    }
}

