/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.fs.hdfs;

import java.io.File;
import org.apache.flink.core.fs.FileSystemBehaviorTestSuite;
import org.apache.flink.core.fs.FileSystemKind;
import org.apache.flink.core.fs.Path;
import org.apache.flink.runtime.fs.hdfs.HadoopFileSystem;
import org.apache.flink.util.OperatingSystem;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.Assumptions;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.io.TempDir;

class HdfsBehaviorTest
extends FileSystemBehaviorTestSuite {
    private static MiniDFSCluster hdfsCluster;
    private static org.apache.flink.core.fs.FileSystem fs;
    private static Path basePath;

    HdfsBehaviorTest() {
    }

    @BeforeAll
    static void verifyOS() {
        ((AbstractBooleanAssert)Assumptions.assumeThat((boolean)OperatingSystem.isWindows()).describedAs("HDFS cluster cannot be started on Windows without extensions.", new Object[0])).isFalse();
    }

    @BeforeAll
    static void createHDFS(@TempDir File tmp) throws Exception {
        Configuration hdConf = new Configuration();
        hdConf.set("hdfs.minidfs.basedir", tmp.getAbsolutePath());
        MiniDFSCluster.Builder builder = new MiniDFSCluster.Builder(hdConf);
        hdfsCluster = builder.build();
        DistributedFileSystem hdfs = hdfsCluster.getFileSystem();
        fs = new HadoopFileSystem((FileSystem)hdfs);
        basePath = new Path(hdfs.getUri().toString() + "/tests");
    }

    @AfterAll
    static void destroyHDFS() throws Exception {
        if (hdfsCluster != null) {
            hdfsCluster.getFileSystem().delete(new org.apache.hadoop.fs.Path(basePath.toUri()), true);
            hdfsCluster.shutdown();
        }
    }

    protected org.apache.flink.core.fs.FileSystem getFileSystem() {
        return fs;
    }

    protected Path getBasePath() {
        return basePath;
    }

    protected FileSystemKind getFileSystemKind() {
        return FileSystemKind.FILE_SYSTEM;
    }
}

