/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.fs.hdfs;

import java.io.IOException;
import java.net.URI;
import org.apache.flink.core.fs.FileSystem;
import org.apache.flink.runtime.fs.hdfs.HadoopFsFactory;
import org.apache.flink.util.TestLogger;
import org.junit.Assert;
import org.junit.Test;

public class HadoopFsFactoryTest
extends TestLogger {
    @Test
    public void testCreateHadoopFsWithoutConfig() throws Exception {
        URI uri = URI.create("hdfs://localhost:12345/");
        HadoopFsFactory factory = new HadoopFsFactory();
        FileSystem fs = factory.create(uri);
        Assert.assertEquals((Object)uri.getScheme(), (Object)fs.getUri().getScheme());
        Assert.assertEquals((Object)uri.getAuthority(), (Object)fs.getUri().getAuthority());
        Assert.assertEquals((long)uri.getPort(), (long)fs.getUri().getPort());
    }

    @Test
    public void testCreateHadoopFsWithMissingAuthority() throws Exception {
        URI uri = URI.create("hdfs:///my/path");
        HadoopFsFactory factory = new HadoopFsFactory();
        try {
            factory.create(uri);
            Assert.fail((String)"should have failed with an exception");
        }
        catch (IOException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("authority"));
        }
    }
}

