/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.fs.hdfs;

import java.net.URI;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.core.fs.FileSystem;
import org.apache.flink.core.fs.LimitedConnectionsFileSystem;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class LimitedConnectionsConfigurationTest {
    @Rule
    public final TemporaryFolder tempDir = new TemporaryFolder();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testConfiguration() throws Exception {
        FileSystem hdfs = FileSystem.get((URI)URI.create("hdfs://localhost:12345/a/b/c"));
        FileSystem ftpfs = FileSystem.get((URI)URI.create("ftp://localhost:12345/a/b/c"));
        Assert.assertFalse((boolean)(hdfs instanceof LimitedConnectionsFileSystem));
        Assert.assertFalse((boolean)(ftpfs instanceof LimitedConnectionsFileSystem));
        Configuration config = new Configuration();
        config.setInteger("fs.hdfs.limit.total", 40);
        config.setInteger("fs.hdfs.limit.input", 39);
        config.setInteger("fs.hdfs.limit.output", 38);
        config.setInteger("fs.hdfs.limit.timeout", 23456);
        config.setInteger("fs.hdfs.limit.stream-timeout", 34567);
        try {
            FileSystem.initialize((Configuration)config);
            hdfs = FileSystem.get((URI)URI.create("hdfs://localhost:12345/a/b/c"));
            ftpfs = FileSystem.get((URI)URI.create("ftp://localhost:12345/a/b/c"));
            Assert.assertTrue((boolean)(hdfs instanceof LimitedConnectionsFileSystem));
            Assert.assertFalse((boolean)(ftpfs instanceof LimitedConnectionsFileSystem));
            LimitedConnectionsFileSystem limitedFs = (LimitedConnectionsFileSystem)hdfs;
            Assert.assertEquals((long)40L, (long)limitedFs.getMaxNumOpenStreamsTotal());
            Assert.assertEquals((long)39L, (long)limitedFs.getMaxNumOpenInputStreams());
            Assert.assertEquals((long)38L, (long)limitedFs.getMaxNumOpenOutputStreams());
            Assert.assertEquals((long)23456L, (long)limitedFs.getStreamOpenTimeout());
            Assert.assertEquals((long)34567L, (long)limitedFs.getStreamInactivityTimeout());
        }
        finally {
            FileSystem.initialize((Configuration)new Configuration());
        }
    }
}

