/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.fs.hdfs;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import junit.framework.TestCase;
import org.apache.flink.core.fs.FSDataInputStream;
import org.apache.flink.core.fs.FileSystem;
import org.apache.flink.core.fs.Path;
import org.apache.flink.core.fs.RecoverableFsDataOutputStream;
import org.apache.flink.core.fs.RecoverableWriter;
import org.apache.flink.runtime.fs.hdfs.HadoopFileSystem;
import org.apache.flink.runtime.fs.hdfs.HadoopRecoverableWriter;
import org.apache.flink.runtime.util.HadoopUtils;
import org.apache.flink.util.OperatingSystem;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.junit.AfterClass;
import org.junit.Assume;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.mockito.Mockito;

public class HadoopRecoverableWriterOldHadoopWithNoTruncateSupportTest {
    @ClassRule
    public static final TemporaryFolder TEMP_FOLDER = new TemporaryFolder();
    private static MiniDFSCluster hdfsCluster;
    private static FileSystem fileSystem;
    private static Path basePath;

    @BeforeClass
    public static void testHadoopVersion() {
        Assume.assumeTrue((boolean)HadoopUtils.isMaxHadoopVersion((int)2, (int)7));
    }

    @BeforeClass
    public static void verifyOS() {
        Assume.assumeTrue((String)"HDFS cluster cannot be started on Windows without extensions.", (!OperatingSystem.isWindows() ? 1 : 0) != 0);
    }

    @BeforeClass
    public static void createHDFS() throws Exception {
        File baseDir = TEMP_FOLDER.newFolder();
        Configuration hdConf = new Configuration();
        hdConf.set("hdfs.minidfs.basedir", baseDir.getAbsolutePath());
        MiniDFSCluster.Builder builder = new MiniDFSCluster.Builder(hdConf);
        hdfsCluster = builder.build();
        DistributedFileSystem hdfs = hdfsCluster.getFileSystem();
        fileSystem = new HadoopFileSystem((org.apache.hadoop.fs.FileSystem)hdfs);
        basePath = new Path(hdfs.getUri() + "/tests");
    }

    @AfterClass
    public static void destroyHDFS() throws Exception {
        if (hdfsCluster != null) {
            hdfsCluster.getFileSystem().delete(new org.apache.hadoop.fs.Path(basePath.toUri()), true);
            hdfsCluster.shutdown();
        }
    }

    @Test
    public void testWriteAndCommitWorks() throws IOException {
        Path testPath = new Path(basePath, "test-0");
        String expectedContent = "test_line";
        RecoverableWriter writerUnderTest = fileSystem.createRecoverableWriter();
        RecoverableFsDataOutputStream streamUnderTest = this.getOpenStreamToFileWithContent(writerUnderTest, testPath, "test_line");
        streamUnderTest.closeForCommit().commit();
        HadoopRecoverableWriterOldHadoopWithNoTruncateSupportTest.verifyFileContent(testPath, "test_line");
    }

    @Test
    public void testRecoveryAfterClosingForCommitWorks() throws IOException {
        Path testPath = new Path(basePath, "test-1");
        String expectedContent = "test_line";
        RecoverableWriter writerUnderTest = fileSystem.createRecoverableWriter();
        RecoverableFsDataOutputStream streamUnderTest = this.getOpenStreamToFileWithContent(writerUnderTest, testPath, "test_line");
        RecoverableWriter.CommitRecoverable committable = streamUnderTest.closeForCommit().getRecoverable();
        writerUnderTest.recoverForCommit(committable).commitAfterRecovery();
        HadoopRecoverableWriterOldHadoopWithNoTruncateSupportTest.verifyFileContent(testPath, "test_line");
    }

    @Test
    public void testExceptionThrownWhenRecoveringWithInProgressFile() throws IOException {
        RecoverableWriter writerUnderTest = fileSystem.createRecoverableWriter();
        RecoverableFsDataOutputStream stream = writerUnderTest.open(new Path(basePath, "test-2"));
        RecoverableWriter.ResumeRecoverable recoverable = stream.persist();
        TestCase.assertNotNull((Object)recoverable);
        try {
            writerUnderTest.recover(recoverable);
        }
        catch (IOException e) {
            TestCase.assertTrue((boolean)(e.getCause() instanceof IllegalStateException));
        }
    }

    @Test
    public void testRecoverableWriterWithViewfsScheme() {
        org.apache.hadoop.fs.FileSystem mockViewfs = (org.apache.hadoop.fs.FileSystem)Mockito.mock(org.apache.hadoop.fs.FileSystem.class);
        Mockito.when((Object)mockViewfs.getScheme()).thenReturn((Object)"viewfs");
        HadoopRecoverableWriter recoverableWriter = new HadoopRecoverableWriter(mockViewfs);
    }

    private RecoverableFsDataOutputStream getOpenStreamToFileWithContent(RecoverableWriter writerUnderTest, Path path, String expectedContent) throws IOException {
        byte[] content = expectedContent.getBytes(StandardCharsets.UTF_8);
        RecoverableFsDataOutputStream streamUnderTest = writerUnderTest.open(path);
        streamUnderTest.write(content);
        return streamUnderTest;
    }

    private static void verifyFileContent(Path testPath, String expectedContent) throws IOException {
        try (FSDataInputStream in = fileSystem.open(testPath);
             InputStreamReader ir = new InputStreamReader((InputStream)in, StandardCharsets.UTF_8);
             BufferedReader reader = new BufferedReader(ir);){
            String line = reader.readLine();
            TestCase.assertEquals((String)expectedContent, (String)line);
        }
    }
}

