/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.fs.hdfs;

import org.apache.flink.core.fs.FileSystemBehaviorTestSuite;
import org.apache.flink.core.fs.FileSystemKind;
import org.apache.flink.core.fs.Path;
import org.apache.flink.core.fs.local.LocalFileSystem;
import org.apache.flink.runtime.fs.hdfs.HadoopFileSystem;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.RawLocalFileSystem;
import org.apache.hadoop.util.VersionInfo;
import org.junit.Assume;
import org.junit.Rule;
import org.junit.rules.TemporaryFolder;

public class HadoopLocalFileSystemBehaviorTest
extends FileSystemBehaviorTestSuite {
    @Rule
    public final TemporaryFolder tmp = new TemporaryFolder();

    public org.apache.flink.core.fs.FileSystem getFileSystem() throws Exception {
        RawLocalFileSystem fs = new RawLocalFileSystem();
        fs.initialize(LocalFileSystem.getLocalFsURI(), new Configuration());
        return new HadoopFileSystem((FileSystem)fs);
    }

    public Path getBasePath() throws Exception {
        return new Path(this.tmp.newFolder().toURI());
    }

    public FileSystemKind getFileSystemKind() {
        return FileSystemKind.FILE_SYSTEM;
    }

    public void testMkdirsFailsForExistingFile() throws Exception {
        String versionString = VersionInfo.getVersion();
        String prefix = versionString.substring(0, 3);
        float version = Float.parseFloat(prefix);
        Assume.assumeTrue((String)"Cannot execute this test on Hadoop prior to 2.8", (version >= 2.8f ? 1 : 0) != 0);
        super.testMkdirsFailsForExistingFile();
    }
}

