/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.formats.hadoop.bulk;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.core.fs.Path;
import org.apache.flink.core.io.SimpleVersionedSerializer;
import org.apache.flink.formats.hadoop.bulk.HadoopFileCommitter;
import org.apache.flink.formats.hadoop.bulk.HadoopFileCommitterFactory;
import org.apache.flink.formats.hadoop.bulk.HadoopPathBasedBulkWriter;
import org.apache.flink.streaming.api.functions.sink.filesystem.AbstractPartFileWriter;
import org.apache.flink.streaming.api.functions.sink.filesystem.BucketWriter;
import org.apache.flink.streaming.api.functions.sink.filesystem.InProgressFileWriter;
import org.apache.flink.streaming.api.functions.sink.filesystem.WriterProperties;
import org.apache.hadoop.conf.Configuration;

public class HadoopPathBasedPartFileWriter<IN, BucketID>
extends AbstractPartFileWriter<IN, BucketID> {
    private final HadoopPathBasedBulkWriter<IN> writer;
    private final HadoopFileCommitter fileCommitter;

    public HadoopPathBasedPartFileWriter(BucketID bucketID, HadoopPathBasedBulkWriter<IN> writer, HadoopFileCommitter fileCommitter, long createTime) {
        super(bucketID, createTime);
        this.writer = writer;
        this.fileCommitter = fileCommitter;
    }

    public void write(IN element, long currentTime) throws IOException {
        this.writer.addElement(element);
        this.markWrite(currentTime);
    }

    public InProgressFileWriter.InProgressFileRecoverable persist() {
        throw new UnsupportedOperationException("The path based writers do not support persisting");
    }

    public InProgressFileWriter.PendingFileRecoverable closeForCommit() throws IOException {
        this.writer.flush();
        this.writer.finish();
        this.fileCommitter.preCommit();
        return new HadoopPathBasedPendingFile(this.fileCommitter).getRecoverable();
    }

    public void dispose() {
        this.writer.dispose();
    }

    public long getSize() throws IOException {
        return this.writer.getSize();
    }

    public static class HadoopPathBasedBucketWriter<IN, BucketID>
    implements BucketWriter<IN, BucketID> {
        private final Configuration configuration;
        private final HadoopPathBasedBulkWriter.Factory<IN> bulkWriterFactory;
        private final HadoopFileCommitterFactory fileCommitterFactory;

        public HadoopPathBasedBucketWriter(Configuration configuration, HadoopPathBasedBulkWriter.Factory<IN> bulkWriterFactory, HadoopFileCommitterFactory fileCommitterFactory) {
            this.configuration = configuration;
            this.bulkWriterFactory = bulkWriterFactory;
            this.fileCommitterFactory = fileCommitterFactory;
        }

        public HadoopPathBasedPartFileWriter<IN, BucketID> openNewInProgressFile(BucketID bucketID, Path flinkPath, long creationTime) throws IOException {
            org.apache.hadoop.fs.Path path = new org.apache.hadoop.fs.Path(flinkPath.toUri());
            HadoopFileCommitter fileCommitter = this.fileCommitterFactory.create(this.configuration, path);
            org.apache.hadoop.fs.Path inProgressFilePath = fileCommitter.getTempFilePath();
            HadoopPathBasedBulkWriter<IN> writer = this.bulkWriterFactory.create(path, inProgressFilePath);
            return new HadoopPathBasedPartFileWriter<IN, BucketID>(bucketID, writer, fileCommitter, creationTime);
        }

        public BucketWriter.PendingFile recoverPendingFile(InProgressFileWriter.PendingFileRecoverable pendingFileRecoverable) throws IOException {
            if (!(pendingFileRecoverable instanceof HadoopPathBasedPendingFileRecoverable)) {
                throw new UnsupportedOperationException("Only HadoopPathBasedPendingFileRecoverable is supported.");
            }
            HadoopPathBasedPendingFileRecoverable hadoopRecoverable = (HadoopPathBasedPendingFileRecoverable)pendingFileRecoverable;
            return new HadoopPathBasedPendingFile(this.fileCommitterFactory.recoverForCommit(this.configuration, hadoopRecoverable.getTargetFilePath(), hadoopRecoverable.getTempFilePath()));
        }

        public WriterProperties getProperties() {
            return new WriterProperties((SimpleVersionedSerializer)UnsupportedInProgressFileRecoverableSerializable.INSTANCE, (SimpleVersionedSerializer)HadoopPathBasedPendingFileRecoverableSerializer.INSTANCE, false);
        }

        public InProgressFileWriter<IN, BucketID> resumeInProgressFileFrom(BucketID bucketID, InProgressFileWriter.InProgressFileRecoverable inProgressFileSnapshot, long creationTime) {
            throw new UnsupportedOperationException("Resume is not supported");
        }

        public boolean cleanupInProgressFileRecoverable(InProgressFileWriter.InProgressFileRecoverable inProgressFileRecoverable) {
            return false;
        }
    }

    private static class UnsupportedInProgressFileRecoverableSerializable
    implements SimpleVersionedSerializer<InProgressFileWriter.InProgressFileRecoverable> {
        static final UnsupportedInProgressFileRecoverableSerializable INSTANCE = new UnsupportedInProgressFileRecoverableSerializable();

        private UnsupportedInProgressFileRecoverableSerializable() {
        }

        public int getVersion() {
            throw new UnsupportedOperationException("Persists the path-based part file write is not supported");
        }

        public byte[] serialize(InProgressFileWriter.InProgressFileRecoverable obj) {
            throw new UnsupportedOperationException("Persists the path-based part file write is not supported");
        }

        public InProgressFileWriter.InProgressFileRecoverable deserialize(int version, byte[] serialized) {
            throw new UnsupportedOperationException("Persists the path-based part file write is not supported");
        }
    }

    @VisibleForTesting
    static class HadoopPathBasedPendingFileRecoverableSerializer
    implements SimpleVersionedSerializer<InProgressFileWriter.PendingFileRecoverable> {
        static final HadoopPathBasedPendingFileRecoverableSerializer INSTANCE = new HadoopPathBasedPendingFileRecoverableSerializer();
        private static final Charset CHARSET = StandardCharsets.UTF_8;
        private static final int MAGIC_NUMBER = 746929296;

        HadoopPathBasedPendingFileRecoverableSerializer() {
        }

        public int getVersion() {
            return 1;
        }

        public byte[] serialize(InProgressFileWriter.PendingFileRecoverable pendingFileRecoverable) {
            if (!(pendingFileRecoverable instanceof HadoopPathBasedPendingFileRecoverable)) {
                throw new UnsupportedOperationException("Only HadoopPathBasedPendingFileRecoverable is supported.");
            }
            HadoopPathBasedPendingFileRecoverable hadoopRecoverable = (HadoopPathBasedPendingFileRecoverable)pendingFileRecoverable;
            org.apache.hadoop.fs.Path path = hadoopRecoverable.getTargetFilePath();
            org.apache.hadoop.fs.Path inProgressPath = hadoopRecoverable.getTempFilePath();
            byte[] pathBytes = path.toUri().toString().getBytes(CHARSET);
            byte[] inProgressBytes = inProgressPath.toUri().toString().getBytes(CHARSET);
            byte[] targetBytes = new byte[12 + pathBytes.length + inProgressBytes.length];
            ByteBuffer bb = ByteBuffer.wrap(targetBytes).order(ByteOrder.LITTLE_ENDIAN);
            bb.putInt(746929296);
            bb.putInt(pathBytes.length);
            bb.put(pathBytes);
            bb.putInt(inProgressBytes.length);
            bb.put(inProgressBytes);
            return targetBytes;
        }

        public HadoopPathBasedPendingFileRecoverable deserialize(int version, byte[] serialized) throws IOException {
            switch (version) {
                case 1: {
                    return this.deserializeV1(serialized);
                }
            }
            throw new IOException("Unrecognized version or corrupt state: " + version);
        }

        private HadoopPathBasedPendingFileRecoverable deserializeV1(byte[] serialized) throws IOException {
            ByteBuffer bb = ByteBuffer.wrap(serialized).order(ByteOrder.LITTLE_ENDIAN);
            if (bb.getInt() != 746929296) {
                throw new IOException("Corrupt data: Unexpected magic number.");
            }
            byte[] targetFilePathBytes = new byte[bb.getInt()];
            bb.get(targetFilePathBytes);
            String targetFilePath = new String(targetFilePathBytes, CHARSET);
            byte[] tempFilePathBytes = new byte[bb.getInt()];
            bb.get(tempFilePathBytes);
            String tempFilePath = new String(tempFilePathBytes, CHARSET);
            return new HadoopPathBasedPendingFileRecoverable(new org.apache.hadoop.fs.Path(targetFilePath), new org.apache.hadoop.fs.Path(tempFilePath));
        }
    }

    @VisibleForTesting
    static class HadoopPathBasedPendingFileRecoverable
    implements InProgressFileWriter.PendingFileRecoverable {
        private final org.apache.hadoop.fs.Path targetFilePath;
        private final org.apache.hadoop.fs.Path tempFilePath;

        public HadoopPathBasedPendingFileRecoverable(org.apache.hadoop.fs.Path targetFilePath, org.apache.hadoop.fs.Path tempFilePath) {
            this.targetFilePath = targetFilePath;
            this.tempFilePath = tempFilePath;
        }

        public org.apache.hadoop.fs.Path getTargetFilePath() {
            return this.targetFilePath;
        }

        public org.apache.hadoop.fs.Path getTempFilePath() {
            return this.tempFilePath;
        }
    }

    static class HadoopPathBasedPendingFile
    implements BucketWriter.PendingFile {
        private final HadoopFileCommitter fileCommitter;

        public HadoopPathBasedPendingFile(HadoopFileCommitter fileCommitter) {
            this.fileCommitter = fileCommitter;
        }

        public void commit() throws IOException {
            this.fileCommitter.commit();
        }

        public void commitAfterRecovery() throws IOException {
            this.fileCommitter.commitAfterRecovery();
        }

        public InProgressFileWriter.PendingFileRecoverable getRecoverable() {
            return new HadoopPathBasedPendingFileRecoverable(this.fileCommitter.getTargetFilePath(), this.fileCommitter.getTempFilePath());
        }
    }
}

