/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.graph.utils.proxy;

public class OptionalBoolean {
    private State state = State.UNSET;
    private final boolean valueIfUnset;
    private final boolean valueIfConflicting;

    public OptionalBoolean(boolean valueIfUnset, boolean valueIfConflicting) {
        this.valueIfUnset = valueIfUnset;
        this.valueIfConflicting = valueIfConflicting;
    }

    public boolean get() {
        switch (this.state) {
            case UNSET: {
                return this.valueIfUnset;
            }
            case FALSE: {
                return false;
            }
            case TRUE: {
                return true;
            }
            case CONFLICTING: {
                return this.valueIfConflicting;
            }
        }
        throw new RuntimeException("Unknown state");
    }

    public void set(boolean value) {
        this.state = value ? State.TRUE : State.FALSE;
    }

    public void unset() {
        this.state = State.UNSET;
    }

    protected State getState() {
        return this.state;
    }

    public boolean conflictsWith(OptionalBoolean other) {
        return this.state == State.CONFLICTING || other.state == State.CONFLICTING || this.state == State.TRUE && other.state == State.FALSE || this.state == State.FALSE && other.state == State.TRUE;
    }

    public void mergeWith(OptionalBoolean other) {
        if (this.state != other.state) {
            if (this.state == State.UNSET) {
                this.state = other.state;
            } else if (other.state != State.UNSET) {
                this.state = State.CONFLICTING;
            }
        }
    }

    protected static enum State {
        UNSET,
        FALSE,
        TRUE,
        CONFLICTING;

    }
}

