/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.graph.types.valuearray;

import java.io.IOException;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.typeutils.TypeComparator;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.core.memory.MemorySegment;
import org.apache.flink.graph.types.valuearray.ShortValueArray;
import org.apache.flink.types.NormalizableKey;

@Internal
public class ShortValueArrayComparator
extends TypeComparator<ShortValueArray> {
    private static final long serialVersionUID = 1L;
    private final boolean ascendingComparison;
    private final ShortValueArray reference = new ShortValueArray();
    private final TypeComparator<?>[] comparators = new TypeComparator[]{this};

    public ShortValueArrayComparator(boolean ascending) {
        this.ascendingComparison = ascending;
    }

    public int hash(ShortValueArray record) {
        return record.hashCode();
    }

    public void setReference(ShortValueArray toCompare) {
        toCompare.copyTo(this.reference);
    }

    public boolean equalToReference(ShortValueArray candidate) {
        return candidate.equals(this.reference);
    }

    public int compareToReference(TypeComparator<ShortValueArray> referencedComparator) {
        int comp = ((ShortValueArrayComparator)referencedComparator).reference.compareTo(this.reference);
        return this.ascendingComparison ? comp : -comp;
    }

    public int compare(ShortValueArray first, ShortValueArray second) {
        int comp = first.compareTo(second);
        return this.ascendingComparison ? comp : -comp;
    }

    public int compareSerialized(DataInputView firstSource, DataInputView secondSource) throws IOException {
        int firstCount = firstSource.readInt();
        int secondCount = secondSource.readInt();
        int minCount = Math.min(firstCount, secondCount);
        while (minCount-- > 0) {
            short secondValue;
            short firstValue = firstSource.readShort();
            int cmp = Short.compare(firstValue, secondValue = secondSource.readShort());
            if (cmp == 0) continue;
            return this.ascendingComparison ? cmp : -cmp;
        }
        int cmp = Integer.compare(firstCount, secondCount);
        return this.ascendingComparison ? cmp : -cmp;
    }

    public boolean supportsNormalizedKey() {
        return NormalizableKey.class.isAssignableFrom(ShortValueArray.class);
    }

    public int getNormalizeKeyLen() {
        return this.reference.getMaxNormalizedKeyLen();
    }

    public boolean isNormalizedKeyPrefixOnly(int keyShorts) {
        return keyShorts < this.getNormalizeKeyLen();
    }

    public void putNormalizedKey(ShortValueArray record, MemorySegment target, int offset, int numShorts) {
        record.copyNormalizedKey(target, offset, numShorts);
    }

    public boolean invertNormalizedKey() {
        return !this.ascendingComparison;
    }

    public TypeComparator<ShortValueArray> duplicate() {
        return new ShortValueArrayComparator(this.ascendingComparison);
    }

    public int extractKeys(Object record, Object[] target, int index) {
        target[index] = record;
        return 1;
    }

    public TypeComparator<?>[] getFlatComparators() {
        return this.comparators;
    }

    public boolean supportsSerializationWithKeyNormalization() {
        return false;
    }

    public void writeWithKeyNormalization(ShortValueArray record, DataOutputView target) throws IOException {
        throw new UnsupportedOperationException();
    }

    public ShortValueArray readWithKeyDenormalization(ShortValueArray reuse, DataInputView source) throws IOException {
        throw new UnsupportedOperationException();
    }
}

