/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.graph.types.valuearray;

import java.io.IOException;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.typeutils.TypeComparator;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.core.memory.MemorySegment;
import org.apache.flink.graph.types.valuearray.NullValueArray;
import org.apache.flink.types.NormalizableKey;

@Internal
public class NullValueArrayComparator
extends TypeComparator<NullValueArray> {
    private static final long serialVersionUID = 1L;
    private final boolean ascendingComparison;
    private final NullValueArray reference = new NullValueArray();
    private final TypeComparator<?>[] comparators = new TypeComparator[]{this};

    public NullValueArrayComparator(boolean ascending) {
        this.ascendingComparison = ascending;
    }

    public int hash(NullValueArray record) {
        return record.hashCode();
    }

    public void setReference(NullValueArray toCompare) {
        toCompare.copyTo(this.reference);
    }

    public boolean equalToReference(NullValueArray candidate) {
        return candidate.equals(this.reference);
    }

    public int compareToReference(TypeComparator<NullValueArray> referencedComparator) {
        int comp = ((NullValueArrayComparator)referencedComparator).reference.compareTo(this.reference);
        return this.ascendingComparison ? comp : -comp;
    }

    public int compare(NullValueArray first, NullValueArray second) {
        int comp = first.compareTo(second);
        return this.ascendingComparison ? comp : -comp;
    }

    public int compareSerialized(DataInputView firstSource, DataInputView secondSource) throws IOException {
        int firstCount = firstSource.readInt();
        int secondCount = secondSource.readInt();
        int cmp = Integer.compare(firstCount, secondCount);
        return this.ascendingComparison ? cmp : -cmp;
    }

    public boolean supportsNormalizedKey() {
        return NormalizableKey.class.isAssignableFrom(NullValueArray.class);
    }

    public int getNormalizeKeyLen() {
        return this.reference.getMaxNormalizedKeyLen();
    }

    public boolean isNormalizedKeyPrefixOnly(int keyBytes) {
        return keyBytes < this.getNormalizeKeyLen();
    }

    public void putNormalizedKey(NullValueArray record, MemorySegment target, int offset, int numBytes) {
        record.copyNormalizedKey(target, offset, numBytes);
    }

    public boolean invertNormalizedKey() {
        return !this.ascendingComparison;
    }

    public TypeComparator<NullValueArray> duplicate() {
        return new NullValueArrayComparator(this.ascendingComparison);
    }

    public int extractKeys(Object record, Object[] target, int index) {
        target[index] = record;
        return 1;
    }

    public TypeComparator<?>[] getFlatComparators() {
        return this.comparators;
    }

    public boolean supportsSerializationWithKeyNormalization() {
        return false;
    }

    public void writeWithKeyNormalization(NullValueArray record, DataOutputView target) throws IOException {
        record.write(target);
    }

    public NullValueArray readWithKeyDenormalization(NullValueArray reuse, DataInputView source) throws IOException {
        reuse.read(source);
        return reuse;
    }
}

